(function (library) {
    // Calls the second IIFE and locally passes in the global jQuery, window, and document objects
    library(window, document, window.jQuery);
}
// Locally scoped parameters 
(function (window, document, $) {
//INIT VARIABLES
dashexpert_api.widgets = dashexpert_api.widgets || {};
dashexpert_api.widgets.types = dashexpert_api.widgets.types || [];
dashexpert_api.widgets.xref = dashexpert_api.widgets.xref || {};
dashexpert_api.widget_preferences = dashexpert_api.widget_preferences || {};
//SET VARIABLES
var widgettype = 'table';
dashexpert_api.widgets.types.push(widgettype);
dashexpert_api.widget_preferences[widgettype] = {
    data_mapping: 'single', // none,single,multi
    searchable: true,
    iconclass: 'fa-table',
    cache: true,
    blacklist: [],
    SearchIndicator: true,
    restrictSearch: []
};
dashexpert_api.widgets.xref[widgettype] = 'Table';
dashexpert_api.widgets[widgettype] = {  // [Label,type,{default|hint|options|errorcheck}]
    apistring : ['apistring','textarea',{
      default : '',
      hint : 'This is the current APIString defined by the datasource.  Changes made here will override the datasource.  We recommend that you always use the following option of "rating": "2" in order to display color and formatting correctly.  This string is used to get the data that will be used for creating the widget.',
      errorcheck : [['json','API String must be valid JSON.']]
    }],
    sortable : ['Sortable','checkbox',{default : true,hint : 'Make column headings sortable.'}],
    pagination : ['Pagination','checkbox',{default : false,hint : 'Add pagination to bottom of table.'}],
    plimit : ['Limit','checkbox',{default : false,hint : 'Add Limit dropdown for limiting how many records per page.'}],
    condensed : ['Condensed','checkbox',{default : true,hint : 'Condensed table spacing.'}],
    searching : ['Search','checkbox',{default : false,hint : 'Add search to table.'}],
    enable360 : ['Enable 360 popout','checkbox',{default : true,hint : 'Enable popout from table data to Advanced Inspector.'}],
    limithighlight : ['Highlighting','checkbox',{default : false,hint : 'Highlight table rows based on limits.'}],
    good_bgcolor : ['Good Background Color','color',{default : '#5cb85c',group : 'limithighlight'}],
    good_txtcolor : ['Good Text Color','color',{default : '#ffffff',group : 'limithighlight'}],
    fair_bgcolor : ['Fair Background Color','color',{default : '#f0ad4e',group : 'limithighlight'}],
    fair_txtcolor : ['Fair Text Color','color',{default : '#ffffff',group : 'limithighlight'}],
    poor_bgcolor : ['Poor Background Color','color',{default : '#d9534f',group : 'limithighlight'}],
    poor_txtcolor : ['Poor Text Color','color',{default : '#ffffff',group : 'limithighlight'}],
    reverse : ['Reverse','checkbox',{default : false,hint : 'If <em>checked</em> Low limit = POOR and High Limit = GOOD.  If <em>not checked</em>, then Low limit = GOOD and High Limit = POOR.',group : 'limithighlight'}]
};
var extended = {};
extended.baseurl = '/lwl/dashboard.cgi?run_tab=62&run_me=query:79&run_by=jquery';
extended.searchlist = ['node_name','user_name','application_name','node_group_name'];
extended.urlparams = {
    date_93 : 'Today%20and%20Yesterday',
    search_date : '',
    date_plus_days : '0'
}

//FUNCTIONS
var getDefaults = function(){
    var options = {};
    $.each(dashexpert_api.widgets[widgettype], function(key,val) {
        options[key] = val[2].default;
    });
    return options;
};
var evalScore = function(number,limits,reverse) {
    var score;
    if(reverse) {  // low = poor, high = good
        if(number <= limits.l) {
            score = 'poor';
        } else {
            if(number < limits.h) {
                score = 'fair';
            } else {
                score = 'good';
            }
        }  
    } else { // low = good, high = poor
        if(number <= limits.m) {
            score = 'good';
        } else {
            if(number < limits.h) {
                score = 'fair';
            } else {
                score = 'poor';
            }
        }
    }
    return score;
};
var formatTableCell = function(value,obj,key) {
    var tdstyle = '';
    var spanstyle = '';
    var tip = '';
    var unit = '';
    var symbol = '';
    var original = '';
    var html ='';
    if(obj.a) { // Alignment
        switch(obj.a) {
          case 'c' : tdstyle += 'text-align: center;';
            break;
          case 'l' : tdstyle += 'text-align: left;';
            break;
          case 'r' : tdstyle += 'text-align: right;';
            break;
        }
    }
    if(obj.c) { // Cell color
        tdstyle += 'background-color: ' + obj.c + ';';
    }
    if(obj.t) { // Text color
        spanstyle += 'color: ' + obj.t + ';';
    }
    if(obj.s) { // Span color
        spanstyle += 'background-color: ' + obj.s + ';';
    }
    if(obj.tip) { // Tooltip
        tip += ' data-toggle="tooltip" title="' + obj.tip + '"';
    }
    if(obj.d) {
        symbol += obj.d;
    }
    if(obj.u) {
        unit += obj.u;
    }
    if(obj.orig) {
        original += obj.orig;
    }
    html = '\t\t\t<td data-key="' + key + '" data-sort="' + original + '" style="' + tdstyle + '"><span style="' + spanstyle + '" ' + tip + '>';
    if($.inArray(key,extended.searchlist) !== -1) {
        html += '<a href="">' + value + unit + symbol + '</a>';
    } else {
        html += value + unit + symbol;
    }
    html += '</span></td>\n';
    return html;
};
var createDisplayData = function(table,xref,dcolumns) {
    var result = {};
    if(!dcolumns) {
        result.xref = xref;
        result.table = table;
    } else {
        $.each(xref, function(key) {
            if(dcolumns.indexOf(key) === -1) {
                delete xref[key];
            }
        });
        result.xref = xref;
        $.each(table, function(i) {
            $.each(table[i], function(key) {
                if(dcolumns.indexOf(key) === -1) {
                    delete table[i][key];
                }
            });
        });
        result.table = table;
    }
    return result;
};
var createStyle = function(opt,target) {
    dashexpert_api.init.tablestyles = dashexpert_api.init.tablestyles || [];
    if(dashexpert_api.init.tablestyles.indexOf(target) === -1) {
        dashexpert_api.init.tablestyles.push(target);
        var style = '<style type="text/css" data-target="' + target + '">\n';
        style += '\t#' + target + ' tr.good_score, #' + target + ' tr.odd.good_score td, #' + target + ' tr.even.good_score td { background-color: ' + opt.good_bgcolor + '; color: ' + opt.good_txtcolor + ' }\n';
        style += '\t#' + target + ' tr.fair_score, #' + target + ' tr.odd.fair_score td, #' + target + ' tr.even.fair_score td { background-color: ' + opt.fair_bgcolor + '; color: ' + opt.fair_txtcolor + ' }\n';
        style += '\t#' + target + ' tr.poor_score, #' + target + ' tr.odd.poor_score td, #' + target + ' tr.even.poor_score td { background-color: ' + opt.poor_bgcolor + '; color: ' + opt.poor_txtcolor + ' }\n';
        style += '<style>\n';
        $('head').append(style);
    }
};
var create = function(widget,vid,options) { // pass widget object and vid (target) options { preview: true|false }
    var toptions = options || {};
    var apistring;
    var map = amplify.store('map_' + vid);
    if(toptions.type === 'multitable' && typeof map === 'object') {
        apistring = atob(map[toptions.wid]);
    } else {
        apistring = atob(amplify.store('map_' + vid)); //get APIString
    }
    var data = amplify.store(btoa(apistring)); //get Data from encoded APIString
    if(data !== undefined) {
        apistring = JSON.parse(apistring); // parse to object
        var target = 'widget_' + vid;
        if(toptions.preview) {
            target = options.target || 'ext-dashboard-modal-widget';
        }
        $('#' + target).addClass('widget-table');
        if(!widget.displaycols) {
            widget.displaycols = apistring.columns.split(',');
        }
        var basis_columns = data.basis_columns.split(',');
        $.each(basis_columns, function(i) { // add basis to display columns
            widget.displaycols.push(basis_columns[i]);
        });
        var ndata = createDisplayData(data.table,data.xref,widget.displaycols);
        var tdata = ndata.table;
        var xref = ndata.xref;
        var column_desc = amplify.store('column_desc');
        var col = 0;
        var sortcol = 0;
        var sortorder = "asc";
        if(apistring.sort_order == "2") {
        //if(apistring.sort_order == "2" || toptions.preview) {
            sortorder = "desc";
        } 
        var htmltable = '<table class="table table-striped table-hover">\n\t<thead>\n';
        htmltable += '\t\t<tr>\n';
        $.each(xref, function(key) {
            if(key === apistring.sort_col) {
                sortcol = col;
            }
            col++;
            htmltable += '\t\t\t<th data-key="' + key + '" title="' + column_desc[key] + '">' + xref[key] + '</th>\n';
        });
        htmltable += '\t\t</tr>\n';
        htmltable += '\t</thead>\n';
        htmltable += '\t<tbody>\n';
        $.each(tdata, function(key) {
            htmltable += '\t\t<tr>\n';
            var row = tdata[key];
            $.each(row, function(key){
                if(apistring.rating == '2' || apistring.rating == '3') {
                    var value = row[key][0];
                    var formatting = row[key][1];
                    htmltable += formatTableCell(value,formatting,key);
                } else {
                    var value = row[key];
                    htmltable += '\t\t\t<td data-key="' + key + '">' + value + '</td>\n';
                }
            });
            htmltable += '\t\t</tr>\n';
        });
        htmltable += '\t</tbody>\n';
        htmltable += '</table>';
        if(toptions.type !== 'multitable') {
            $('#' + target + ' .panel-heading').attr("title", vid);
            $('#' + target + ' .panel-heading .panel-title span:first').html(widget.title);
        }
        $('#' + target + ' .panel-body').html(htmltable);
        var opt = {};
        opt.fixedHeader = {
            header: true,
            footer: false
        };
        if(widget.options.sortable || toptions.preview) {
            opt = {
                paging : false,
                searching : false,
                order : [[sortcol, sortorder]]
            };
        }
        if(widget.options.searching) {
            opt.searching = true;
        }
        if(toptions.preview) {
            opt.searching = true;
            opt.paging = true;
        }
        if(widget.options.pagination) {
            opt.paging = true;
        }
        if(!widget.options.plimit) {
            opt.lengthChange = false;
        }
        if(widget.options.condensed) {
            $('#' + target + ' table').addClass('table-condensed');
        }
        $('#' + target + ' table').DataTable(opt);
        //$('[data-toggle="tooltip"]').tooltip({container: 'body', html: true, placement: 'auto'});
        if(widget.options.enable360 || widget.options.enable360 === undefined) {
            $('#' + target + ' table').on('click','a', function(e) {
                e.preventDefault();
                var search = $(this).parent().parent().data('key');
                search += '=' + $(this).text();
                function popitup(search) {
                    var ext = '';
                    $.each(extended.urlparams, function(k,v){
                        ext += '&' + k + '=' + v;
                    });
                    var url = dashexpert_api.settings.apidomain + extended.baseurl + ext + '&ssid=' + dashexpert_api.ssid + '&p=&search_' + search;
                    var newwindow=window.open(url,'360','height=600,width=1200');
                    if(window.focus) {
                        newwindow.focus();
                    }
                    return false;
                 }
                 popitup(search);
            });
        } else {
            $('#' + target + ' table').on('click', 'a', function(e) {
                e.preventDefault();
            });
        }
        if(widget.options.limithighlight) {
            // ADD CODE TO HIGHLIGHT TABLE ROWS <------
            // get all TR in tbody
            var limits = {};
            if('h_limit' in widget) {
                limits.h = widget.h_limit;
                limits.m = widget.m_limit;
                if(widget.l_limit) {
                    limits.l = widget.l_limit;
                } else {
                    limits.l = 0;
                }
            } else {
                limits.h = widget.options.h_limit;
                limits.m = widget.options.m_limit;
                if(widget.options.l_limit) {
                    limits.l = widget.options.l_limit;
                } else {
                    limits.l = 0;
                }
            }
            var score;
            var trows = $('#' + target + ' table tbody tr');
            var sortchild = sortcol + 1;
            var cval = 0;
            createStyle(widget.options,target);
            $.each(trows, function(i) {
                cval = $(trows[i]).find('[data-key="' + widget.dcolumn + '"]').data('sort');
                //cval = $(trows[i]).find('td:nth-child(' + sortchild + ')').data('sort');
                score = evalScore(parseFloat(cval),limits,widget.options.reverse);
                //$(trows[i]).attr('style','background-color:' + widget.options[score + '_bgcolor'] + ';color:' +  widget.options[score + '_txtcolor']);
                $(trows[i]).addClass(score + '_score');
            });
        }
        dashexpert_api.util.debugOut('Build table: ' + widget.title);
    }
    
};
var remove = function() {

};
var update = function() {
    
};

// ON DOCUMENT READY
$(document).ready(function() {
   dashexpert_api.util.debugOut(widgettype + ' plugin loaded.');
});
// EXPOSE PUBLIC FUNCTIONS
dashexpert_api.fn.widgets[widgettype] = {
    create : create,
    delete : remove,
    update : update
}
// END Library code
}));