(function (library) {
    // Calls the second IIFE and locally passes in the global jQuery, window, and document objects
    library(window, document, window.jQuery);
}
// Locally scoped parameters 
(function (window, document, $) {
//VARIABLES
dashexpert_api.widgets = dashexpert_api.widgets || {};
dashexpert_api.widgets.types = dashexpert_api.widgets.types || [];
dashexpert_api.widgets.xref = dashexpert_api.widgets.xref || {};
dashexpert_api.widget_preferences = dashexpert_api.widget_preferences || {};

var widgettype = 'sparkline';
dashexpert_api.widgets.types.push(widgettype);
dashexpert_api.widget_preferences[widgettype] = {
    data_mapping: 'single', // none,single,multi
    searchable: true,
    iconclass: 'fa-area-chart',
    cache: true,
    blacklist: [],
    SearchIndicator: true,
    restrictSearch: []
};
dashexpert_api.widgets.xref[widgettype] = 'Sparkline';
dashexpert_api.widgets[widgettype] = {  // [Label,type,{default|hint|options|errorcheck}]
    apistring : ['apistring','textarea',{
      default : '',
      hint : 'This is the current APIString defined by the datasource.  Changes made here will override the datasource.  We recommend that you always use the following option of "rating": "2" in order to display color and formatting correctly.  This string is used to get the data that will be used for creating the widget.',
      errorcheck : [['json','API String must be valid JSON.']]
    }],
    width : ['Width','text',{default : '100%',hint : 'Width of Chart in pixels or %. '}],
    type : ['Type','hidden',{default : 'line'}],
    info : ['Display Extended Info','checkbox',{default : false,hint : 'Display Extended info as a popup'}],
    lineColor : ['Line Color','color',{default : '#4172c4',hint : 'Color of sparkline in HTML color format.'}],
    lineWidth : ['Line Width','text',{default : '1.5',hint : 'Width of sparkline in pixels.'}],
    fillColor : ['Fill Color','color',{default : '#85b0dd',hint : 'Color of sparkline area in HTML color format.'}],
    spotColor : ['Spot Color','color',{default : '#f08000',hint : 'Color data points on sparkline in HTML color format.'}],
    minSpotColor : ['Min Spot Color','color',{default : '#f08000',hint : 'Color min data point on sparkline in HTML color format.'}],
    maxSpotColor : ['Max Spot Color','color',{default : '#f08000',hint : 'Color max data point on sparkline in HTML color format.'}],
    highlightSpotColor : ['Highlight Spot Color','color',{default : '#f08000',hint : 'Color highlighted point on sparkline in HTML color format.'}],
    highlightLineColor : ['Highlight Line Color','color',{default : '#f08000',hint : 'Color highlighted vertical line on sparkline in HTML color format.'}],
    spotRadius : ['Spot Radius','text',{default : '2.5',hint : 'Size of the spots on the sparkline.'}],
    normalRangeMin : ['Normal Range Min','text',{default : '0',hint : 'Used to show normal starting range.'}],
    normalRangeMax : ['Normal Range Max','text',{default : '0',hint : 'Used to show normal max range.  If set to a number larger than the <em>Normal Range Min</em>, it will create a filled area behind the sparkline between those two numbers.'}]
};
//WIDGET SPECIFIC FUNCTIONS
var getDefaults = function(){
    var options = {};
    $.each(dashexpert_api.widgets[widgettype], function(key,val) {
        options[key] = val[2].default;
    });
    return options;
};
var redrawSparksBars = function() {
    var sparks = $('#' + dashexpert_api.settings.currentdash + ' .widget-spark');
    var bars = $('#' + dashexpert_api.settings.currentdash + ' .widget-bar');
    var widgets = amplify.store('widgets');
    $.each(sparks, function() {
        var wid = $(this).parent().data('wid');
        var vid = $(this).parent().data('vid');
        $('#widget_' + vid + ' .panel-body').empty();
        var exists = dashexpert_api.fn.dataExists(vid,{autoload:true,wid:wid});
        if(exists) {
            dashexpert_api.fn.widgets.sparkline.create(widgets[wid],vid);
        }
    });
    $.each(bars, function() {
        var wid = $(this).parent().data('wid');
        var vid = $(this).parent().data('vid');
        $('#widget_' + vid + ' .panel-body').empty();
        var exists = dashexpert_api.fn.dataExists(vid,{autoload:true,wid:wid});
        if(exists) {
            dashexpert_api.fn.widgets.barchart.create(widgets[wid],vid);
        }
    });
}
// API Functions
var create = function(widget,vid) { // pass widget object and vid (target)
    var apistring = atob(amplify.store('map_' + vid)); //get APIString
    var data = amplify.store(btoa(apistring)); //get Data from encoded APIString
    apistring = JSON.parse(apistring); // parse to object
    var target = 'widget_' + vid;
    $('#' + target).addClass('widget-spark');

    var sparkdata = [];
    var columns = '';
    var datacolumn;
    if('dcolumn' in widget.options) {
        widget.dcolumn = widget.options.dcolumn;
    }
    if(widget.dcolumn) {
        if(widget.dcolumn && data.table[0][widget.dcolumn]) {
            datacolumn = widget.dcolumn;
        }
        else {
           if(columns === '' && 'sort_col' in apistring) {
                columns = apistring.sort_col;
            } else {
                columns = data.columns.split(',');
            }
            datacolumn = columns;
            if(data.columns.indexOf(',') > -1) {
                datacolumn = columns[0];
            } 
        }
    } else {
        if(widget.dcolumn && data.table[0][widget.dcolumn]) {
            datacolumn = widget.dcolumn;
        }
        else {
           if(columns === '' && 'sort_col' in apistring) {
                columns = apistring.sort_col;
            } else {
                columns = data.columns.split(',');
            }
            datacolumn = columns;
            if(data.columns.indexOf(',') > -1) {
                datacolumn = columns[0];
            } 
        }
    }
    
    var sprkoptions = getDefaults();

    $.each(widget.options, function(key,val) {
        sprkoptions[key] = val;
    });
    var panelheight = $('#' + target).find('.panel-body').height();
    sprkoptions.height = panelheight + 'px';
    $.each(data.table, function(key,val) {
        if(apistring.rating == '2') {
            var obj = data.table[key][datacolumn][1];
            if(obj.orig) {
                sparkdata.push(parseFloat(obj.orig));
            } else {
                data.table[key][datacolumn][0];
            }
        }
        else {
            sparkdata.push(parseFloat(data.table[key][datacolumn]));
        }
    });
    if(sparkdata.length < 2) { // ensure that there are always at least 2 data points
        sparkdata.push(sparkdata[0]);
    }
    dashexpert_api.util.debugOut('Build sparkine: ' + widget.title);
    dashexpert_api.util.debugOut(sparkdata);
    dashexpert_api.util.debugOut(sprkoptions);
    $('#' + target + ' .panel-heading').attr('title', widget.description);
    $('#' + target + ' .panel-heading .panel-title span:first').html(widget.title);
    $('#' + target + ' .panel-body').sparkline(sparkdata, sprkoptions);
    if(dashexpert_api.fn.widgets.table.create) {
        $('#' + target + ' .panel-body').off().on('click', function(e) {
            e.preventDefault();
            var wid = $('#' + target).parent().data('wid');
            var exists = dashexpert_api.fn.dataExists(vid,{autoload:true,wid:wid});
            if(exists) {
                $('#ext-dashboard-modal .modal-title').html('Showing Data for ' + widget.title);
                $('#ext-dashboard-modal .panel-body').empty();
                dashexpert_api.fn.widgets.table.create(widget,vid,{preview:true});
                $('#ext-dashboard-modal').modal('show');
            }
        });
    }
};
var remove = function() {

};
var update = function() {
    
};

// ON DOCUMENT READY
$(document).ready(function() {
    dashexpert_api.util.debugOut(widgettype + ' plugin loaded.');
    var waitForFinalEvent = (function () {
      var timers = {};
      return function (callback, ms, uniqueId) {
        if (!uniqueId) {
          uniqueId = "Don't call this twice without a uniqueId";
        }
        if (timers[uniqueId]) {
          clearTimeout (timers[uniqueId]);
        }
        timers[uniqueId] = setTimeout(callback, ms);
      };
    })();
    $(window).resize(function() {
        waitForFinalEvent(function() {
            redrawSparksBars(); 
        }, 500, 'window resize');
    });
    $(document.body).on('sparklineRegionChange', '.widget-spark .panel-body, .widget-bar .panel-body', function(ev) {
        $('.widget-info .panel-body').html('');
        var sparkline = ev.sparklines[0],
            region = sparkline.getCurrentRegionFields(),
            value = region.y;
        var parent = $(sparkline.el).parent();
        var wid = parent.parent().data('wid');
        var vid = parent.parent().data('vid') || 'widget_select_preview';
        var widgets = amplify.store('widgets');
        if(wid === undefined) {
            wid = parent.data('widgetid');
        }
        if(parent.attr('id') === 'widget_preview') {
            wid = dashexpert_api.currentWidget;
            vid = 'widget_extended';
        }
        if(dashexpert_api.fn.widgets.datablocks.create) {
            var exists = dashexpert_api.fn.dataExists(vid,{autoload:true,wid:wid});
            if(exists) {
                dashexpert_api.fn.widgets.datablocks.create(widgets[wid],vid,sparkline.currentRegion);
            }
        }
    });
});
// EXPOSE PUBLIC FUNCTIONS
dashexpert_api.fn.widgets[widgettype] = {
    create : create,
    remove : remove,
    update : update,
    redrawSparksBars : redrawSparksBars
}

// END Library code
}));