(function (library) {
    // Calls the second IIFE and locally passes in the global jQuery, window, and document objects
    library(window, document, window.jQuery);
}
// Locally scoped parameters 
(function (window, document, $) {
//VARIABLES
dashexpert_api.widgets = dashexpert_api.widgets || {};
dashexpert_api.widgets.types = dashexpert_api.widgets.types || [];
dashexpert_api.widgets.xref = dashexpert_api.widgets.xref || {};
dashexpert_api.widget_preferences = dashexpert_api.widget_preferences || {};

var widgettype = 'scorecard';
dashexpert_api.widgets.types.push(widgettype);
dashexpert_api.widget_preferences[widgettype] = {
    data_mapping: 'single', // single or multi
    searchable: true,
    iconclass: 'fa-plus-square',
    cache: true,
    blacklist: [],
    SearchIndicator: true,
    restrictSearch: []
};
dashexpert_api.widgets.xref[widgettype] = 'Scorecard';
dashexpert_api.widgets[widgettype] = {  // [Label,type,{default|hint|options|errorcheck}]
    apistring : ['apistring','textarea',{
      default : '',
      hint : 'This is the current APIString defined by the datasource.  Changes made here will override the datasource.  We recommend that you always use the following option of "rating": "2" in order to display color and formatting correctly.  This string is used to get the data that will be used for creating the widget.',
      errorcheck : [['json','API String must be valid JSON.']]
    }],
    good_label : ['Good Range Label','text',{default : 'GOOD'}],
    good_sub_label : ['Good Range Secondary Label','text',{default : ''}],
    fair_label : ['Fair Range Label','text',{default : 'FAIR'}],
    fair_sub_label : ['Fair Range Secondary Label','text',{default : ''}],
    poor_label : ['Poor Range Label','text',{default : 'POOR'}],
    poor_sub_label : ['Poor Range Secondary Label','text',{default : ''}],
    datacolumn_label : ['Data Column Label','text',{default : ''}],
    good_bgcolor : ['Good Background Color','color',{default : '#5cb85c'}],
    good_txtcolor : ['Good Text Color','color',{default : '#ffffff'}],
    fair_bgcolor : ['Fair Background Color','color',{default : '#f0ad4e'}],
    fair_txtcolor : ['Fair Text Color','color',{default : '#ffffff'}],
    poor_bgcolor : ['Poor Background Color','color',{default : '#d9534f'}],
    poor_txtcolor : ['Poor Text Color','color',{default : '#ffffff'}],
    reverse : ['Reverse','checkbox',{default : false,hint : 'If <em>checked</em> Low limit = POOR and High Limit = GOOD.  If <em>not checked</em>, then Low limit = GOOD and High Limit = POOR.'}]
};
//FUNCTIONS
var getDefaults = function(){
    var options = {};
    $.each(dashexpert_api.widgets[widgettype], function(key,val) {
        options[key] = val[2].default;
    });
    return options;
};
var evalScore = function(number,limits,current,reverse) {
    var score = current;
    score.data.push(number);
    if(score.high < number) {
        score.high = number;
    }
    if(reverse) {  // low = poor, high = good
        if(number <= limits.l) {
            score.poor = score.poor + 1;
        } else {
            if(number < limits.h) {
                score.fair = score.fair + 1;
            } else {
                score.good = score.good + 1;
            }
        }  
    } else { // low = good, high = poor
        if(number <= limits.m) {
            score.good = score.good + 1;
        } else {
            if(number < limits.h) {
                score.fair = score.fair + 1;
            } else {
                score.poor = score.poor + 1;
            }
        }
        if(number > limits.h) {
            number = parseFloat(limits.h);
        }
    }
    score.sum = score.sum + number;
    return score;
};
var create = function(widget,vid) { // pass widget object and vid (target)
    var apistring = atob(amplify.store('map_' + vid)); //get APIString
    var data = amplify.store(btoa(apistring)); //get Data from encoded APIString
    apistring = JSON.parse(apistring); // parse to object
    var target = 'widget_' + vid;
    $('#' + target).addClass('widget-scorecard');

    var scoredata = [];
    var score = {
        good : 0,
        fair : 0,
        poor : 0,
        sum : 0,
        high : 0,
        data : []
    };
    var scoreoptions = getDefaults();
    $.each(widget.options, function(key,val) {
        scoreoptions[key] = val;
    });
    var reverse = false;
    if(JSON.parse(scoreoptions.reverse)) {
        reverse = true;
    }
    var ds = widget.datasource;
    var columns = '';
    if('dcolumn' in widget) {
        columns = widget.dcolumn;
    } else {
        if('dcolumn' in widget.options) {
            columns = widget.options.dcolumn;
        }
    }
    if(columns === '' && 'sort_col' in apistring) {
        columns = apistring.sort_col;
    }
    var limits = {};
    if('h_limit' in widget) {
        limits.h = widget.h_limit;
        limits.m = widget.m_limit;
        if(widget.l_limit) {
            limits.l = widget.l_limit;
        } else {
            limits.l = 0;
        }
    } else {
        limits.h = widget.options.h_limit;
        limits.m = widget.options.m_limit;
        if(widget.options.l_limit) {
            limits.l = widget.options.l_limit;
        } else {
            limits.l = 0;
        }
    }
    
    var datacolumn = columns;
    if(columns.indexOf(',') > -1 || columns === '') {
        datacolumn = data.basis_columns;
    }
    $.each(data.table, function(key,val) {
        if(apistring.rating == '2') {
            var obj = data.table[key][datacolumn][1];
            if(obj.orig) {
                scoredata.push(parseFloat(obj.orig));
                score = evalScore(parseFloat(obj.orig),limits,score,reverse);
            } else {
                score = evalScore(data.table[key][datacolumn][0],limits,score,reverse);
            }
        }
        else {
            scoredata.push(parseFloat(data.table[key][datacolumn]));
            score = evalScore(parseFloat(data.table[key][datacolumn]),limits,score);
        }
    });
    var length = score.data.length;
    score.avg = score.sum / score.data.length;
    if(reverse) {  // low = poor, high = good
        score.legend_poor = 'Scores 0 - ' + limits.l;
        score.legend_fair = 'Scores ' + limits.l + ' - ' + limits.m;
        score.legend_good = 'Scores greater than or equal to ' + limits.h;
        if(score.avg <= limits.l) {
            score.level = 'background-color: ' + scoreoptions.poor_bgcolor + ';color: ' + scoreoptions.poor_txtcolor;
        } else {
            if(score.avg < limits.h) {
                score.level = 'background-color: ' + scoreoptions.fair_bgcolor + ';color: ' + scoreoptions.fair_txtcolor;
            } else {
                score.level = 'background-color: ' + scoreoptions.good_bgcolor + ';color: ' + scoreoptions.good_txtcolor;
            }
        }  
    } else { // low = good, high = poor
        score.legend_good = 'Scores ' + limits.l + ' - ' + limits.m;
        score.legend_fair = 'Scores ' + limits.m + ' - ' + limits.h;
        score.legend_poor = 'Scores greater than or equal to ' + limits.h;
        if(score.avg <= limits.m) {
            score.level = 'background-color: ' + scoreoptions.good_bgcolor + ';color: ' + scoreoptions.good_txtcolor;
        } else {
            if(score.avg < limits.h) {
                score.level = 'background-color: ' + scoreoptions.fair_bgcolor + ';color: ' + scoreoptions.fair_txtcolor;
            } else {
                score.level = 'background-color: ' + scoreoptions.poor_bgcolor + ';color: ' + scoreoptions.poor_txtcolor;
            }
        } 
    }
    var datalabel = data.xref[datacolumn];
    if(scoreoptions.datacolumn_label !== '') {
        datalabel = scoreoptions.datacolumn_label;
    }
    var html = '<div class="scorecard">\n';
    html += '\t<div class="score score-h" data-toggle="tooltip" title="' + score.legend_good + '" style="background-color: ' + scoreoptions.good_bgcolor + ';color: ' + scoreoptions.good_txtcolor + '">\n';
    html += '\t\t<span class="score-value">' + score.good + '</span>\n\t\t<span class="score-label">' + scoreoptions.good_label + '</span>';
    html += '\t</div>';
    html += '\t<div class="score score-m" data-toggle="tooltip" title="' + score.legend_fair + '" style="background-color: ' + scoreoptions.fair_bgcolor + ';color: ' + scoreoptions.fair_txtcolor + '">\n';
    html += '\t\t<span class="score-value">' + score.fair + '</span>\n\t\t<span class="score-label">' + scoreoptions.fair_label + '</span>';
    html += '\t</div>';
    html += '\t<div class="score score-l" data-toggle="tooltip" title="' + score.legend_poor + '" style="background-color: ' + scoreoptions.poor_bgcolor + ';color: ' + scoreoptions.poor_txtcolor + '">\n';
    html += '\t\t<span class="score-value">' + score.poor + '</span>\n\t\t<span class="score-label">' + scoreoptions.poor_label + '</span>';
    html += '\t</div>';
    html += '<span class="scorecard-label" data-toggle="tooltip" title="Average Score: ' + score.avg.toFixed(2) + '" style="' + score.level + '">' + datalabel + '</span>';
    $('#' + target + ' .panel-heading').attr('title', widget.description);
    $('#' + target + ' .panel-heading .panel-title span:first').html(widget.title);
    $('#' + target + ' .panel-body').html(html);
    $('.scorecard [data-toggle="tooltip"]').tooltip({container: 'body',placement: 'bottom'});
    dashexpert_api.util.debugOut('______SCORE______');
    dashexpert_api.util.debugOut(score);
    if(dashexpert_api.fn.widgets.table.create) {
        $('#' + target + ' .panel-body .scorecard').on('click', function(e) {
            e.preventDefault();
            var wid = $('#' + target).parent().data('wid');
            var exists = dashexpert_api.fn.dataExists(vid,{autoload:true,wid:wid});
            if(exists) {
                $('#ext-dashboard-modal .modal-title').html('Showing Data for ' + widget.title);
                $('#ext-dashboard-modal .panel-body').empty();
                dashexpert_api.fn.widgets.table.create(widget,vid,{preview:true});
                $('#ext-dashboard-modal').modal('show');
            }
        });
    }
    dashexpert_api.util.debugOut('Build scorecard: ' + widget.title);
};
var remove = function() {

};
var update = function() {
    
};

// ON DOCUMENT READY
$(document).ready(function() {
   dashexpert_api.util.debugOut(widgettype + ' plugin loaded.');
});
// EXPOSE PUBLIC FUNCTIONS
dashexpert_api.fn.widgets[widgettype] = {
    create : create,
    delete : remove,
    update : update
}
// END Library code
}));