(function (library) {
    // Calls the second IIFE and locally passes in the global jQuery, window, and document objects
    library(window, document, window.jQuery);
}
// Locally scoped parameters 
(function (window, document, $) {
//VARIABLES
dashexpert_api.widgets = dashexpert_api.widgets || {};
dashexpert_api.widgets.types = dashexpert_api.widgets.types || [];
var widgettype = 'piechart';
dashexpert_api.widgets.types.push(widgettype);
dashexpert_api.widgets[widgettype] = {  // [Label,type,{default|hint|options|errorcheck}]
    apistring : ['apistring','textarea',{
      default : '',
      hint : 'This is the current APIString defined by the datasource.  Changes made here will override the datasource.  We recommend that you always use the following option of "rating": "2" in order to display color and formatting correctly.  This string is used to get the data that will be used for creating the widget.',
      errorcheck : [['json','API String must be valid JSON.']]
    }],
    type : ['Type','hidden',{default : 'pie'}],
    info : ['Display Extended Info','checkbox',{default : false,hint : 'Display Extended info as a popup'}],
    sliceColors : ['Slice Colors','text',{default : '#3366cc,#f04040,#33cc66',hint : 'Comma separated list of colors to use.'}],
    borderColor : ['Negative Bar Color','color',{default : '#f04040',hint : 'Color of negative data Bars in HTML color format.'}]
};
//WIDGET SPECIFIC FUNCTIONS
var getDefaults = function(){
    var options = {};
    $.each(dashexpert_api.widgets[widgettype], function(key,val) {
        options[key] = val[2].default;
    });
    return options;
};
var redrawSparksBars = function() {
    var sparks = $('#' + dashexpert_api.settings.currentdash + ' .widget-spark');
    var bars = $('#' + dashexpert_api.settings.currentdash + ' .widget-bar');
    var widgets = amplify.store('widgets');
    $.each(sparks, function() {
        var wid = $(this).parent().data('wid');
        var vid = $(this).parent().data('vid');
        $('#widget_' + vid + ' .panel-body').empty();
        var exists = dashexpert_api.fn.dataExists(vid,{autoload:true,wid:wid});
        if(exists) {
            dashexpert_api.fn.widgets.sparkline.create(widgets[wid],vid);
        }
    });
    $.each(bars, function() {
        var wid = $(this).parent().data('wid');
        var vid = $(this).parent().data('vid');
        $('#widget_' + vid + ' .panel-body').empty();
        var exists = dashexpert_api.fn.dataExists(vid,{autoload:true,wid:wid});
        if(exists) {
            dashexpert_api.fn.widgets.barchart.create(widgets[wid],vid);
        }
    });
}
// API Functions
var create = function(widget,vid) { // pass widget object and vid (target)
    var apistring = atob(amplify.store('map_' + vid)); //get APIString
    var data = amplify.store(btoa(apistring)); //get Data from encoded APIString
    apistring = JSON.parse(apistring); // parse to object
    var target = 'widget_' + vid;
    $('#' + target).addClass('widget-bar');

    var bardata = [];
    var columns = '';
    if(widget.dcolumn && data.table[0][widget.dcolumn]) {
        datacolumn = widget.dcolumn;
    }
    else {
       if(columns === '' && 'sort_col' in apistring) {
            columns = apistring.sort_col;
        } else {
            columns = data.columns.split(',');
        }
        var datacolumn = columns;
        if(data.columns.indexOf(',') > -1) {
            datacolumn = columns[0];
        } 
    }
    
    var baroptions = getDefaults();

    $.each(widget.options, function(key,val) {
        baroptions[key] = val;
    });
    var panelheight = $('#' + target).find('.panel-body').height();
    var panelwidth = $('#' + target).find('.panel-body').width();
    baroptions.tooltipSuffix = ' ' + data.xref[datacolumn];
    baroptions.height = panelheight + 'px';
    $.each(data.table, function(key,val) {
        if(apistring.rating == '2') {
            var obj = data.table[key][datacolumn][1];
            if(obj.orig) {
                bardata.push(parseFloat(obj.orig));
            } else {
                data.table[key][datacolumn][0];
            }
        }
        else {
            bardata.push(parseFloat(data.table[key][datacolumn]));
        }
    });
    if(bardata.length < 2) { // ensure that there are always at least 2 data points
        bardata.push(bardata[0]);
    }
    baroptions.barWidth = Math.floor((panelwidth - bardata.length) / bardata.length);
    dashexpert_api.util.debugOut('Build bar chart for ' + target);
    dashexpert_api.util.debugOut(bardata);
    dashexpert_api.util.debugOut(baroptions);
    $('#' + target + ' .panel-heading').attr('title', vid);
    $('#' + target + ' .panel-heading .panel-title span').html(widget.title);
    $('#' + target + ' .panel-body').sparkline(bardata, baroptions);
    if(dashexpert_api.fn.widgets.table.create) {
        $('#' + target + ' .panel-body').on('click', function(e) {
            e.preventDefault();
            var wid = $('#' + target).parent().data('wid');
            var exists = dashexpert_api.fn.dataExists(vid,{autoload:true,wid:wid});
            if(exists) {
                $('#ext-dashboard-modal .modal-title').html('Showing Data for ' + widget.title);
                $('#ext-dashboard-modal .panel-body').empty();
                dashexpert_api.fn.widgets.table.create(widget,vid,{preview:true});
                $('#ext-dashboard-modal').modal('show');
            }
        });
    }
};

// ON DOCUMENT READY
$(document).ready(function() {
    dashexpert_api.util.debugOut(widgettype + ' plugin loaded.');
});
// EXPOSE PUBLIC FUNCTIONS
dashexpert_api.fn.widgets[widgettype] = {
    create : create,
    redrawSparksBars : redrawSparksBars
}

// END Library code
}));