(function (library) {
    // Calls the second IIFE and locally passes in the global jQuery, window, and document objects
    library(window, document, window.jQuery);
}
// Locally scoped parameters 
(function (window, document, $) {
//VARIABLES
dashexpert_api.widgets = dashexpert_api.widgets || {};
dashexpert_api.widgets.types = dashexpert_api.widgets.types || [];
dashexpert_api.widgets.xref = dashexpert_api.widgets.xref || {};
dashexpert_api.widget_preferences = dashexpert_api.widget_preferences || {};

var widgettype = 'multitable';
dashexpert_api.widgets.types.push(widgettype);
dashexpert_api.widgets[widgettype] = {  // [Label,type,{default|hint|options|errorcheck}]
    tables : ['Tables','multiselect',{default : '',hint : 'Select Tables to display',}],
};
dashexpert_api.widget_preferences[widgettype] = {
    data_mapping: 'multi', // single or multi
    searchable: true,
    iconclass: 'fa-copy',
    cache: true
};
dashexpert_api.widgets.xref[widgettype] = 'Multi-Table';
//FUNCTIONS
var getDefaults = function(){
    var options = {};
    $.each(dashexpert_api.widgets[widgettype], function(key,val) {
        options[key] = val[2].default;
    });
    return options;
};
var buildTableSelect = function(target,optArray,vid) {
    var sources = amplify.store('widgets');
    var html = '<select>';
    $.each(optArray, function(i,val) {
      //console.log('------>' + sources[val].title);
      if(sources.hasOwnProperty(val)) {
        html += '\t<option value="' + val + '">' + sources[val].title + '</option>';
      }
    });
    html += '</select>';
    $(target).html(html);
    $(target + ' select').html($(target + ' option').sort(function(a,b) {
        return a.text == b.text ? 0 : a.text < b.text ? -1 : 1;
    }));
    var mtselected = dashexpert_api.settings.multitables || {};
    mtselected[dashexpert_api.settings.currentdash] = mtselected[dashexpert_api.settings.currentdash] || {};
    dashexpert_api.settings.multitables = mtselected;
    $(target + ' select').on('change', function(e) {
        var table = $(this).val();
        //amplify.store('map_' + vid, null);
        var map = amplify.store('map_' + vid);
        dashexpert_api.settings.multitables[dashexpert_api.settings.currentdash][vid] = table;
        if(map) {
            delete map[table];
            amplify.store('map_' + vid, map);
        }
        var exists = dashexpert_api.fn.dataExists(vid,{autoload:false,wid:table});
        if(!exists) {
            dashexpert_api.fn.retrieveData(table,vid,function(){
                dashexpert_api.fn.widgets.table.create(sources[table],vid,{type: 'multitable',wid:table});
            });
        } else {
            dashexpert_api.fn.widgets.table.create(sources[table],vid,{type: 'multitable',wid:table});
        }
    });
    var mtselect = dashexpert_api.settings.multitables;
    if(mtselect[dashexpert_api.settings.currentdash][vid]) {
        $(target + ' select option[value="' + mtselect[dashexpert_api.settings.currentdash][vid] + '"]').prop('selected', true);
    } else {
        $(target + ' select option:first').prop('selected', true);
    }
    var render = $(target + ' select').val();
    //amplify.store('map_' + vid, null);
    dashexpert_api.fn.retrieveData(render,vid,function(){
        dashexpert_api.fn.widgets.table.create(sources[render],vid,{type: 'multitable',wid:render});
    });
};

var create = function(widget,vid,options) { // pass widget object and vid (target) options { preview: true|false }
    var toptions = options || {};
    var target = 'widget_' + vid;
    if(toptions.preview) {
        target = options.target || 'view-dashboard-modal-widget';
    }
    $('#' + target).addClass('widget-table');
    buildTableSelect('#' + target + ' .panel-heading .panel-title span:first',widget.options.tables,vid);
    $('#' + target + ' .panel-heading .panel-title span:first').append(widget.title);
};
var remove = function() {

};
var update = function() {
    
};

// ON DOCUMENT READY
$(document).ready(function() {
   dashexpert_api.util.debugOut(widgettype + ' plugin loaded.');
});
// EXPOSE PUBLIC FUNCTIONS
dashexpert_api.fn.widgets[widgettype] = {
    create : create,
    delete : remove,
    update : update
}
// END Library code
}));