(function (library) {
    // Calls the second IIFE and locally passes in the global jQuery, window, and document objects
    library(window, document, window.jQuery);
}
// Locally scoped parameters 
(function (window, document, $) {

var getDefaults = function(widgettype,woptions){
    var options = {};
    $.each(dashexpert_api.widgets[widgettype], function(key,val) {
        options[key] = val[2].default;
    });
    if(woptions) {
    	$.each(woptions, function(key,val) {
	        options[key] = val;
	    });
    }
    return options;
};

var getDataColumn = function(widget,data) {
	var output = {};
	output.columns = '';
	output.datacolumn = [];
	if('dcolumn' in widget.options) {
	    widget.dcolumn = widget.options.dcolumn;
	}
	if(widget.dcolumn) {
	    if(widget.dcolumn && data.table[0][widget.dcolumn]) {
	        output.datacolumn = widget.dcolumn;
	    }
	    if('basis_columns' in data) {
	        output.columns = data.basis_columns.split(',');
	    }
	} else {
	    if('basis_columns' in data) {
	        output.columns = data.basis_columns.split(',');
	        output.datacolumn = output.columns[0];
	    }
	    if(widget.dcolumn && data.table[0][widget.dcolumn]) {
	        output.datacolumn = widget.dcolumn;
	    }
	}
	return output; // datacolumn:string | columns:array
};
var convertData = function(data,expand) {
	var e = expand;
	if(typeof expand === undefined) {
		e = true;
	} else {
		e = expand;
	}
    var acdata = [];
    $.each(data.table, function(i,v) {
    	var basis = data.basis_columns.split(',');
        acdata[i] = {};
        acdata[i].amID = i;
        acdata[i].basis_columns = basis;
        acdata[i].category = data.table[i][basis[0]][1].orig;
        $.each(v, function(k,d) {
        	// if(!isNaN(parseFloat(d[1].orig))) {
        	// 	d[1].orig = parseFloat(d[1].orig);
        	// }
            acdata[i][k] = d[1].orig;
        });
    });
    if(acdata.length < 2 && e) {
        acdata.push(acdata[0]);
    }
    return acdata;
};
function redrawChart(charttype) {
	var wid = $(this).parent().data('wid');
    var vid = $(this).parent().data('vid');
    $('#widget_' + vid + ' .panel-body').empty();
    var exists = dashexpert_api.fn.dataExists(vid,{autoload:true,wid:wid});
    if(exists) {
        dashexpert_api.fn.widgets[charttype].create(widgets[wid],vid);
    }
};
function createChart(chartdiv, charttype) {
  // Check if the chart instance exists
   maybeDisposeChart(chartdiv);

  // Create new chart
   dashexpert_api.settings.amchartsReg[chartdiv] = am4core.create(chartdiv, charttype);
   return dashexpert_api.settings.amchartsReg[chartdiv];
}

function maybeDisposeChart(chartdiv) {
  if (dashexpert_api.settings.amchartsReg[chartdiv]) {
    dashexpert_api.settings.amchartsReg[chartdiv].dispose();
    delete dashexpert_api.settings.amchartsReg[chartdiv];
  }
}
function disposeAllCharts() {
	am4core.disposeAllCharts();
} 
var createACTooltip = function(xref,columndata) {
    var output = '';
    if(columndata.datacolumn !== 'end_date') {
    	output = xref[columndata.datacolumn] + ': [bold]{' + columndata.datacolumn + '}[/]';
    } else {
    	output = '{end_date}: [bold]{' + columndata.datacolumn + '}[/]';
    }
    $.each(columndata.columns, function(i,v){
        if(v !== 'end_date') {
            output += `
            ` + xref[columndata.columns[i]] + ': [bold]{' + columndata.columns[i] + '}[/]';
        }
    });
    return output;
};

// EXPOSE PUBLIC FUNCTIONS
dashexpert_api.fn.widget_libraries = {
    getDefaults : getDefaults,
    getDataColumn : getDataColumn,
    convertData : convertData,
    createChart : createChart,
    redrawChart : redrawChart,
    maybeDisposeChart : maybeDisposeChart,
    disposeAllCharts : disposeAllCharts,
    createACTooltip : createACTooltip
};

// END Library code
}));