(function (library) {
    // Calls the second IIFE and locally passes in the global jQuery, window, and document objects
    library(window, document, window.jQuery);
}
// Locally scoped parameters 
(function (window, document, $) {
//VARIABLES
dashexpert_api.widgets = dashexpert_api.widgets || {};
dashexpert_api.widgets.types = dashexpert_api.widgets.types || [];
dashexpert_api.widgets.xref = dashexpert_api.widgets.xref || {};
dashexpert_api.widget_preferences = dashexpert_api.widget_preferences || {};

var widgettype = 'info';
dashexpert_api.widgets.types.push(widgettype);
dashexpert_api.widgets[widgettype] = {  // [Label,type,{default|hint|options|errorcheck}]
    showtitle : ['Show Title','checkbox',{default : false}]
};
dashexpert_api.widget_preferences[widgettype] = {
    data_mapping: 'none', // single or multi or none
    searchable: false,
    iconclass: 'fa-info-circle',
    cache: false,
    blacklist: [],
    SearchIndicator: false,
    restrictSearch: []
};
dashexpert_api.widgets.xref[widgettype] = 'Info';
//FUNCTIONS
var getDefaults = function(){
    var options = {};
    $.each(dashexpert_api.widgets[widgettype], function(key,val) {
        options[key] = val[2].default;
    });
    return options;
};
var create = function(widget,vid) { // pass widget object and vid (target) options { preview: true|false }
    var target = 'widget_' + vid;
    $('#' + target).addClass('widget-info');
    $('#' + target + ' .panel-heading').attr('title', vid);
    $('#' + target + ' .panel-title span:first').html(widget.title);
    $('#' + target + ' .panel-body').html('<h4>mouseover a chart to display extended information here.</h4>');
    if(widget.options.showtitle == 'false') {
      $('#' + target + ' .panel-heading').hide();
    }
};
var remove = function() {

};
var update = function() {
    
};

// ON DOCUMENT READY
$(document).ready(function() {
   dashexpert_api.util.debugOut(widgettype + ' plugin loaded.');
   // if(!dashexpert_api.settings.use_amcharts) {
   //     $(document.body).on('mouseover', function() {
   //      $('.widget-info .panel-body').html('<h4>mouseover a chart to display extended information here</h4>');
   //     });
   // }
});
// EXPOSE PUBLIC FUNCTIONS
dashexpert_api.fn.widgets[widgettype] = {
    create : create,
    delete : remove,
    update : update
}
// END Library code
}));
