(function (library) {
    // Calls the second IIFE and locally passes in the global jQuery, window, and document objects
    library(window, document, window.jQuery);
}
// Locally scoped parameters 
(function (window, document, $) {
//VARIABLES
dashexpert_api.widgets = dashexpert_api.widgets || {};
dashexpert_api.widgets.types = dashexpert_api.widgets.types || [];
dashexpert_api.widgets.xref = dashexpert_api.widgets.xref || {};
dashexpert_api.widget_preferences = dashexpert_api.widget_preferences || {};
var widgettype = 'html';
dashexpert_api.widgets.types.push(widgettype);
dashexpert_api.widget_preferences[widgettype] = {
    data_mapping: 'single', // single or multi
    searchable: false,
    iconclass: 'fa-code',
    cache: true,
    blacklist: [],
    SearchIndicator: false,
    restrictSearch: []
};
dashexpert_api.widgets.xref[widgettype] = 'HTML';
dashexpert_api.widgets[widgettype] = {  // [Label,type,{default|hint|options|errorcheck}]
    type : ['Type','hidden',{default : 'html'}],
    options : ['options','hidden',{default : 'simple'}],
    html : ['HTML','html',{default : '', hint : 'HTML to include in body of widget'}]
};
//WIDGET SPECIFIC FUNCTIONS
var getDefaults = function(){
    var options = {};
    $.each(dashexpert_api.widgets[widgettype], function(key,val) {
        options[key] = val[2].default;
    });
    return options;
};
// API Functions
var create = function(widget,vid) { // pass widget object and vid (target)
    var target = 'widget_' + vid;
    $('#' + target).addClass('widget-html');
    $('#' + target + ' .panel-heading').attr('title', vid);
    $('#' + target + ' .panel-title span:first').html(widget.title);
    var html = widget.options.html;
    $('#' + target + ' .panel-body').html(html);
    if(widget.showtitle == 'false') {
      $('#' + target + ' .panel-heading').hide();
    }
};

// ON DOCUMENT READY
$(document).ready(function() {
    dashexpert_api.util.debugOut(widgettype + ' plugin loaded.');
});
// EXPOSE PUBLIC FUNCTIONS
dashexpert_api.fn.widgets[widgettype] = {
    create : create
}

// END Library code
}));
