(function (library) {
    // Calls the second IIFE and locally passes in the global jQuery, window, and document objects
    library(window, document, window.jQuery);
}
// Locally scoped parameters 
(function (window, document, $) {
//VARIABLES
dashexpert_api.widgets = dashexpert_api.widgets || {};
dashexpert_api.widgets.types = dashexpert_api.widgets.types || [];
dashexpert_api.widgets.xref = dashexpert_api.widgets.xref || {};
dashexpert_api.widget_preferences = dashexpert_api.widget_preferences || {};

var widgettype = 'datablocks';
dashexpert_api.widgets.types.push(widgettype);
dashexpert_api.widgets[widgettype] = {  // [Label,type,{default|hint|options|errorcheck}]
    apistring : ['apistring','textarea',{
      default : '',
      hint : 'This is the current APIString defined by the datasource.  Changes made here will override the datasource.  We recommend that you always use the following option of "rating": "2" in order to display color and formatting correctly.  This string is used to get the data that will be used for creating the widget.',
      errorcheck : [['json','API String must be valid JSON.']]
    }],
    blockcolor : ['Block Color','color',{default : '#e0ffff',hint : 'Background color of normal datablocks in HTML color format.'}],
    topcolor : ['Top Color','color',{default : '#85b0dd',hint : 'Top border color of normal datablocks in HTML color format.'}],
    api_titlefield : ['API Title Column','text',{default : '',hint : 'Column to be used for creating the widget title.',errorcheck : [['required','API Title Column required.']]}]    
};
dashexpert_api.widget_preferences[widgettype] = {
    data_mapping: 'single', // single or multi or none
    searchable: true,
    iconclass: 'fa-cubes',
    cache: true,
    blacklist: [],
    SearchIndicator: true,
    restrictSearch: []
};
dashexpert_api.widgets.xref[widgettype] = 'Datablocks';
//FUNCTIONS
var getDefaults = function(){
    var options = {};
    $.each(dashexpert_api.widgets[widgettype], function(key,val) {
        options[key] = val[2].default;
    });
    return options;
};
var shadeColor = function(color, percent) {   
    var f=parseInt(color.slice(1),16),t=percent<0?0:255,p=percent<0?percent*-1:percent,R=f>>16,G=f>>8&0x00FF,B=f&0x0000FF;
    return '#'+(0x1000000+(Math.round((t-R)*p)+R)*0x10000+(Math.round((t-G)*p)+G)*0x100+(Math.round((t-B)*p)+B)).toString(16).slice(1);
};
var blendColors = function(c0, c1, p) {
    var f=parseInt(c0.slice(1),16),t=parseInt(c1.slice(1),16),R1=f>>16,G1=f>>8&0x00FF,B1=f&0x0000FF,R2=t>>16,G2=t>>8&0x00FF,B2=t&0x0000FF;
    return '#'+(0x1000000+(Math.round((R2-R1)*p)+R1)*0x10000+(Math.round((G2-G1)*p)+G1)*0x100+(Math.round((B2-B1)*p)+B1)).toString(16).slice(1);
};

var create = function(widget,vid,region) {
    var apistring = atob(amplify.store('map_' + vid)); //get APIString
    var data = amplify.store(btoa(apistring)); //get Data from encoded APIString
    apistring = JSON.parse(apistring); // parse to object
    var target = 'widget_' + vid;
    if(widget.type === 'datablocks') {
        $('#widget_' + vid + ' .panel-body').empty();
        $('#widget_' + vid).addClass('widget-datablocks');
    }
    var tdata = data.table;
    var xref = data.xref;
    //var basis = apistring.basis.split(",");
    var options = widget.options || getDefaults();
    var regionkey = 0;
    if(typeof region != 'undefined') {
        regionkey = region; 
    }
    var blocks = '';
    var value = '';
    blocks += '<div class="datablock">\n';
    var row = tdata[regionkey];
    $.each(row, function(key) {
        if(apistring.rating == '2' || apistring.rating == '3') {
            value = row[key][0];
            var formatting = row[key][1];
            var units = '';
            var tip = '';
            var style = ' style="';
            if(formatting.u) {
                units += formatting.u;
            }
            if(formatting.d) {
                units += formatting.d;
            }
            if(formatting.s) {
                style += 'border-color: ' + formatting.s + ';background-color: ' + shadeColor(formatting.s,0.3) + ';';
            }
            if(formatting.c) {
                style += 'border-color: ' + formatting.c + ';background-color: ' + shadeColor(formatting.c,0.3) + ';';
            }
            if(formatting.t) {
                style += 'color: ' + formatting.t + ';';
            }
            if(formatting.tip){
                tip += ' data-toggle="tooltip" title="' + formatting.tip + '"';
            }
            if(formatting.c === undefined && formatting.s === undefined) {
                if(options.blockcolor) {
                    style += 'background-color: ' + options.blockcolor + ';';
                } else {
                    style += 'background-color: ' + dashexpert_api.widgets[widgettype].blockcolor + ';';
                }
                if(options.topcolor) {
                    style += 'border-color: ' + options.topcolor + ';';
                } else {
                    style += 'border-color: ' + dashexpert_api.widgets[widgettype].topcolor + ';';
                }
            }
            style += '"';
            blocks += '\t<div class="db-block front"' + style + tip +'>\n';
            blocks += '\t\t<span class="db-value">' + value + ' ' + units + '</span>\n\t<span class="db-label">' + xref[key] + '</span>\n';
        } else {
            value = row[key];
            blocks += '\t<div class="db-block">\n';
            blocks += '\t\t<span class="db-value">' + value + '</span>\n\t<span class="db-label">' + xref[key] + '</span>\n';
        }
        blocks += '\t</div>\n';
    });
    blocks += '</div>\n';
    var loadingid = 'loading_' + $('#' + target).parent().data('wid');
    $('#' + loadingid).remove();
    if(typeof region === 'undefined' && widget.type === 'datablocks') {
        $('#' + target + ' .panel-body').append(blocks);
    } else {
        $('#outer-container .widget-info .panel-heading .panel-title').attr("title", vid);
        $('#outer-container .widget-info .panel-heading .panel-title span:first').html(widget.title); // NEED TO ADD COLUMN TITLE + ' for ' + data.xref[widget.dcolumn]
        $('#outer-container .widget-info .panel-body').html(blocks);
        //$('#' + target + ' .panel-body [data-toggle="tooltip"]').tooltip({container: 'body', html: true, placement: 'auto'});
    }
    //$('#' + target + ' .panel-body [data-toggle="tooltip"]').tooltip({container: 'body', html: true, placement: 'auto'});
};
var remove = function() {

};
var update = function() {
    
};

// ON DOCUMENT READY
$(document).ready(function() {
   dashexpert_api.util.debugOut(widgettype + ' plugin loaded.');
});
// EXPOSE PUBLIC FUNCTIONS
dashexpert_api.fn.widgets[widgettype] = {
    create : create,
    delete : remove,
    update : update
}
// END Library code
}));