(function (library) {
    // Calls the second IIFE and locally passes in the global jQuery, window, and document objects
    library(window, document, window.jQuery);
}
// Locally scoped parameters 
(function (window, document, $) {
//VARIABLES
dashexpert_api.widgets = dashexpert_api.widgets || {};
dashexpert_api.widgets.types = dashexpert_api.widgets.types || [];
dashexpert_api.widgets.xref = dashexpert_api.widgets.xref || {};
dashexpert_api.widget_preferences = dashexpert_api.widget_preferences || {};
dashexpert_api.settings.amchartsReg = dashexpert_api.settings.amchartsReg || {};

var widgettype = 'amchart_sankey';
dashexpert_api.widgets.types.push(widgettype);
dashexpert_api.widget_preferences[widgettype] = {
    data_mapping: 'single', // single or multi
    searchable: true,
    iconclass: 'fa-exchange',
    cache: true,
    blacklist: ['dcolumn','scolumn','displaycols','h_limit','m_limit','l_limit'],
    SearchIndicator: true,
    restrictSearch: ['resolution']
};
dashexpert_api.widgets.xref[widgettype] = 'Sankey Chart';
dashexpert_api.widgets[widgettype] = {  // [Label,type,{default|hint|options|errorcheck}]
    apistring : ['apistring','textarea',{
      default : '',
      hint : 'This is the current APIString defined by the datasource.  Changes made here will override the datasource.  We recommend that you always use the following option of "rating": "2" in order to display color and formatting correctly.  This string is used to get the data that will be used for creating the widget.',
      errorcheck : [['json','API String must be valid JSON.']]
    }],
    type : ['Type','hidden',{default : 'sankey'}],
    basis1 : ['Basis 1','select',{default : '',hint : 'Basis used as the starting metric.', errorcheck : [['required','At least 2 Basis are required.']]}],
    basis2 : ['Basis 2','select',{default : '',hint : '2nd Basis or destination metric.', errorcheck : [['required','At least 2 Basis are required.']]}],
    basis3 : ['Basis 3','select',{default : '',hint : '3rd basis or destination metric.'}],
    basis4 : ['Basis 4','select',{default : '',hint : 'Destination metric.'}],
    limit : ['Limit','select',{default : '25', options : [['10','10'],['15','15'],['20','20'],['25','25'],['50','50']],hint : 'This limits the results per basis. For best results use a limit of 25.'}],
    datasort : ['Sort Data By','select',{default : 'none', options : [['None','none'],['Name','name'],['Count','value']],hint : 'Sort the results.  By Default data is displayed as it is returned.'}],
    chartStyle : ['Chart Style','select',{default : 'solid', options : [['Gradient','gradient'],['Solid','solid']], hint : 'Fade color from one node to the other or solid color.'}],
    addExport : ['Add Export Menu','checkbox',{default : false, hint : 'Adds an export menu allowing you to export to various formats.'}],
    hideLabels : ['Hide Labels on small nodes','checkbox',{default : false, hint : 'This will hide labels with small instances of records.'}],
    showSortMetric : ['Show Sort Metric Data','checkbox',{default : true, hint : 'Shows the average using sort column data for each unique instance.'}]
};

//WIDGET SPECIFIC FUNCTIONS

var createACData = function(data,options) {
    var a,b,c,d;
    var xref = amplify.store('xref');
    var sortcol = options.sort_col;

    a = getBasisColumn(options.inspector,options.basis1);
    b = getBasisColumn(options.inspector,options.basis2);
    var counta = countUniquePairs(data,a,b,options.limit,sortcol);
    var countb = {}; var countc = {};
    if(options.basis3) {
        c = getBasisColumn(options.inspector,options.basis3);
        countb = countUniquePairs(data,b,c,options.limit,sortcol);
        countb.limituniqs = checkMissingPairs(counta.limituniqs,countb.limituniqs);
    }
    if(options.basis4) {
        d = getBasisColumn(options.inspector,options.basis4);
        countc = countUniquePairs(data,c,d,options.limit,sortcol);
        countc.limituniqs = checkMissingPairs(countb.limituniqs,countc.limituniqs);
    }
    var counts = { ...counta.limituniqs, ...countb.limituniqs, ...countc.limituniqs };
    var avg = { ...counta.sortcolAvgs, ...countb.sortcolAvgs, ...countc.sortcolAvgs,}
    var acdata = [];
    $.each(counts, function(k,v) {
        var obj = {};
        var keys = k.split('|');
        obj.from = keys[0];
        obj.fname = keys[1];
        obj.to = keys[2];
        obj.tname = keys[3];
        obj.value = v;
        obj.sname = xref[sortcol];
        obj.svalue = avg[k].toFixed(2);
        acdata.push(obj);
    });
    dashexpert_api.util.debugOut(acdata);
    return acdata;
};
var checkMissingPairs = function(a,b) {
    var to = [];
    var from = [];
    var output = {};
    $.each(a, function(k) {
        var name = k.split('|');
        name = name[2];
        to.push(name);
    });
    $.each(b, function(k) {
        var name = k.split('|');
        name = name[0];
        if(to.indexOf(name) != -1) {
            output[k] = b[k];
        }
    });
    return output;
};
var countUniquePairs = function(data,a,b,limit,sortcol) {
    var arr = [];
    var sArray = {};
    var d = data.table;
    $.each(d, function(i,v){
        var pair = d[i][a.column][0] + ' [' + a.name + ']|' + a.name + '|' + d[i][b.column][0] + ' [' + b.name + ']|' + b.name;
        arr.push(pair);
        if(sArray[pair] === undefined) {
           sArray[pair] = [];
            sArray[pair].push(d[i][sortcol][1].orig);
        } else {
            sArray[pair].push(d[i][sortcol][1].orig);
        }
    });
    $.each(sArray, function(k) {
        const sum = sArray[k].reduce((a, b) => parseFloat(a) + parseFloat(b), 0);
        const avg = (sum / sArray[k].length) || 0;
        sArray[k] = avg;
    });
    var output = { sortcolAvgs : sArray };
    var uniqs = arr.reduce((acc, val) => {
      acc[val] = acc[val] === undefined ? 1 : acc[val] += 1;
      return acc;
    }, {});
    output.uniqs = uniqs;
    if(limit) {
        var limituniqs = {};
        var count = 0;
        $.each(uniqs, function(k,v) {
            if(count < parseInt(limit)) {
                limituniqs[k] = uniqs[k];
            }
            count++;
        });
        output.limituniqs = limituniqs;
    }
    return output;
};
var getBasisColumn = function(inspector,basis) {
    var column,name;
    var bl = amplify.store('fullbasisList');
    //bl = removeBasisBlacklist(bl[inspector]);
    bl = bl[inspector][basis];
    $.each(bl, function(k){
        if(dashexpert_api.settings.skipcolumns.indexOf(k) === -1) {
            column = k;
            name = bl[k];
        }
    });
    return {column: column, name: name};
};
var removeBasisBlacklist = function(basislist) { // expects array[]
    var blacklist = dashexpert_api.settings.basis_blacklist.split(',');
    var output = [];
    $.each(basislist, function(i) {
      if($.inArray(basislist[i],blacklist) === -1) {
        output.push(basislist[i]);
      }
    });
    return output;
};

// API Functions
var create = function(widget,vid) { // pass widget object and vid (target)
    if(dashexpert_api.settings.theme === 'theme-dark') {
        am4core.useTheme(am4themes_amchartsdark);
    } else {
        am4core.useTheme(am4themes_animated);
    }
    var apistring = atob(amplify.store('map_' + vid)); //get APIString
    var api = JSON.parse(apistring);
    var inspector = 'inspector_' + api.inspector;
    var woptions = dashexpert_api.fn.widget_libraries.getDefaults(widgettype,widget.options);
    woptions.inspector = inspector;
    woptions.sort_col = api.sort_col;
    var data = amplify.store(btoa(apistring)); //get Data from encoded APIString
    var acdata = createACData(data,woptions);
    apistring = JSON.parse(apistring); // parse to object
    var target = 'widget_' + vid;
    $('#' + target).addClass('widget-amchart');
    $('#' + target + ' .panel-body').attr('id',target + '_body');
    var widgetHeight = $('#' + target).parent().parent().data('gsHeight');

    //create chart
    var chart = am4core.create(target + '_body', am4charts.SankeyDiagram);
    //assign data to chart
    chart.data = acdata;
    // Configure data fields
    chart.dataFields.fromName = "from";
    chart.dataFields.fName = "fname";
    chart.dataFields.toName = "to";
    chart.dataFields.tName = "tname";
    chart.dataFields.value = "value";
    chart.padding(10, 100, 10, 0);
    // Add title
    var basis1 = getBasisColumn(inspector,widget.options.basis1);
    var basis2 = getBasisColumn(inspector,widget.options.basis2);
    var basis3 = getBasisColumn(inspector,widget.options.basis3);
    var basis4 = getBasisColumn(inspector,widget.options.basis4);

    var title = '[bold]' + basis1.name + '[/] → [bold]' + basis2.name + '[/]';
    if(basis3.name) {
        title += ' → [bold]' + basis3.name + '[/]';
    }
    if(basis4.name) {
        title += ' → [bold]' + basis4.name + '[/]';
    }

    chart.titles.template.fontSize = 15;
    chart.titles.create().text = title;

    chart.sortBy = woptions.datasort;

    // Configure links
    if(woptions.chartStyle === 'gradient') {
        chart.links.template.colorMode = "gradient";
    }
    if(woptions.showSortMetric) {
        chart.links.template.tooltipText = "[bold]{fName}:[/] {fromName} → [bold]{tName}:[/] {toName}\n[bold]{value}[/] instances | [bold]{svalue}[/] {sname} (avg)";
    } else {
        chart.links.template.tooltipText = "[bold]{fName}:[/] {fromName} → [bold]{tName}:[/] {toName}\n[bold]{value}[/] instances";
    }
    var hoverState = chart.links.template.states.create("hover");
    hoverState.properties.fillOpacity = 1;

    // Exporting
    if(woptions.addExport) {
        chart.exporting.menu = new am4core.ExportMenu();
    }

    // Configure nodes
    chart.nodes.template.cursorOverStyle = am4core.MouseCursorStyle.pointer;
    chart.nodes.template.readerTitle = "Click to show/hide or drag to rearrange";
    chart.nodes.template.showSystemTooltip = true;
    chart.nodes.template.minWidth = 20;
    if(woptions.hideLabels) {
        chart.nodes.template.nameLabel.height = undefined;
        chart.nodes.template.nameLabel.label.hideOversized = true;
    }

    chart.nodes.template.cursorOverStyle = am4core.MouseCursorStyle.pointer;

    
    dashexpert_api.util.debugOut('Build amchart-sankey: ' + widget.title);
    dashexpert_api.util.debugOut(acdata);
    $('#' + target + ' .panel-heading').attr('title', widget.description);
    $('#' + target + ' .panel-heading .panel-title span:first').html(widget.title); 
    // $('#' + target + ' .panel-heading .pull-right').append('<a href=""><i class="fa fa-table view-data" aria-hidden="true" data-toggle="tooltip" data-placement="top" title="" data-original-title="View Data"></i></a>'); 
    // if(dashexpert_api.fn.widgets.table.create) {
    //     $('#' + target + ' .panel-heading .pull-right .view-data').off().on('click', function(e) {
    //         e.preventDefault();
    //         var wid = $('#' + target).parent().data('wid');
    //         var exists = dashexpert_api.fn.dataExists(vid,{autoload:true,wid:wid});
    //         if(exists) {
    //             $('#ext-dashboard-modal .modal-title').html('Showing Data for ' + widget.title);
    //             $('#ext-dashboard-modal .panel-body').empty();
    //             dashexpert_api.fn.widgets.table.create(widget,vid,{preview:true});
    //             $('#ext-dashboard-modal').modal('show');
    //         }
    //     });
    // }
};
var remove = function() {

};
var update = function() {
    
};

// ON DOCUMENT READY
$(document).ready(function() {
    dashexpert_api.util.debugOut(widgettype + ' plugin loaded.');
});
am4core.ready(function() {
    dashexpert_api.util.debugOut('am4charts ready.');
}); // end am4core.ready()
// EXPOSE PUBLIC FUNCTIONS
dashexpert_api.fn.widgets[widgettype] = {
    create : create,
    remove : remove,
    update : update
}

// END Library code
}));