(function (library) {
    // Calls the second IIFE and locally passes in the global jQuery, window, and document objects
    library(window, document, window.jQuery);
}
// Locally scoped parameters 
(function (window, document, $) {
//VARIABLES
dashexpert_api.widgets = dashexpert_api.widgets || {};
dashexpert_api.widgets.types = dashexpert_api.widgets.types || [];
dashexpert_api.widgets.xref = dashexpert_api.widgets.xref || {};
dashexpert_api.widget_preferences = dashexpert_api.widget_preferences || {};
dashexpert_api.settings.amchartsReg = dashexpert_api.settings.amchartsReg || {};

var widgettype = 'amchart_pie';
dashexpert_api.widgets.types.push(widgettype);
dashexpert_api.widget_preferences[widgettype] = {
    data_mapping: 'single', // single or multi
    searchable: true,
    iconclass: 'fa-pie-chart',
    cache: true,
    blacklist: ['h_limit','m_limit','l_limit'],
    SearchIndicator: true,
    restrictSearch: []
};
dashexpert_api.widgets.xref[widgettype] = 'Pie Chart';
dashexpert_api.widgets[widgettype] = {  // [Label,type,{default|hint|options|errorcheck}]
    apistring : ['apistring','textarea',{
      default : '',
      hint : 'This is the current APIString defined by the datasource.  Changes made here will override the datasource.  We recommend that you always use the following option of "rating": "2" in order to display color and formatting correctly.  This string is used to get the data that will be used for creating the widget.',
      errorcheck : [['json','API String must be valid JSON.']]
    }],
    type : ['Type','hidden',{default : 'pie'}],
    info : ['Display Extended Info','checkbox',{default : false,hint : 'Display Extended info as a popup'}],
    limit : ['Data Limit','hidden',{default : 25}]
};

//WIDGET SPECIFIC FUNCTIONS

// API Functions
var create = function(widget,vid) { // pass widget object and vid (target)
    if(dashexpert_api.settings.theme === 'theme-dark') {
        am4core.useTheme(am4themes_amchartsdark);
    } else {
        am4core.useTheme(am4themes_animated);
    }
    var apistring = atob(amplify.store('map_' + vid)); //get APIString
    var data = amplify.store(btoa(apistring)); //get Data from encoded APIString
    var acdata = dashexpert_api.fn.widget_libraries.convertData(data,false);
    acdata = acdata.splice(0,25);  // hard limit at 25
    apistring = JSON.parse(apistring); // parse to object
    var target = 'widget_' + vid;
    $('#' + target).addClass('widget-amchart');
    $('#' + target + ' .panel-body').attr('id',target + '_body');
    var widgetHeight = $('#' + target).parent().parent().data('gs-height');
    var widgetWidth = $('#' + target).parent().parent().data('gs-width');
    var columndata = dashexpert_api.fn.widget_libraries.getDataColumn(widget,data);
    var sprkoptions = dashexpert_api.fn.widget_libraries.getDefaults(widgettype,widget.options);

    var chart = dashexpert_api.fn.widget_libraries.createChart(target + '_body', am4charts.PieChart);
    //assign data to chart
    chart.data = acdata;
    // CREATE COLOR LIST
    var colorSet = new am4core.ColorSet();
    colorSet.list = [
        "#182D57",
        "#203F6C",
        "#227BB1",
        "#57B2E3",
        "#EA8124",
        "#F7931E",
        "#FF9933",
        "#FF9F48",
        "#E0CC36",
        "#E8D946",
        "#EFDD5E",
        "#F9E469",
        "#8CC63F",
        "#9ECE51",       
        "#AED661",     
        "#BBDD72",     //lgreen
        "#372441",     //purple
        "#563865",
        "#714B84",
        "#8C64A0",     //lpurple
        "#8ED0F2",     //llblue
        "#B8E1FB",
        "#FFA75F",     //llorange
        "#FFB579",
        "#FFEA80",     //llyellow
        "#FFEEA4",
        "#CFE589",     //llgreen
        "#E5F2AD",             
        "#A57FB7",     //llpurple
        "#BBA1C9",
        "#827795",     //lpurple2
        "#766C91",
        "#605971",     //graypurple
        "#65738E",     //lgray
        "#383D4E",     //dgray
        "#813B3D",     //brownred
        "#BC5E52",
        "#EE8B78"
    ].map(function(color) {
      return new am4core.color(color);
    });
    // Set input format for the dates
    chart.dateFormatter.inputDateFormat = 'yyyy-MM-dd HH:mm:ss';

    chart.height = am4core.percent(100);
    // Create chart instance
    chart.startAngle = 180;
    chart.endAngle = 360;

    // Let's cut a hole in our Pie chart the size of 40% the radius
    chart.radius = am4core.percent(70);
    chart.innerRadius = am4core.percent(40);

    // Add and configure Series
    var pieSeries = chart.series.push(new am4charts.PieSeries());
    pieSeries.colors = colorSet;
    pieSeries.dataFields.value = columndata.datacolumn;
    pieSeries.dataFields.category = data.xref[columndata.datacolumn];
    //pieSeries.slices.template.stroke = new am4core.InterfaceColorSet().getFor("background");
    pieSeries.slices.template.strokeWidth = 1;
    pieSeries.slices.template.strokeOpacity = 1;
    pieSeries.labels.template.text = "{category}: {value.value}";
    pieSeries.slices.template.tooltipText = "{category}: {value.value}";
    //chart.legend.valueLabels.template.text = "{value.value}";

    if(widgetHeight > 1) {
        pieSeries.slices.template.cornerRadius = 7;
        pieSeries.slices.template.innerCornerRadius = 5;
    }

    // Disabling labels and ticks on inner circle
    if(widgetWidth < 2) {
        pieSeries.labels.template.disabled = true;
        pieSeries.ticks.template.disabled = true;
    }

    var slice = pieSeries.slices.template;
    slice.states.getKey("hover").properties.scale = 1;
    slice.states.getKey("active").properties.shiftRadius = 0;

    // Drop-shaped tooltips
    pieSeries.tooltip.background.cornerRadius = 5;
    pieSeries.tooltip.background.strokeOpacity = 0;
    pieSeries.tooltip.pointerOrientation = 'vertical';
    pieSeries.tooltip.label.minWidth = 40;
    pieSeries.tooltip.label.minHeight = 40;
    pieSeries.tooltip.label.textAlign = 'middle';
    pieSeries.tooltip.label.textValign = 'middle';
    pieSeries.tooltip.zindex = 10000000000;
    
    pieSeries.tooltip.events.on('propertychanged', function(ev) {
        var amID = ev.target.dataItem._dataContext.amID;
        $('.widget-info .panel-body').html('');
        var wid = $('#' + target).parent().data('wid');
        if(dashexpert_api.fn.widgets.datablocks.create) {
            var exists = dashexpert_api.fn.dataExists(vid,{autoload:true,wid:wid});
            if(exists && typeof ev.target.dataItem._dataContext !== 'undefined') {
                dashexpert_api.fn.widgets.datablocks.create(widget,vid,amID);
            }
        }
    });
    chart.responsive.enabled = true;
    // var label = chart.seriesContainer.createChild(am4core.Label);
    // label.textAlign = "middle";
    // label.horizontalCenter = "middle";
    // label.verticalCenter = "bottom";
    // label.adapter.add("text", function(text, target){
    //     return "[font-size:18px]total[/]:\n[bold font-size:30px]" + Math.round((pieSeries.dataItem.values.value.sum + Number.EPSILON) * 100) / 100 + "[/]";
    // });

    dashexpert_api.util.debugOut('Build amchart-pie: ' + widget.title);
    dashexpert_api.util.debugOut(acdata);
    $('#' + target + ' .panel-heading').attr('title', widget.description);
    $('#' + target + ' .panel-heading .panel-title span:first').html(widget.title);
    if(dashexpert_api.fn.widgets.table.create) {
        $('#' + target + ' .panel-body').off().on('click', function(e) {
            e.preventDefault();
            var wid = $('#' + target).parent().data('wid');
            var exists = dashexpert_api.fn.dataExists(vid,{autoload:true,wid:wid});
            if(exists) {
                $('#ext-dashboard-modal .modal-title').html('Showing Data for ' + widget.title);
                $('#ext-dashboard-modal .panel-body').empty();
                dashexpert_api.fn.widgets.table.create(widget,vid,{preview:true});
                $('#ext-dashboard-modal').modal('show');
            }
        });
    }
};
var remove = function() {

};
var update = function() {
    
};

// ON DOCUMENT READY
$(document).ready(function() {
    dashexpert_api.util.debugOut(widgettype + ' plugin loaded.');
    var waitForFinalEvent = (function () {
      var timers = {};
      return function (callback, ms, uniqueId) {
        if (!uniqueId) {
          uniqueId = "Don't call this twice without a uniqueId";
        }
        if (timers[uniqueId]) {
          clearTimeout (timers[uniqueId]);
        }
        timers[uniqueId] = setTimeout(callback, ms);
      };
    })();
});
am4core.ready(function() {
    dashexpert_api.util.debugOut('am4charts ready.');
}); // end am4core.ready()
// EXPOSE PUBLIC FUNCTIONS
dashexpert_api.fn.widgets[widgettype] = {
    create : create,
    remove : remove,
    update : update
}

// END Library code
}));
