(function (library) {
    // Calls the second IIFE and locally passes in the global jQuery, window, and document objects
    library(window, document, window.jQuery);
}
// Locally scoped parameters 
(function (window, document, $) {
    // Add amCharts 4 license
am4core.addLicense("CH82170798");
//VARIABLES
dashexpert_api.widgets = dashexpert_api.widgets || {};
dashexpert_api.widgets.types = dashexpert_api.widgets.types || [];
dashexpert_api.widgets.xref = dashexpert_api.widgets.xref || [];
dashexpert_api.widget_preferences = dashexpert_api.widget_preferences || {};
dashexpert_api.settings.amchartsReg = dashexpert_api.settings.amchartsReg || {};

var widgettype = 'amchart_line';
dashexpert_api.widgets.types.push(widgettype);
dashexpert_api.widget_preferences[widgettype] = {
    data_mapping: 'single', // single or multi
    searchable: true,
    iconclass: 'fa-area-chart',
    cache: true,
    blacklist: [],
    SearchIndicator: true,
    restrictSearch: []
};
dashexpert_api.widgets.xref[widgettype] = 'Line Chart';
dashexpert_api.widgets[widgettype] = {  // [Label,type,{default|hint|options|errorcheck}]
    apistring : ['apistring','textarea',{
      default : '',
      hint : 'This is the current APIString defined by the datasource.  Changes made here will override the datasource.  We recommend that you always use the following option of "rating": "2" in order to display color and formatting correctly.  This string is used to get the data that will be used for creating the widget.',
      errorcheck : [['json','API String must be valid JSON.']]
    }],
    //chart_type : ['Chart Type','select',{default : 'column', options : [['column','column'],['line','line']]}],
    width : ['Width','text',{default : '100%',hint : 'Width of Chart in pixels or %. '}],
    type : ['Type','hidden',{default : 'line'}],
    info : ['Display Extended Info','checkbox',{default : false,hint : 'Display Extended info as a popup'}],
    lineColor : ['Line Color','color',{default : '#4172c4',hint : 'Color of sparkline in HTML color format.'}],
    lineWidth : ['Line Width','text',{default : '1.5',hint : 'Width of sparkline in pixels.'}],
    fillColor : ['Fill Color','color',{default : '#85b0dd',hint : 'Color of sparkline area in HTML color format.'}],
    spotColor : ['Spot Color','color',{default : '#ffffff',hint : 'Color data points on sparkline in HTML color format.'}],
    minSpotColor : ['Min Spot Color','color',{default : '#f08000',hint : 'Color min data point on sparkline in HTML color format.'}],
    maxSpotColor : ['Max Spot Color','color',{default : '#f08000',hint : 'Color max data point on sparkline in HTML color format.'}],
    highlightSpotColor : ['Highlight Spot Color','color',{default : '#f08000',hint : 'Color highlighted point on sparkline in HTML color format.'}],
    highlightLineColor : ['Highlight Line Color','color',{default : '#f08000',hint : 'Color highlighted vertical line on sparkline in HTML color format.'}],
    spotRadius : ['Spot Radius','text',{default : '2.5',hint : 'Size of the spots on the sparkline.'}],
    normalRangeMin : ['Normal Range Min','text',{default : '0',hint : 'Used to show normal starting range.'}],
    normalRangeMax : ['Normal Range Max','text',{default : '0',hint : 'Used to show normal max range.  If set to a number larger than the <em>Normal Range Min</em>, it will create a filled area behind the sparkline between those two numbers.'}],
    good_label : ['Good Range Label','text',{default : 'GOOD'}],
    fair_label : ['Fair Range Label','text',{default : 'FAIR'}],
    poor_label : ['Poor Range Label','text',{default : 'POOR'}],
    good_txtcolor : ['Good Range Color','color',{default : '#5cb85c'}],
    fair_txtcolor : ['Fair Range Color','color',{default : '#f0ad4e'}],
    poor_txtcolor : ['Poor Range Color','color',{default : '#d9534f'}]
};

//WIDGET SPECIFIC FUNCTIONS

// API Functions
var create = function(widget,vid) { // pass widget object and vid (target)
    if(dashexpert_api.settings.theme === 'theme-dark') {
        am4core.useTheme(am4themes_amchartsdark);
    } else {
        am4core.useTheme(am4themes_animated);
    }
    var apistring = atob(amplify.store('map_' + vid)); //get APIString
    var data = amplify.store(btoa(apistring)); //get Data from encoded APIString
    var acdata = dashexpert_api.fn.widget_libraries.convertData(data);
    apistring = JSON.parse(apistring); // parse to object
    var target = 'widget_' + vid;
    $('#' + target).addClass('widget-amchart');
    $('#' + target + ' .panel-body').attr('id',target + '_body');
    var widgetHeight = $('#' + target).parent().parent().data('gsHeight');
    var columndata = dashexpert_api.fn.widget_libraries.getDataColumn(widget,data);
    var sprkoptions = dashexpert_api.fn.widget_libraries.getDefaults(widgettype,widget.options);

    //create chart
    var chart = dashexpert_api.fn.widget_libraries.createChart(target + '_body', am4charts.XYChart);
    //assign data to chart
    chart.data = acdata;
    // Set input format for the dates
    chart.dateFormatter.inputDateFormat = 'yyyy-MM-dd HH:mm:ss';
    if(widgetHeight < 2) {
        chart.properties.paddingTop = 0;
        chart.properties.paddingBottom = 0;
        chart.titles.template.fontSize = 10;
        chart.titles.template.textAlign = "left";
        chart.titles.template.isMeasured = false;
    }
    chart.properties.paddingLeft = 5;
    chart.properties.paddingRight = 5;
    //chart.responsive.enabled = true;
    // Create axes
    if(apistring.sort_col === 'end_date') {
        var timeUnit = 'hour';
        var dateAxis = chart.xAxes.push(new am4charts.DateAxis());
        switch(apistring.resolution) {
            case 'CID':
                timeUnit = 'minute';
                break;
            case 'day':
                timeUnit = 'day';
                break;
            case 'Monthly':
                timeUnit = 'month';
                chart.dateFormatter.inputDateFormat = 'yyyy-MM';
                break;
            default:
                timeUnit = 'hour';
                break;
        }
        dateAxis.baseInterval = { 
            "timeUnit": timeUnit,
            "count": 1
        }
        dateAxis.tooltipDateFormat = 'HH:mm:ss';
        dateAxis.renderer.grid.template.disabled = true;
        if(widgetHeight < 2) {
            dateAxis.renderer.grid.template.disabled = true;
            dateAxis.renderer.labels.template.disabled = true;
            dateAxis.cursorTooltipEnabled = false;
        }
    } else {
        var catAxis = chart.xAxes.push(new am4charts.CategoryAxis());
        catAxis.dataFields.category = columndata.datacolumn;
        catAxis.title.text = data.xref[columndata.datacolumn];
        catAxis.renderer.grid.template.disabled = true;
        //catAxis.renderer.labels.template.disabled = true;
        catAxis.title.text = "";
        if(widgetHeight < 2) {
            catAxis.title.text = "";
            catAxis.renderer.grid.template.disabled = true;
            catAxis.renderer.labels.template.disabled = true;
            catAxis.cursorTooltipEnabled = false;
        }
    };
    var valueAxis = chart.yAxes.push(new am4charts.ValueAxis());
    valueAxis.cursorTooltipEnabled = false;
    //valueAxis.renderer.grid.template.disabled = true;
    //valueAxis.renderer.labels.template.disabled = true;
    valueAxis.title.text = "";
    valueAxis.min = 0;
    if(widgetHeight < 2) {
        valueAxis.min = 0;
        valueAxis.renderer.grid.template.disabled = true;
        valueAxis.renderer.baseGrid.disabled = true;
        valueAxis.renderer.labels.template.disabled = true;
    }
    if(parseInt(widget.h_limit) > 0) {
        var h_range = valueAxis.axisRanges.create();
        h_range.value = parseInt(widget.h_limit);
        h_range.grid.stroke = am4core.color(widget.good_txtcolor);
        h_range.grid.strokeWidth = 2;
        h_range.grid.strokeOpacity = 1;
        h_range.label.inside = true;
        h_range.label.text = widget.good_label;
        h_range.label.fill = h_range.grid.stroke;
        //range.label.align = "right";
        h_range.label.verticalCenter = "bottom";
    }
    if(parseInt(widget.m_limit) > 0) {
        var m_range = valueAxis.axisRanges.create();
        m_range.value = parseInt(widget.m_limit); 
        m_range.grid.stroke = am4core.color(widget.fair_txtcolor);
        m_range.grid.strokeWidth = 2;
        m_range.grid.strokeOpacity = 1;
        m_range.label.inside = true;
        m_range.label.text = widget.fair_label;
        m_range.label.fill = m_range.grid.stroke;
        //range2.label.align = "right";
        m_range.label.verticalCenter = "bottom";
    }
    if(parseInt(widget.l_limit) > 0) {
        var l_range = valueAxis.axisRanges.create();
        l_range.value = parseInt(widget.l_limit);
        l_range.grid.stroke = am4core.color(widget.poor_txtcolor);
        l_range.grid.strokeWidth = 2;
        l_range.grid.strokeOpacity = 1;
        l_range.label.inside = true;
        l_range.label.text = widget.poor_label;
        l_range.label.fill = l_range.grid.stroke;
        //range2.label.align = "right";
        l_range.label.verticalCenter = "bottom";
    }
    // Create series
    var series = chart.series.push(new am4charts.LineSeries());
    series.dataFields.valueY = columndata.datacolumn;
    if(apistring.sort_col === 'end_date') {
        series.dataFields.dateX = 'end_date';
        series.tooltipText = dashexpert_api.fn.widget_libraries.createACTooltip(data.xref, columndata);
    } else {
        series.dataFields.categoryX = columndata.datacolumn;
        //series.dataFields.categoryX = 'category';
        series.tooltipText = dashexpert_api.fn.widget_libraries.createACTooltip(data.xref, columndata);
    }
    series.color = am4core.color('red');
    series.stroke = am4core.color(sprkoptions.lineColor);
    series.strokeWidth = parseFloat(sprkoptions.lineWidth);
    series.minBulletDistance = 15;
    series.fill = am4core.color(sprkoptions.fillColor);
    series.fillOpacity = 0.3;

    // Drop-shaped tooltips
    series.tooltip.background.cornerRadius = 5;
    series.tooltip.background.strokeOpacity = 0;
    series.tooltip.pointerOrientation = 'vertical';
    series.tooltip.label.minWidth = 40;
    series.tooltip.label.minHeight = 40;
    series.tooltip.label.textAlign = 'middle';
    series.tooltip.label.textValign = 'middle';
    series.tooltip.zindex = 10000000000;
    
    series.tooltip.events.on('propertychanged', function(ev) {
        var amID = ev.target.dataItem._dataContext.amID;
        $('.widget-info .panel-body').html('');
        var wid = $('#' + target).parent().data('wid');
        if(dashexpert_api.fn.widgets.datablocks.create) {
            var exists = dashexpert_api.fn.dataExists(vid,{autoload:true,wid:wid});
            if(exists && typeof ev.target.dataItem._dataContext !== 'undefined') {
                dashexpert_api.fn.widgets.datablocks.create(widget,vid,amID);
            }
        }
    });
    // series.tooltip.events.on('hidden', function(ev) {
    //     $('.widget-info .panel-body').html('<h4>mouseover a chart to display extended information here</h4>');
    // });

    // Make bullets grow on hover
    var bullet = series.bullets.push(new am4charts.CircleBullet());
    bullet.circle.strokeWidth = 2;
    bullet.circle.radius = sprkoptions.spotRadius;
    bullet.circle.fill = am4core.color(sprkoptions.spotColor);

    var bullethover = bullet.states.create('hover');
    bullethover.properties.scale = 1.3;

    // bullet.events.on('over', function(ev) {
    //     console.log(ev.target.dataItem._dataContext.amID);
    //     $('.widget-info .panel-body').html('');
    //     var wid = $('#' + target).parent().data('wid');
    //     if(dashexpert_api.fn.widgets.datablocks.create) {
    //         var exists = dashexpert_api.fn.dataExists(vid,{autoload:true,wid:wid});
    //         if(exists) {
    //             dashexpert_api.fn.widgets.datablocks.create(widget,vid,ev.target.dataItem._dataContext.amID);
    //         }
    //     }
    // });
    // bullet.events.on('out', function(ev) {
    //     $('.widget-info .panel-body').html('<h4>mouseover a chart to display extended information here</h4>');
    // });
    // Make a panning cursor
    chart.cursor = new am4charts.XYCursor();
    if(widgetHeight > 1) {
        chart.cursor.behavior = 'panX';
        chart.cursor.lineY.disabled = true;
        if(apistring.sort_col === 'end_date') {
            chart.cursor.xAxis = dateAxis;
        } else {
            chart.cursor.xAxis = catAxis;
        }
        chart.cursor.snapToSeries = series;
    } else {
        chart.cursor.lineY.disabled = true;
    }

    // // Create vertical scrollbar and place it before the value axis
    // chart.scrollbarY = new am4core.Scrollbar();
    // chart.scrollbarY.parent = chart.leftAxesContainer;
    // chart.scrollbarY.toBack();

    // // Create a horizontal scrollbar with previe and place it underneath the date axis
    // chart.scrollbarX = new am4charts.XYChartScrollbar();
    // chart.scrollbarX.series.push(series);
    // chart.scrollbarX.parent = chart.bottomAxesContainer;

    // dateAxis.start = 0.79;
    // dateAxis.keepSelection = true;
    

    dashexpert_api.util.debugOut('Build amchart-line: ' + widget.title);
    dashexpert_api.util.debugOut(acdata);
    $('#' + target + ' .panel-heading').attr('title', widget.description);
    $('#' + target + ' .panel-heading .panel-title span:first').html(widget.title);
    if(dashexpert_api.fn.widgets.table.create) {
        $('#' + target + ' .panel-body').off().on('click', function(e) {
            e.preventDefault();
            var wid = $('#' + target).parent().data('wid');
            var exists = dashexpert_api.fn.dataExists(vid,{autoload:true,wid:wid});
            if(exists) {
                $('#ext-dashboard-modal .modal-title').html('Showing Data for ' + widget.title);
                $('#ext-dashboard-modal .panel-body').empty();
                dashexpert_api.fn.widgets.table.create(widget,vid,{preview:true});
                $('#ext-dashboard-modal').modal('show');
            }
        });
    }
};
var remove = function() {

};
var update = function() {
    
};

// ON DOCUMENT READY
$(document).ready(function() {
    dashexpert_api.util.debugOut(widgettype + ' plugin loaded.');
});
am4core.ready(function() {
    dashexpert_api.util.debugOut('am4charts ready.');
}); // end am4core.ready()
// EXPOSE PUBLIC FUNCTIONS
dashexpert_api.fn.widgets[widgettype] = {
    create : create,
    remove : remove,
    update : update
}

// END Library code
}));