var dashexpert_api = dashexpert_api || {};
dashexpert_api.settings = {
  apidomain     : window.location.protocol + "//" + document.domain,
  apiurl        : window.location.protocol + "//" + document.domain + "/lwl/api",
  version       : "6.5.1-2",
  copyright     : "Copyright 2021, Liquidware Labs, Inc.",
  configurl     : "json/example.json",
  libraryurl  : "lib",
  clientip    : "",
  debug     : false,
  editmodeon : false,
  ajaxqsize : 8,
  localcache : true,
  datacache : 1200000, // milliseconds
  autorefresh : true,
  refreshtime : 1200000,
  apilimit : 1000,
  wildsearch: true,
  searchSort: false,
  searchMatch: {},
  ajaxq     : [],
  apistrings : [],
  layouttarget  : "#outer_container",
  dashGridHeight : 100,
  currentEditView : {},
  current_dashoverrides : {},
  system : false,
  system_readonly : true,
  ignore_lastupdate : false,
  searchAPI : {},
  searchtext : "",
  defaultdate : "Today",
  sessionAuthorized : true,
  dash_super_admin : ['dash_super_admin'],
  dash_admin_group : ['dash_admin'],//dash_admin
  dash_user_group : ['dash_user'],//dash_user
  theme : 'theme-default',
  themes : ['theme-default','theme-dark'],
  hide_skipcolumns : true,
  skipcolumns : 'end_date,node_id,user_id,user_group_id,node_group_id,datastore_id,current_host_id,login_id,client_info_policy_auto_connect_client_com_ports,client_info_policy_auto_connect_client_lpt_ports,session_id,vmhost_id',
  basis_blacklist : 'end_date,session_start,session_data,client_info,thinwire_info,d3d_info,graphic_info,network_info,media_stream_info,flash_info,branch_repeater_info',
  datatables: {
    pageLength : 10,
    wbrowse : { order : [[0, 'asc']], search : '', pageLength : 10, displayStart: 0},
    dbrowse : { order : [[0, 'asc']], search : '', pageLength : 10, displayStart: 0},
    vbrowse : { order : [[0, 'asc']], search : '', pageLength : 100, lengthMenu : [[100, -1],[100, 'All']], displayStart: 0}
  },
  use_legacy_charts : false,
  load_dashboards : ['dashboard-1536010369776','dashboard-1534628895985','dashboard-1495142775194','dashboard-1534690385144'],
  unload_dashboards : []
};
dashexpert_api.selectajaxsize = [
  ['1',1],
  ['2',2],
  ['3',3],
  ['4',4],
  ['5',5],
  ['6',6]
];
dashexpert_api.selectcache = [
  //['5',300000],
  //['10',600000],
  ['15',900000],
  ['20',1200000],
  ['30',1800000],
  ['60',3600000]
];
dashexpert_api.preferences = {
  //datacache : ['Data Cache', 'text',{default: dashexpert_api.settings.datacache, hint: 'Number of milliseconds to cache data', errorcheck: [['number','Invalid Data Cache [ms]']]}],
  defaultdate : ['Default Date', 'select',{default : dashexpert_api.settings.defaultdate, hint: 'Default Search Date to use.'}],
  localcache : ['Use Local Cache', 'checkbox',{default: dashexpert_api.settings.localcache, acl : 'admin'}],
  refreshtime : ['Refresh (minutes)', 'select',{default: dashexpert_api.settings.refreshtime, options: dashexpert_api.selectcache, hint: 'Number of minutes before autorefresh dashboard data', errorcheck: [['number','Invalid refresh [minutes]']]}],
  autorefresh : ['Auto Refresh', 'checkbox',{default : dashexpert_api.settings.refreshtime}],
  wildsearch : ['Auto Wildcard Search', 'checkbox',{default : dashexpert_api.settings.wildsearch, hint: 'If enabled, wildcards will be added to beginning and end of search text.'}],
  hide_skipcolumns : ['Hide Advanced Search', 'checkbox',{default: dashexpert_api.settings.hide_skipcolumns, hint: 'Hides ID based search columns'}],
  //trending : ['Trending', 'checkbox',{default: false, hint: 'Turn on trending for search results'}],
  theme : ['Dashboard Theme', 'select',{default : 'default',options : [['Default','theme-default'],['Dark','theme-dark']]}],
  apidomain : ['Stratusphere API FQDN/IP','text',{default : document.domain, acl : 'admin'}],
  ajaxqsize : ['Max Concurrent Connections', 'text',{default : dashexpert_api.settings.ajaxqsize, hint: 'Maximum number of connections (default 8)', errorcheck : [['number','Invalid max connections size']]}],
  debug : ['Debug (output to console)', 'checkbox',{default : dashexpert_api.settings.debug, acl : 'admin'}],
  editmodeon : ['Enable Edit Mode', 'checkbox',{default: dashexpert_api.settings.editmodeon, acl : 'admin'}],
  system_readonly : ['Protect System Defaults', 'checkbox',{default: dashexpert_api.settings.system_readonly, hint: 'Protect System Default dashboards|widgets|datasources (This option may be removed in future versions)', acl : 'admin'}]
};
dashexpert_api.advanced_preferences = [
  {
    tab : 'General',
    fields : {
      localcache : ['Use Local Cache', 'checkbox',{default: dashexpert_api.settings.localcache}],
      //apilimit : ['API Limit', 'text',{default : dashexpert_api.settings.apilimit, hint: 'This limits the number of records returned by the api.  Set to 0 for unlimited.', errorcheck : [['number','Invalid Number']]}],
      apilimit : ['API Limit', 'select',{default : dashexpert_api.settings.apilimit,options : [['25','25'],['100','100'],['500','500'],['1000','1000'],['no limit','0']], hint: 'This limits the number of records returned by the api.'}],
      refreshtime : ['Refresh (minutes)', 'select',{default: dashexpert_api.settings.refreshtime, options: dashexpert_api.selectcache, hint: 'Number of minutes before autorefresh dashboard data', errorcheck: [['number','Invalid refresh [minutes]']]}],
      theme : ['Dashboard Theme', 'select',{default : 'default',options : [['Default','theme-default'],['Dark','theme-dark']]}],
      apidomain : ['Stratusphere API FQDN/IP','text',{default : document.domain, acl : 'admin'}],
      ajaxqsize : ['Max Concurrent Connections', 'text',{default : dashexpert_api.settings.ajaxqsize, hint: 'Maximum number of connections (between 1 - 8)', errorcheck : [['number','max connections size must be a valid number'],['less-than|8','max connections size must be between 1 - 8'],['greater-than|0','max connections size must be between 1 - 8']]}],
      debug : ['Debug (output to console)', 'checkbox',{default : dashexpert_api.settings.debug, acl : 'admin'}],
      editmodeon : ['Enable Edit Mode (preview)', 'checkbox',{default: dashexpert_api.settings.editmodeon, acl : 'admin'}],
      system_readonly : ['Protect System Defaults', 'checkbox',{default: dashexpert_api.settings.system_readonly, hint: 'Protect System Default dashboards|widgets|datasources (This option may be removed in future versions)', acl : 'admin'}],
      use_legacy_charts : ['Use Legacy bar/line Charts', 'checkbox',{default: dashexpert_api.settings.use_legacy_charts, hint: 'If you are experiencing issues check this box to use legacy bar/line charts.'}]
    }
  },
  { 
    tab : 'Search',
    fields : {
      defaultdate : ['Default Date', 'select',{default : dashexpert_api.settings.defaultdate, hint: 'Default Search Date to use.'}],
      wildsearch : ['Auto Wildcard Search', 'checkbox',{default : dashexpert_api.settings.wildsearch, hint: 'If enabled, wildcards will be added to beginning and end of search text.'}],
      searchSort : ['Sort Search Fields', 'checkbox',{default : dashexpert_api.settings.searchSort, hint: 'If enabled, Search fields will be sorted alphabetically.'}],
      hide_skipcolumns : ['Hide Advanced Search', 'checkbox',{default: dashexpert_api.settings.hide_skipcolumns, hint: 'Hides ID based search columns'}],
      skipcolumns : ['Advanced Search Fields', 'text',{default: dashexpert_api.settings.skipcolumns, hint: 'Comma separated list of columns to hide from normal search', acl : 'admin'}]
    }
  },
  { 
    tab : 'Utilities',
    fields : {
      import_btn : ['Import Dashboard', 'button',{default: dashexpert_api.settings.import_btn, hint: 'Import a previously exported dashboard (JSON format)', btnclass : 'info', acl : 'admin'}],
      resetp_btn : ['Reset Preferences', 'button',{default: dashexpert_api.settings.resetp_btn, hint: 'Reset Preferences to default settings.', btnclass : 'info', acl : 'user'}]
    }
  }
];
dashexpert_api.fn = {
  widgets : {}
};
dashexpert_api.data = {
  datasources   : {},
  widgets       : {},
  dashboards    : {}
};
dashexpert_api.searchbar = {
  select_date : {
    "default":[" ","Today"],
    "optgroup_1":["Today"],
      "today":["Today","today"],
      "today_15":["15 Minutes","15 minutes"],
      "today_30":["30 Minutes","30 minutes"],
      "today_1h":["1 Hour","1 hours"],
      "today_2h":["2 Hours","2 hours"],
      "today_4h":["4 Hours","4 hours"],
      "today_8h":["8 Hours","8 hours"],
      "today_12h":["12 Hours","12 hours"],
      "today_24h":["24 Hours","24 hours"],
    "optgroup_2":["Today and"],
      "today_yesterday":["Today and Yesterday","Today and Yesterday"],
      "today_plus2":["Today + 2 Days","today and 2 days"],
      "today_plus3":["Today + 3 Days","today and 3 days"],
      "today_plus5":["Today + 5 Days","today and 5 days"],
      "today_plus7":["Today + 7 Days","today and 7 days"],
    "optgroup_3":["Yesterday"],
      "yesterday":["Yesterday","yesterday"],
      "last_3":["Last 3 Days","last 3 days"],
      "last_5":["Last 5 Days","last 5 days"],
      "last_7":["Last 7 Days","last 7 days"],
      "last_14":["Last 14 Days","last 14 days"],
      "last_30":["Last 30 Days","last 30 days"],
      "last_45":["Last 45 Days","last 45 days"],
      "last_60":["Last 60 Days","last 60 days"],
      "last_90":["Last 90 Days","last 90 days"],
    "optgroup_4":["Weekly"],
      "this_week":["This Week","this week"],
      "week_plus1":["1 Week Ago","1 Week Ago"],
      "week_plus2":["2 Weeks Ago","2 Weeks Ago"],
      "week_plus3":["3 Weeks Ago","3 Weeks Ago"],
      "week_plus4":["4 Weeks Ago","4 Weeks Ago"],
      "week_plus5":["5 Weeks Ago","5 Weeks Ago"],
      "week_plus6":["6 Weeks Ago","6 Weeks Ago"],
    "optgroup_5":["Monthly"],
      "this_month":["This Month","this month"],
      "month_plus1":["1 Month Ago","1 Month Ago"],
      "month_plus2":["2 Months Ago","2 Months Ago"],
      "month_plus3":["3 Months Ago","3 Months Ago"],
      "month_plus4":["4 Months Ago","4 Months Ago"],
      "month_plus5":["5 Months Ago","5 Months Ago"],
      "month_plus6":["6 Months Ago","6 Months Ago"]
  },
  select_time : {
    "default":[""],
    "0" : ["00:00","0"],
    "1" : ["01:00","1"],
    "2" : ["02:00","2"],
    "3" : ["03:00","3"],
    "4" : ["04:00","4"],
    "5" : ["05:00","5"],
    "6" : ["06:00","6"],
    "7" : ["07:00","7"],
    "8" : ["08:00","8"],
    "9" : ["09:00","9"],
    "10" : ["10:00","10"],
    "11" : ["11:00","11"],
    "12" : ["12:00","12"],
    "13" : ["13:00","13"],
    "14" : ["14:00","14"],
    "15" : ["15:00","15"],
    "16" : ["16:00","16"],
    "17" : ["17:00","17"],
    "18" : ["18:00","18"],
    "19" : ["19:00","19"],
    "20" : ["20:00","20"],
    "21" : ["21:00","21"],
    "22" : ["22:00","22"],
    "23" : ["23:00","23"]
  },
  select_end_time : {
    "default":[""],
    "0" : ["00:59","0"],
    "1" : ["01:59","1"],
    "2" : ["02:59","2"],
    "3" : ["03:59","3"],
    "4" : ["04:59","4"],
    "5" : ["05:59","5"],
    "6" : ["06:59","6"],
    "7" : ["07:59","7"],
    "8" : ["08:59","8"],
    "9" : ["09:59","9"],
    "10" : ["10:59","10"],
    "11" : ["11:59","11"],
    "12" : ["12:59","12"],
    "13" : ["13:59","13"],
    "14" : ["14:59","14"],
    "15" : ["15:59","15"],
    "16" : ["16:59","16"],
    "17" : ["17:59","17"],
    "18" : ["18:59","18"],
    "19" : ["19:59","19"],
    "20" : ["20:59","20"],
    "21" : ["21:59","21"],
    "22" : ["22:59","22"],
    "23" : ["23:59","23"]
  },
  select_resolution : { 
    "default":[""],
    "all":["All","All"],
    "s-1":["-------------"],
    "month":["Month","Monthly"],
    "day":["Day","day"],
    "day-hour":["Day-Hour","Day-Hour"],
    "cid":["CID Level","CID"],
    "s-2":["-------------"],
    "hourly":["Hourly (0-23)","hourly"],
    "dow":["Day of Week","dow"]
  },
  select_limit : { 
    "1":["1","1"],
    "10":["10","10"],
    "50":["50","50"],
    "100":["100","100"],
    "200":["200","200"],
    "500":["500","500"]
  }
};
dashexpert_api.defaultdash = {
  "newgrid": {
      "name": "",
      "description": "",
      "system": dashexpert_api.settings.system,
      "autoload": true,
      "sort_order": 100,
      "grid": []
  }
};
// UI Variables for generation of forms
dashexpert_api.nossid = false;
dashexpert_api.dashboards = {};
dashexpert_api.datasources = {};
dashexpert_api.widgets = dashexpert_api.widgets || {};
// dashexpert_api.widget_defaults = dashexpert_api.widget_defaults || {};
// dashexpert_api.widget_defaults = {
//     title : ['Title','text',{
//       default : '',
//       hint : 'Title of Datasource.',
//       errorcheck : [['required','Title required.']]
//     }],
//     description : ['Description','textarea',{default : ''}],
//     group : ['Group','text',{default : '',hint : 'Use a group name to add this widget to a group.'}],
//     owner : ['Owner','text',{default : ''}],
//     usergroup : ['User Group','text',{default : 'dash_users'}],
//     dcolumn : ['Data Column','select',{default : '',hint : 'Column to use for metrics display.'}],
//     scolumn : ['Sort Column','select',{default : '',hint : 'Column to use for sorting (usually same as Data Column).'}],
//     sort_order : ['Sort Order','select',{default : '2',options : [['Ascending','1'],['Descending','2']],hint : 'Sort order for metrics.'}],
//     displaycols : ['Display Columns','multiselect',{default : '',hint : 'Columns to display in tables or charts.  Allows you to hide columns from the display.'}],
//     h_limit : ['High Limit Point','text',{default : '0',errorcheck: [['number','Invalid High Limit (must be a number)']],hint : 'Data above this point is considered POOR (unless reverse = true).'}],
//     m_limit : ['Lower Limit Point','text',{default : '0',errorcheck: [['number','Invalid Lower Limit (must be a number)']],hint : 'Data between <em>Lower Limit</em> and the <em>High Limit</em> is considered FAIR and anything lower is considered GOOD (unless reverse = "true", then data between the <em>Reverse Limit</em> and <em>Lower Limit</em> are considered FAIR, and anything lower is considered POOR). '}],
//     l_limit : ['Reverse Limit Point','text',{default : '0',errorcheck: [['number','Invalid Reverse Limit (must be a number)']],hint : 'Only use when reverse = "true".  Data from 0 - <em>Reverse Limit</em> are considered GOOD, otherwise lower limit = 0.'}],
//     override : ['API Override','hidden',{default : true}],
//     apistring : ['API String','textarea',{
//       default : '',
//       hint : 'This is the current API String defined by the datasource.  Changes made here will override the datasource.  We recommend that you always use the following option of "rating": "2" in order to display color and formatting correctly.  This string is used to get the data that will be used for creating the widget.',
//       errorcheck : [['json','API String must be valid JSON.']]
//     }]
// };
dashexpert_api.dashboards.default = {
    name : ['Dashboard Name','text',{default : '',errorcheck : [['required','Name required.']]}],
    description : ['Description','textarea',{default : ''}],
    owner : ['Owner','hidden',{default : []}],
    groups : ['Access Groups','multiselect',{default : dashexpert_api.settings.dash_user_group,hint : 'Groups in Selected will have access to this dashboard. You are only able to add groups which your currently logged in user is part of. If no groups are Selected, Everyone will have access to the dashboard.'}],
    publish : ['Published','checkbox',{default: false, hint : 'Publish this dashboard to selected access groups. If unpublished this dashboard will only be viewable to you.'}],
    //display : ['Display in Tabs','checkbox',{default : true, hint : 'Display this dashboard in a tab.'}],
    system : ['System','hidden',{default : false, type : 'boolean'}],
    sort_order : ['Sort Order','text',{default : 100,hint : 'Used for Ordering the tabs of open dashboards (lowest first).'}],
    grid : ['GridJSON','hidden',{default : [], type : 'array'}],
    id: ['ID','hidden',{default: ''}],
    apistring : ['API String','textarea',{
      default : '',
      hint : 'The most common use for the Dashboard Level API Overide is constraining the dashboard to a search term.  For Example, many Liquidware pre-built dashboards support the following: <strong>{"node_group_name":"Virtual Desktops"}</strong> or <strong>{"node_group_name":"Virtual Desktops","node_name":"vm-10*","user_group_name":"sales"}</strong>',
      errorcheck : [['json','API String must be valid JSON.']]
    }]
};
dashexpert_api.datasources.default = {
    title : ['Title','text',{
      default : '',
      hint : 'Title of Datasource.',
      errorcheck : [['required','Title required.']]
    }],
    system : ['System','hidden',{default : false, type : 'boolean'}],
    description : ['Description','textarea',{default : ''}],
    group : ['Group','text',{default : '',hint : 'Use a group name to add this Datasource to a group.'}],
    apistring : ['API String','textarea',{
      default : '',
      hint : 'API String can be generated using Stratusphere API Builder and must be valid JSON.  <strong>sort_col</strong> is REQUIRED.  We recommend that you always use the following option of "rating": "2" in order to display color and formatting correctly.  This string is used to get the data that will be used for creating the widget.',
      //hint : 'API String contains output from the Stratusphere API Builder (see API documentation or use <a href="#">API Builder</a>).  <strong>sort_col</strong> is REQUIRED.  We recommend that you always use the following option of "rating": "2" in order to display color and formatting correctly.  This string is used to get the data that will be used for creating the widget.',
      errorcheck : [['required','API String required.'],['json','API String must be valid JSON.'],['api','API String is missing one or more of the required values (inspector, basis and sort_col)']]
    }]
};
dashexpert_api.widgets.default = {
    title : ['Title','text',{
      default : '',
      hint : 'Title of widget.',
      errorcheck : [['required','Title required.']]
    }],
    system : ['System','hidden',{default : false, type : 'boolean'}],
    //showtitle : ['Show Title','checkbox',{default : true}],
    description : ['Description','textarea',{default : ''}],
    group : ['Group','text',{default : '',hint : 'Use a group name to add this widget to a group.'}],
    datasource : ['Datasource','select',{default : '',errorcheck : [['required','Widget must have a datasource.']]}],
    //dcolumn : ['Data Column','text',{default : '',hint : 'Available columns: '}],
    dcolumn : ['Data Column','select',{default : '',hint : 'Column to use for metrics display.'}],
    scolumn : ['Sort Column','select',{default : '',hint : 'Column to use for sorting (usually same as Data Column).'}],
    sort_order : ['Sort Order','select',{default : '2',options : [['Ascending','1'],['Descending','2']],hint : 'Sort order for metrics.'}],
    displaycols : ['Display Columns','multiselect',{default : '',hint : 'Columns to display in tables or charts.  Allows you to hide columns from the display.'}],
    //displaycols : ['Display Columns','multiselect',{default : '',hint : 'Columns to display in tables or charts.  Allows you to hide columns from the display.'}],
    h_limit : ['High Limit Point','text',{default : '0',errorcheck: [['number','Invalid High Limit (must be a number)']],hint : 'Data above this point is considered POOR (unless reverse = true).'}],
    m_limit : ['Lower Limit Point','text',{default : '0',errorcheck: [['number','Invalid Lower Limit (must be a number)']],hint : 'Data between <em>Lower Limit</em> and the <em>High Limit</em> is considered FAIR and anything lower is considered GOOD (unless reverse = "true", then data between the <em>Reverse Limit</em> and <em>Lower Limit</em> are considered FAIR, and anything lower is considered POOR). '}],
    l_limit : ['Reverse Limit Point','text',{default : '0',errorcheck: [['number','Invalid Reverse Limit (must be a number)']],hint : 'Only use when reverse = "true".  Data from 0 - <em>Reverse Limit</em> are considered GOOD, otherwise lower limit = 0.'}],
    locked : ['Lock API','checkbox',{default : false,hint : 'Locking widget will ensure that API overrides will always remain even when a search modifies the API.'}],
    override : ['Override','checkbox',{default : true,hint : 'Allow API String to be overridden using parameters in API Box.'}]
    //override : ['Override','hidden',{default : true, type : 'boolean'}]
};
dashexpert_api.widgets.info_default = {
    title : ['Title','text',{
      default : '',
      hint : 'Title of widget.',
      errorcheck : [['required','Title required.']]
    }],
    //showtitle : ['Show Title','checkbox',{default : true}],
    description : ['Description','textarea',{default : ''}],
    group : ['Group','text',{default : '',hint : 'Use a group name to add this widget to a group.'}]
};

// AmChart Defaults
dashexpert_api.settings.amcharts = {
  themes : ['animated'],
  defaults : {
    ColumnSeries : {

    },
    LineSeries : {

    }
  }
};

dashexpert_api.xref_defaults = {
    end_date : 'End Date-Hour',
    cpu_used_percent : 'CPU Used %',
    cpu_allocated_mhz : 'CPU MHz Allocated',
    cpu_used_mhz : 'CPU Used MHz',
    cpu_sys_mhz : 'CPU Kernel Mode MHz',
    cpu_user_mhz : 'CPU User Mode MHz',
    cpu_queue_length_avg : 'CPU Queue',
    total_cores_cpus : 'CPU Cores Allocated',
    sum_total_cores_cpus : 'Sum CPU Cores',
    sum_cpu_used_mhz : 'Sum CPU Used MHz',
    node_count : 'Machine Count',
    user_count : 'Users on Machine',
    cid_seconds_avg : 'CID Records Avg Hours',
    application_name : 'Stratusphere App Name',
    application_version : 'Application Version',
    process_name : 'Process Name',
    score : 'Workload Ranking',
    gpu_load_avg : 'GPU Core Used %',
    x_cpu_used_mhz : 'CPU Used MHz Per App Avg',
    x_memory_used_mb : 'Memory Used MB Per App Avg',
    memory_used_mb : 'Memory Used MB',
    x_page_faults : 'Page Faults Per App Avg',
    page_faults : 'Page Faults',
    x_gdi_objects : 'GDI Objects Per App Avg',
    gdi_objects : 'GDI Objects',
    x_total_iops : 'Disk IOPS Per App Avg',
    total_iops : 'Disk IOPS',
    x_total_io_bps : 'Disk IO Per App Avg',
    total_io_bps : 'Disk IO KBs',
    x_net_total_io_kbps : 'Network IO Per App Avg',
    net_total_io_kbps : 'Network IO KBs',
    pn_jitter_avg : 'Connection Jitter ms',
    thread_average : 'Thread Count Per App Avg',
    handle_avg : 'Handle Count Per App Avg',
    sum_handle_avg : 'Handle Count',
    application_load_time_avg : 'App Load Time',
    app_load_time_raw : 'App Load Time (raw)',
    app_load_count : 'App Load Count',
    non_responding_apps : 'App Not Responding "ANR"',
    desk_app_process_elevated : 'Process Privilege Elevated',
    owner_count : 'Process Owner Count',
    app_id_count : 'App ID Count',
    os_count : 'O/S Count',
    desk_app_id_count : 'App Name Count',
    rank_score : 'Workload Score',
    cid_seconds : 'Avg CID Minutes',
    sum_cid_seconds : 'Total CID Hours',
    record_count : 'CID Record Count',
    memory_used_percent : 'Memory Used %',
    memory_allocated_mb : 'Memory Allocated MB',
    cache_memory_used_mb : 'Cache Memory Used MB',
    page_used_mb : 'Page Used MB',
    sum_memory_used_mb : 'Sum Memory Used MB',
    sum_page_used_mb : 'Sum Pagefile Used MB',
    disk_utilization_percent_avg : 'Disk Active %',
    disk_queue_avg : 'Disk Queue',
    disk_response_time_ms_avg : 'Disk Response',
    total_iops_all : 'Combined IOPS',
    total_io_bps_all : 'Combined IO KBs',
    sum_total_io : 'Sum Disk IO MB',
    disk_count : 'Disk Count',
    net_total_bps : 'Network IO KBs',
    network_latency_ms_avg : 'Network Latency',
    avg_inc_nrt : 'Session Latency',
    failed_connects : 'Failed Connects',
    sum_net_total_bytes : 'Sum Network IO MB',
    ip_addr_count : 'IP Count',
    gpu_percent_used : 'GPU Core Used %',
    d_gpu_mem_used_percent : 'GPU Memory Used %',
    gpu_decoder_percent_avg : 'GPU Decoder %',
    gpu_encoder_percent_avg : 'GPU Encoder %',
    d_fanspeed : 'GPU Fan Speed',
    d_thermalavg : 'GPU Thermal Temp',
    d_gpu_mem_used : 'GPU Memory Used MB',
    sum_memory_allocated_mb : 'Sum Memory Allocated MB',
    cpu_context_switching_avg : 'Context Switching',
    login_delay_avg : 'Login Delay',
    login_count : 'Login Count',
    logout_count : 'Logout Count',
    page_used_percent : 'Pagefile Used %',
    disk_used_percent : 'Disk Space Used %',
    sum_cpu_allocated_mhz : 'Sum CPU Allocated MHz',
    sum_page_allocated_mb : 'Sum Pagefile Allocated MB',
    user_name : 'User',
    overall_ux_rating_avg : 'UX Score',
    swap_page_faults : 'Hard Page Faults',
    date_count : 'Date Count'
};
