(function (library) {
    // Calls the second IIFE and locally passes in the global jQuery, window, and document objects
    library(window, document, window.jQuery);
}
// Locally scoped parameters 
(function (window, document, $) {
//VARIABLES
//FUNCTIONS
var importViews = function() { // Get all Views
    return $.ajax({
        type: 'POST',
        beforeSend: function()
        {
            $('#loadingmsg').html('<i class="fa fa-spinner fa-spin"></i> Importing Views ...');
            $('#loadingmsg').fadeIn();
        },
        success: function(data)
        {
            $('#loadingmsg').fadeOut();
        },
        processData: false,
        crossDomain: true,
        cache: false,
        //data: {json: '{"inspector":"113","limit":"0"}', ssid: dashexpert_api.ssid},
        data: 'ssid=' + dashexpert_api.ssid + '&json={"inspector":"113","limit":"0"}', // inspector 113 = Views
        dataType: 'text',
        url: dashexpert_api.settings.apiurl
        //url: dashexpert_api.settings.apiurl + '?ssid=' + dashexpert_api.ssid + '&json={"inspector":"113","limit":"0"}'
    }).done(function(data, textStatus, jqXHR){
            var result;
            dashexpert_api.data.dsimport = {};
            dashexpert_api.data.tblimport = {};
            result = dashexpert_api.util.fixJSON(data);
            result = JSON.parse(result);
            console.log(result);
            dashexpert_api.util.debugOut('Views',result);
            for(var i=0;i<result.table.length; i++) {
                dashexpert_api.data.views[i] = result.table[i];
                if(importFilter(result.table[i])) {
                    dashexpert_api.data.dsimport['data-view-' + result.table[i].view_id] = viewToDatasource(result.table[i]);
                }
            }
            importTables();
            //console.log(dashexpert_api.data.dsimport);
        }).fail(function(jqXHR,textStatus,errorThrown){
            // alert(textStatus + ' | ' + errorThrown);
        });
};
var importTables = function() { // Get all Views
    return $.ajax({
        type: 'POST',
        beforeSend: function()
        {
            $('#loadingmsg').html('<i class="fa fa-spinner fa-spin"></i> Importing Tables ...');
            $('#loadingmsg').fadeIn();
        },
        success: function(data)
        {
            $('#loadingmsg').fadeOut();
        },
        processData: false,
        crossDomain: true,
        cache: false,
        //data: {json: '{"inspector":"113","limit":"0"}', ssid: dashexpert_api.ssid},
        data: 'ssid=' + dashexpert_api.ssid + '&json={"inspector":"116","limit":"0"}', // inspector 116 = Tables
        dataType: 'text',
        url: dashexpert_api.settings.apiurl
        //url: dashexpert_api.settings.apiurl + '?ssid=' + dashexpert_api.ssid + '&json={"inspector":"116","limit":"0"}'
    }).done(function(data, textStatus, jqXHR){
            result = dashexpert_api.util.fixJSON(data);
            result = JSON.parse(result);
            dashexpert_api.util.debugOut('Tables',result);
            var tmpcolumns;
            for(var i=0;i<result.table.length; i++) {
                if(result.table[i].display_columns !== '' && parseInt(result.table[i].enabled) && parseInt(result.table[i].system_fp)) {
                    tmpcolumns = result.table[i].display_columns.split('::');
                    tmpcolumns = tmpcolumns.filter(function(item) {
                        return item.indexOf('spacer_') !== 0;
                    });
                }
                dashexpert_api.data.tblimport[result.table[i].id] = tmpcolumns.toString();
            }
            $.each(dashexpert_api.data.dsimport, function(key) {
                //console.log(dashexpert_api.data.dsimport[key].table_id);
                if(dashexpert_api.data.dsimport[key].table_id !== '' && dashexpert_api.data.dsimport[key].table_id in dashexpert_api.data.tblimport) {
                    dashexpert_api.data.dsimport[key].apistring.columns = dashexpert_api.data.tblimport[dashexpert_api.data.dsimport[key].table_id];
                }
            });
            //CLEANUP AFTER IMPORT
            delete dashexpert_api.data.tblimport;
            dashexpert_api.data.views = {};
            alert('import complete');
            generateFile(JSON.stringify(dashexpert_api.data.dsimport, undefined, 4));
            console.log(dashexpert_api.data.dsimport);
        }).fail(function(jqXHR,textStatus,errorThrown){
            // alert(textStatus + ' | ' + errorThrown);
        });
};
var deleteDatasources = function() {
    var views = amplify.store('datasources');
    $.each(views, function(key) {
        if(key.startsWith('data-view')) {
            console.log('deleting ' + key);
            dashexpert_api.fn.datasources.deleteDatasource(key);
        }
    });
};
var deleteWidgets = function(type) {
    if(type) {
        var widgets = amplify.store('widgets');
        $.each(widgets, function(key) {
            if(key.startsWith(type)) {
                console.log('deleting ' + key);
                dashexpert_api.fn.widgets.deleteWidget(key);
            }
        });
    }
};
var importBlacklist = ['Development|Text|','Date|','Resolution|','Add Basis|','Change Basis|','Custom ','----','UX|Search','Column','Header','Single Trace'];

var importFilter = function(view) { // returns true if target for import
    var importview = true;
    $.each(importBlacklist, function(i,v) {
        if(view.name.startsWith(v)) {
            importview = false;
        }
    });
    if(importview) {
        if(view.w_dash_date !== '' && view.w_dash_date !== '1') {
            importview = false;
        }
    }
    if(view.enabled !== '1') {
        importview = false;
    }
    return importview;
};
var upgradeData = function(options,callback) {
    var opt = {
        dashboards : true,
        widgets : true,
        datasources : true
    };
    if(options === 'dashboards') {
        opt.widgets = false;
        opt.datasources = false;
    }
    if(options === 'datasources') {
        opt.widgets = false;
        opt.dashboards = false;
    }
    if(options === 'widgets') {
        opt.dashboards = false;
        opt.datasources = false;
    }
    dashexpert_api.settings.ignore_lastupdate = true;
    if(opt.widgets) {
        dashexpert_api.fn.widgets.getAllWidgets(function() {
            var widgets = amplify.store('widgets');
            $.each(widgets, function(key) {
                //delete widgets[key].groups;
                //delete widgets[key].owner;
                dashexpert_api.fn.widgets.saveWidget(widgets[key],key,true);
                dashexpert_api.util.debugOut(widgets[key].title + ' Widget Upgraded.');
            });
        });
    }
    if(opt.datasources) {
        dashexpert_api.fn.datasources.getAllDatasources(function() {
            var ds = amplify.store('datasources');
            $.each(ds, function(key) {
                //delete ds[key].groups;
                //delete ds[key].owner;
                dashexpert_api.fn.datasources.saveDatasource(ds[key],key,true);
                dashexpert_api.util.debugOut(ds[key].title + ' Datasource Upgraded.');
            });
        });
    }
    if(opt.dashboards) {
        dashexpert_api.fn.dashboards.getAllDashboards(function() {
            var db = amplify.store('dashboards');
            $.each(db, function(key) {
                //delete db[key].groups;
                //delete db[key].owner;
                db[key].header.groups = db[key].groups;
                dashexpert_api.fn.dashboards.saveDash(db[key],key,true);
                dashexpert_api.util.debugOut(db[key].name + ' Dashboard Upgraded.');
            });
        });
    }
};
var importWidgets = function(widgets,options,callback) {
    dashexpert_api.data.imported.widgets = {success: {},updated: {},fail: {},completed: false};
    dashexpert_api.fn.widgets.getAllWidgets(function() {
        var existingWidgets = amplify.store('widgets');
        $.each(widgets, function(key) {
            if(existingWidgets.hasOwnProperty(key)) {
                if(options.update === true) {
                    dashexpert_api.data.imported.widgets.updated[key] = existingWidgets[key].title;
                    dashexpert_api.fn.widgets.saveWidget(widgets[key],key,true);
                } else {
                    dashexpert_api.data.imported.widgets.fail[key] = existingWidgets[key].title;
                    dashexpert_api.util.debugOut(existingWidgets[key].title + ' Widget Exists - skipping.');
                }
            } else {
                dashexpert_api.data.imported.widgets.success[key] = widgets[key].title;
                widgets[key] = removeGroupPermissions(widgets[key]);
                dashexpert_api.fn.widgets.saveWidget(widgets[key],key);
            }
        });
        dashexpert_api.util.debugOut(dashexpert_api.data.imported.widgets);
        dashexpert_api.data.imported.widgets.completed = true;
    });
    var importW = setInterval(function() {
        if(dashexpert_api.data.imported.widgets.completed) {
            clearInterval(importW);
            if(callback && typeof callback === 'function') {
              callback();
            }
        }
    },1000);
};
var importDatasources = function(ds,options,callback) {
    dashexpert_api.data.imported.datasources = {success: {},updated: {},fail: {},completed: false};
    dashexpert_api.fn.datasources.getAllDatasources(function(callback) {
        var existingDS = amplify.store('datasources');
        $.each(ds, function(key) {
            if(existingDS.hasOwnProperty(key)) {
                if(options.update === true) {
                    dashexpert_api.data.imported.datasources.updated[key] = existingDS[key].title;
                    dashexpert_api.fn.datasources.saveDatasource(ds[key],key,true);
                } else {
                    dashexpert_api.data.imported.datasources.fail[key] = existingDS[key].title;
                    dashexpert_api.util.debugOut(existingDS[key].title + ' Datasource Exists - skipping.');
                }
            } else {
                dashexpert_api.data.imported.datasources.success[key] = ds[key].title;
                ds[key] = removeGroupPermissions(ds[key]);
                dashexpert_api.fn.datasources.saveDatasource(ds[key],key);
            }
        });
        dashexpert_api.util.debugOut(dashexpert_api.data.imported.datasources);
        dashexpert_api.data.imported.datasources.completed = true;
    });
    var importDS = setInterval(function() {
        if(dashexpert_api.data.imported.datasources.completed) {
            clearInterval(importDS);
            if(callback && typeof callback === 'function') {
              callback();
            }
        }
    },1000);
};
var importDashboards = function(db,options,callback) {
    dashexpert_api.data.imported.dashboards = {success: {},updated: {},fail: {},completed: false};
    dashexpert_api.fn.dashboards.getAllDashboards(function(callback) {
        var existingDB = amplify.store('dashboards');
        $.each(db, function(key) {
            if(existingDB.hasOwnProperty(key)) {
                if(options.update === true) {
                    dashexpert_api.data.imported.dashboards.updated[key] = existingDB[key].name;
                    dashexpert_api.fn.dashboards.saveDash(db[key],key,true);
                } else {
                    dashexpert_api.data.imported.dashboards.fail[key] = existingDB[key].name;
                    dashexpert_api.util.debugOut(existingDB[key].name + ' Dashboard Exists - skipping.');
                }
            } else {
                dashexpert_api.data.imported.dashboards.success[key] = db[key].name;
                db[key] = removeGroupPermissions(db[key]);
                db[key] = updateVids(db[key]);
                dashexpert_api.fn.dashboards.saveDash(db[key],key);
            }
        });
        dashexpert_api.util.debugOut(dashexpert_api.data.imported.dashboards);
        dashexpert_api.data.imported.dashboards.completed = true;
    });
    var importDB = setInterval(function() {
        if(dashexpert_api.data.imported.dashboards.completed) {
            clearInterval(importDB);
            if(callback && typeof callback === 'function') {
              callback();
            }
        }
    },1000);
};
var removeGroupPermissions = function(data) {
    if(data.groups) {
        delete data.groups;
    }
    if(data.owner) {
        delete data.owner;
    }
    return data;
};
var updateVids = function(data) {
    if(data.grid) {
        var nvid = new Date().getTime();
        $.each(data.grid,function(i,v) {
            data.grid[i].vid = nvid;
            nvid++;
        });
    }
    return data;
};
var viewToDatasource = function(view) { // view : object
    var d = {};
    d.importid = view.view_id;
    d.title = view.name.replace('Development|Widget|','');
    d.description = view.w_desc;
    d.group = 'imported';
    d.apistring = viewToAPIString(view);
    d.table_id = view.w_table;
    return d;
};
var importFile = function(opt) {
    var JsonObj = null;
    //dashexpert_api.fn.dashboards.getAllDashboards();
    //dashexpert_api.fn.widgets.getAllWidgets();
    //dashexpert_api.fn.datasources.getAllDatasources();
    dashexpert_ui.util.addModal('import-modal');
    $('#import-modal .modal-body').empty();
    $('#import-modal .modal-title').html('Import Dashboard File');
    var html = '<div class="form-group">';
    html += '<label for="dashboard-import-select"">Dashboard Import File</label>';
    html += '<input type="file" id="dashboard-import-select" accept="application/json">';
    html += '<p class="help-block">Dashboard file should be in JSON format created from a dashboard export.</p>';
    html += '</div>';
    html += '<pre class="pre-scrollable"></pre>';
    html += '<button class="btn btn-primary">Import Dashboard</button>';
    $('#import-modal .modal-body').html(html);
    $('#import-modal').modal('show');
    var importData = {};
    function handleFileSelect(evt) {
      var files = evt.target.files; // FileList object
      var f = files[0];
      var reader = new FileReader();
      // Closure to capture the file information.
      reader.onload = (function(theFile) {
        return function(e) {
           // Render thumbnail.
           JsonObj = e.target.result;
           importData = JSON.parse(JsonObj);
           $('#import-modal pre').html(JSON.stringify(importData, undefined, 4));
        };
      })(f);
      // Read in the image file as a data URL.
      reader.readAsText(f);
    }
    document.getElementById('dashboard-import-select').addEventListener('change', handleFileSelect, false);
    $('#import-modal button').on('click', function(e) {
        dashexpert_api.settings.debug = true;
        dashexpert_api.data.imported = {};
        var options = {};
        if(!$.isEmptyObject(opt)) {
            options = opt;
        }
        if(!$.isEmptyObject(importData)) {
            $('#import-modal .modal-body').empty();
            if(!$.isEmptyObject(importData.widgets)) {        
                importWidgets(importData.widgets,options,function() {
                    $('#import-modal .modal-body').append('<ul class="list-unstyled" id="widgetimports">');
                    $.each(dashexpert_api.data.imported.widgets.success,function(key) {
                        $('#import-modal .modal-body').append('<li class="bg-success">' + dashexpert_api.data.imported.widgets.success[key] + ' Widget Created.</li>');
                    });
                    $.each(dashexpert_api.data.imported.widgets.updated,function(key) {
                        $('#import-modal .modal-body').append('<li class="bg-success">' + dashexpert_api.data.imported.widgets.updated[key] + ' Widget Updated.</li>');
                    });
                    $.each(dashexpert_api.data.imported.widgets.fail,function(key) {
                        $('#import-modal .modal-body').append('<li class="bg-warning">' + dashexpert_api.data.imported.widgets.fail[key] + ' Widget already exists - import skipped.</li>');
                    });
                    $('#import-modal .modal-body').append('</ul>');
                });
            }
            if(!$.isEmptyObject(importData.datasources)) {
                importDatasources(importData.datasources,options,function() {
                    $('#import-modal .modal-body').append('<ul class="list-unstyled" id="dsimports">');
                    $.each(dashexpert_api.data.imported.datasources.success,function(key) {
                        $('#import-modal .modal-body').append('<li class="bg-success">' + dashexpert_api.data.imported.datasources.success[key] + ' Datasource Created.</li>');
                    });
                    $.each(dashexpert_api.data.imported.datasources.updated,function(key) {
                        $('#import-modal .modal-body').append('<li class="bg-success">' + dashexpert_api.data.imported.datasources.updated[key] + ' Datasource Updated.</li>');
                    });
                    $.each(dashexpert_api.data.imported.datasources.fail,function(key) {
                        $('#import-modal .modal-body').append('<li class="bg-warning">' + dashexpert_api.data.imported.datasources.fail[key] + ' Datasource already exists - import skipped.</li>');
                    });
                    $('#import-modal .modal-body').append('</ul>');
                });
            }
            if(!$.isEmptyObject(importData.dashboards)) {
                importDashboards(importData.dashboards,options,function() {
                    $('#import-modal .modal-body').append('<ul class="list-unstyled" id="dashimports">');
                    $.each(dashexpert_api.data.imported.dashboards.success,function(key) {
                        $('#import-modal .modal-body').append('<li class="bg-success">' + dashexpert_api.data.imported.dashboards.success[key] + ' Dashboard Created.</li>');
                    });
                    $.each(dashexpert_api.data.imported.dashboards.updated,function(key) {
                        $('#import-modal .modal-body').append('<li class="bg-success">' + dashexpert_api.data.imported.dashboards.updated[key] + ' Dashboard Updated.</li>');
                    });
                    $.each(dashexpert_api.data.imported.dashboards.fail,function(key) {
                        $('#import-modal .modal-body').append('<li class="bg-warning">' + dashexpert_api.data.imported.dashboards.fail[key] + ' Dashboard already exists - import skipped.</li>');
                    });
                    $('#import-modal .modal-body').append('</ul>');
                });
            }
        } else {
            importData = {};
            dashexpert_ui.util.createAlert('No file selected for import.','warning','import-alert','#import-modal .modal-body');
        }
        //$('#import-modal').modal('hide');
    });
};
var viewToAPIString = function(view) {
    var APIObj = {};
    APIObj.inspector = queryidToInspectorid(view.query);
    if(view.w_basis.startsWith(',')) {
        view.w_basis = view.w_basis.slice(1);
    } 

    if(view.w_basis && view.w_basis !== 'date') {
        APIObj.basis = view.w_basis;
    } else {
        APIObj.basis = queryInspectoridtoBasis(APIObj.inspector);
    }

    if(view.w_dash_date === '1') {
        var tmp = APIObj.basis.split(',');
        tmp.splice(0,1);
        if(tmp) {
            APIObj.unbasis = tmp.toString();
        }
    }
    var sort = view.w_order.split(' ');
    APIObj.sort_col = sort[0];
    if(sort[1] === 'desc') {
        APIObj.sort_order = '2';
    }
    if(view.w_limit) {
        APIObj.limit = view.w_limit;
    } else {
        APIObj.limit = '100';
    }

    APIObj.date = 'today';
    APIObj.rating = '2';
    APIObj.resolution = 'All';

    return APIObj;
};
var queryidToInspectorid = function(qid) {
    switch(qid) {
        case '92':
                return '0';
        case '82': 
            return '1';
        case '99':
            return '2';
        case '87':
            return '3';
        case '86':
            return '4';
        case '96':
            return '5'; // could also be 6
        case '103':
            return '7';
        case '108':
            return '8';
        case '115':
            return '9';
        case '119':
            return '10';
        case '120':
            return '11';
        default:
            break;
    }
};
var queryInspectoridtoBasis = function(inspector) {
    switch(inspector) {
        case '0':
            return 'user_name,machines';
        case '1': 
            return 'user_name,machines';
        case '2':
            return 'user_name,machines';
        case '3':
            return 'hostname';
        case '4':
            return 'machines';
        case '5':
            return 'folder_name,user_name,machines'; // could also be 6
        case '7':
            return 'dest_ip,dest_port';
        case '8':
            return 'condition,users,machines';
        case '9':
            return 'domain,users,machines';
        case '10':
            return 'users,machines';
        case '11':
            return 'machines';
        default:
            break;
    }
};
var importCurrentViews = function() {
    $.each(dashexpert_api.data.dsimport, function(key) {
        dashexpert_api.fn.datasources.saveDatasource(dashexpert_api.data.dsimport[key],key);
    });
    $('#importOptions').html('Import completed.');
    dashexpert_api.fn.datasources.getAllDatasources();
};
var generateFile = function(json) {
    var jsonFile = null,
      makeTextFile = function (content) {
        var data = new Blob([content], {type: 'application/json'});
        // If we are replacing a previously generated file we need to
        // manually revoke the object URL to avoid memory leaks.
        if (jsonFile !== null) {
          window.URL.revokeObjectURL(jsonFile);
        }
        jsonFile = window.URL.createObjectURL(data);
        return jsonFile;
      };
      $('body').append('<div id="importOptions" class="well"><a class="btn btn-success" href="#" id="downloadJSON">Download Datasource Import</a> <a class="btn btn-primary" href="#" id="importJSON">Import Views into Datasources</a></div>');
      $('#downloadJSON').attr('href', makeTextFile(json));
      $('#downloadJSON').attr('download', 'datasources.json');
      $('#importJSON').on('click', function(e) {
        e.preventDefault();
        importCurrentViews();
      });
};
var setSystemStatus = function(items,type,system) {
    $.each(items, function(k) {
        items[k].system = system;
        dashexpert_api.crud.update(items[k],k,type);
        console.log(items[k]);
    });
};
// ON DOCUMENT READY
$(document).ready(function() {
   
});
// EXPOSE PUBLIC FUNCTIONS
dashexpert_api.fn.import = {
    importViews : importViews,
    updateVids : updateVids,
    upgradeData : upgradeData,
    deleteDatasources : deleteDatasources,
    deleteWidgets : deleteWidgets,
    importWidgets : importWidgets,
    importDatasources : importDatasources,
    importDashboards : importDashboards,
    importFile : importFile,
    setSystemStatus : setSystemStatus
};
// END Library code
}));