var dashexpert_ui = dashexpert_ui || {};
var dashexpert_api = dashexpert_api || {};
(function (library) {
    // Calls the second IIFE and locally passes in the global jQuery, window, and document objects
    library(window, document, window.jQuery);
}
// Locally scoped parameters 
(function (window, document, $) {
// ON DOCUMENT READY
    $(document).ready(function() {
        initUI();
        getBasisList(function() {
          initApp(function() {
            finalizeApp(function() {
              $('#loading_dashboards').remove();
              showAdmin();
            });
          });
        });
    });
    //UTILITIES
    //FIXES FOR IE 
    if (!String.prototype.endsWith)
    String.prototype.endsWith = function(searchStr, Position) {
        // This works much better than >= because
        // it compensates for NaN:
        if (!(Position < this.length))
          Position = this.length;
        else
          Position |= 0; // round position
        return this.substr(Position - searchStr.length,
                           searchStr.length) === searchStr;
    };
    if (!String.prototype.startsWith) {
    String.prototype.startsWith = function(searchString, position){
          return this.substr(position || 0, searchString.length) === searchString;
      };
    }
    function parseJwt(token) {/// 
        var base64Url = token.split('.')[1];
        var base64 = base64Url.replace('-', '+').replace('_', '/');
        return JSON.parse(window.atob(base64));
    }
    function getAPICookie(name) {
        var result = $.cookie(name);
        return result;
    }
    var debugOut = function(msg,options) {
        options = options || { type: 'log'};
        if(dashexpert_api.settings.debug) {
          switch(options.type) {
            case 'table':
              if(options.columns) {
                console.table(msg,options.columns);
              } else {
                console.table(msg);
              }
              break;
            case 'warn':
              console.warn(msg);
              break;
            case 'error':
              console.error(msg);
              break;
            case 'log':
              console.log(msg);
              break;
            default: 
              console.log(msg);
              break;
          }
        }
    };
    // function sleep(ms) {
    //   return new Promise(resolve => setTimeout(resolve, ms));
    // }
    var checkValidJSON = function(string) {
        var options = {};
        try {
            JSON.parse(string);
        } catch (e) {
            //alert('Invalid JSON. \n' + e)
            // SET ERROR MESSAGE
            if(string.indexOf('License Not Authorized') != -1) {
                dashexpert_ui.util.createAlert('License Error. Please check your Stratusphere License under Administration > Licensing.','danger','previewerror');
            }
            else {
                if(string.indexOf('Not Authorized') != -1) {
                    dashexpert_ui.util.createAlert('Not Authorized. API access not allowed from the client IP Address. Please check your allowed API Client IPs under Administration > Configuration > Other Settings.','danger','previewerror');
                } else {
                  if(options.errors) {
                    options.errors += ' <strong>Invalid JSON.</strong><br/><p>' + e + '</p>';
                    dashexpert_ui.util.createAlert(options.errors,'warning','alert_JSON_check');
                  }
                }
            }

            return false;
        }
        return true;
    };
    var fixJSON = function(string) {
        var s = '{' + string.substring(string.indexOf("{") + 1);
        if(checkValidJSON(s)) {
            return s;
        }
        else {
            return false;
        }
    };
    amplify.clearStore = function(mode) {
      var mode = mode || 'all';
      var adata = amplify.store();
      if(mode === 'all') {
        $.each(adata, function (storeKey) {
            // Delete the current key from Amplify storage
            if(storeKey !== 'preferences') {
              amplify.store(storeKey, null);
            }
        });
      }
      if(mode === 'data') {
        $.each(adata, function (k,v) {
            if(k.startsWith('map_') || k.startsWith('eyJpbn') || k.startsWith('eyJ')) {
              amplify.store(k, null);
            }
        });
      }
      if(mode === 'map') {
        $.each(adata, function (k,v) {
            if(k.startsWith('map_')) {
              amplify.store(k, null);
            }
        });
      }
      if(mode === 'preferences') {
        amplify.store('preferences', null);
      }
    };
    var createAlertLegacy = function(msg,type,id,target,autohide) { // type options: success|info|warning|danger
      target = target || '#navigation-main';
      if(id) {
        $('#' + id).remove();
      }
      var idtxt = (id) ? 'id="' + id + '" ' : '';
      (type) ? type : 'info';
      $(target).prepend('<div ' + idtxt + 'class="alert alert-' + type + ' alert-dismissable">\n\t<button type"button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>\n\t<strong>' + msg + '</strong>\n</div>');
      if(type != 'danger' && !autohide) {
        $('#' + id).delay(4000).slideUp(200, function() {
          $(this).remove();
        });
      }
    };
    var createAlertNew = function(msg,options) { // type options: success|info|warning|danger|popup
      var defaults = {type: 'info', id: '', target: '#alerts', autohide: true};
      $.each(defaults, function(k){
        if(!options.hasOwnProperty(k)) {
          options[k] = defaults[k];
        }
      });
      if(options.id) {
        $('#' + options.id).remove();
      }
      var idtxt = (options.id) ? 'id="' + options.id + '" ' : '';
      $(options.target).prepend('<div ' + idtxt + 'class="alert alert-' + options.type + ' alert-dismissable">\n\t<button type"button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>\n\t<strong>' + msg + '</strong>\n</div>');
      if(options.type != 'danger' && !options.autohide) {
        $('#' + options.id).delay(4000).slideUp(200, function() {
          $(this).remove();
        });
      }
    };
    var checkLogin = function() { 
      dashexpert_ui.util.checkSession();
    };
    var toggleLogin = function(loggedin) { // true | false
      if(loggedin) {
        $('.navbar-form button[role="login"]').hide();
        $('.navbar-form button[role="logout"]').show();
      } else {
        localStorage.removeItem('dashSession');
        $('head link[rel="stylesheet"]').last().after('<style type="text/css">[data-acl="admin"] { display: none; }</style>');
        $('p.navbar-text').hide();
        $('.navbar-form .form-group').show();
        $('.navbar-form button[role="login"]').show();
        $('.navbar-form button[role="logout"]').hide();
        dashexpert_ui.util.createAlert('You have been logged out successfully.','success','login-alert');
      }
    };
    var keepSessionAlive = function(callback) {
      var success = false;
      if (typeof parent.onUpdatePage == 'function') {
        try { parent.onUpdatePage();
          success = true;
          dashexpert_api.util.debugOut('session updated (parent1)');
          if(callback && typeof callback === 'function') {
            callback();
          }
        } catch(e){} 
      }
      if (typeof parent.parent.onUpdatePage == 'function' && !success) {
        try { parent.parent.onUpdatePage();
          success = true;
          dashexpert_api.util.debugOut('session updated (parent2)');
        } catch(e){}
      }
      if (typeof parent.parent.parent.onUpdatePage == 'function' && !success) {
        try { parent.parent.parent.onUpdatePage();
          success = true;
          dashexpert_api.util.debugOut('session updated (parent3)');
        } catch(e){}
      }
      if (typeof parent.parent.parent.parent.onUpdatePage == 'function' && !success) {
          try { parent.parent.parent.parent.onUpdatePage();
          success = true;
          dashexpert_api.util.debugOut('session updated (parent4)');
        } catch(e){}
      }
      if(callback && typeof callback === 'function') {
        callback(success);
      }
    };
    var deleteTmpWidgets = function() {
      var widgets = amplify.store('widgets');
      $.each(widgets, function(k){
        if(k.match(/-tmp$/)) {
          delete widgets[k];
        }
      });
      amplify.store('widgets',widgets);
    };
    // ADMIN FUNCTIONS
    var buildFormElement = function(id,title,type,options) {
      options.group = options.group || '';
      options.acl = options.acl || 'user';
      var html = '<div class="form-group" data-acl="' + options.acl + '">\n';
      var required = '';
      if(options.errorcheck) {
        $.each(options.errorcheck, function(i,v) {
          if(options.errorcheck[i][0] === 'required') {
            required = '<span class="text-danger">* </span>';
          }
        });
      }
      if(type !== 'checkbox' && type !== 'hidden' && type !== 'button') {
        html += '\t<label for="in-' + id + '">' + required + title + '</label>\n';
      }
      switch(type) {
        case 'label':
          html += '\t<input class="form-control" type="text" id="in-' + id + '" value="' + options.default + '" data-group="' + options.group + '" data-acl="' + options.acl + '"/>\n';
          break;
        case 'button':
          html += '\t<button id="in-' + id + '" class="btn btn-' + options.btnclass + '">' + title + '</button>';
          break;
        case 'text':
          html += '\t<input class="form-control" type="text" id="in-' + id + '" value="' + options.default + '" data-group="' + options.group + '" data-acl="' + options.acl + '"/>\n';
          break;
        case 'textarea':
          html += '\t<textarea class="form-control" id="in-' + id + '" data-group="' + options.group + '" data-acl="' + options.acl + '">' + options.default + '</textarea>\n';
          break;
        case 'html':
          html += '\t<div class="html-editor" id="' + id + '-editor" data-group="' + options.group + '" data-acl="' + options.acl + '"></div>\n';
          html += '\t<input class="form-control" type="hidden" id="in-' + id + '" data-group="' + options.group + '" data-quill="' + id + '-editor" value="' + options.default + '" data-acl="' + options.acl + '"/>\n';
          break;
        case 'checkbox':
          var checked = '';
          if(options.default) {
            checked = ' checked="checked"';
          }
          html += '<div class="checkbox">\n\t<label>\n\t<input type="checkbox" id="in-' + id + '" data-group="' + options.group + '" data-acl="' + options.acl + '" ' + checked + ' />' + title + '</label>\n</div>\n';
          break;
        case 'hidden':
          html += '\t<input class="form-control" type="hidden" id="in-' + id + '" value="' + options.default + '"/>\n';
          break;
        case 'color':
          html += '\t<div class="input-group colorpick1">\n';
          html += '\t\t<input class="form-control" type="text" id="in-' + id + '" value="' + options.default + '" data-group="' + options.group + '" data-acl="' + options.acl + '"/>\n';
          html += '\t\t<span class="input-group-addon"><i></i></span>\n';
          html += '\t</div>';
          break;
        case 'select':
          html += '\t<select class="form-control" id="in-' + id + '" data-group="' + options.group + '" data-acl="' + options.acl + '">';
          html += '\t\t<option value="-1">Select an option</option>';
          if(options.options) {
            var selected;
            $.each(options.options, function(i) {
            if(options.options[i][1] === options.default + '') {
              selected = 'selected="selected"';
            } else { selected = '';}
            html += '\t\t<option value="' + options.options[i][1] + '" ' + selected + '>' + options.options[i][0] + '</option>';
            });
          }
          html += '\t</select> ';
          break;
        case 'multiselect':
          html += '\t<select class="form-control" multiple="multiple" id="in-' + id + '" name="in-' + id + '[]" data-group="' + options.group + '" data-acl="' + options.acl + '">';
          if(options.options) {
            var selected;
            $.each(options.options, function(i) {
            if(options.options[i][1] === options.default) {
              selected = 'selected="selected"';
            } else { selected = '';}
            html += '\t\t<option value="' + options.options[i][1] + '" ' + selected + '>' + options.options[i][0] + '</option>';
            });
          }
          html += '\t</select>';
          break;
        case 'radio':
          var checked;
          html += '\t<div class="radio">';
          $.each(options.options, function(i) {
            if(options.options[i][1] === options.default) {
              checked = 'checked';
            } else { checked = '';}
            html += '\n\t<label class="radio-inline"><input type="radio" name="in-' + id + '" id="in-' + id + i + '" value="' + options.options[i][1] + '" ' + checked + ' data-group="' + options.group + '" data-acl="' + options.acl + '">' + options.options[i][0] + '</label>';
          });
          html += '\t</div>';
          break;
      }
      if(options.hint) {
        html += '<p class="help-block">' + options.hint + '</p>\n';
      }
      html += '</div>';
      return html;
    };
    var errorCheck = function(data,type) { // type: widget|view|datasource
      var errors = {};
      var passed = true;
      var updateError = function(x,y,z) {
        errors[z] = y;
        passed = x;
      };
      var checkValid = function(field,value,check) {
        var x = true;
        var y = '';
        var z = '';
        if(typeof value === 'string') {
          value = value.trim();
        }
        if(check[0] === 'required' && $.isEmptyObject(value)) {
          x = false;
          y = check[1];
          z = field;
          updateError(x,y,z);
        }
        if(check[0] === 'number' && value !== '') {
          if(!$.isNumeric(parseInt(value))) {
            x = false;
            y = check[1];
            z = field;
            updateError(x,y,z);
          }
        }
        var numcheck = check[0].split('|');
        if(numcheck[0] === 'less-than' && value !== '') {
          if(parseInt(value) > parseInt(numcheck[1])) {
            x = false;
            y = check[1];
            z = field;
            updateError(x,y,z);
          }
        }
        if(numcheck[0] === 'greater-than' && value !== '') {
          if(parseInt(value) <= parseInt(numcheck[1])) {
            x = false;
            y = check[1];
            z = field;
            updateError(x,y,z);
          }
        }
        if(check[0] === 'json' && value !== '') {
          if(typeof value === 'object') {
            value = JSON.stringify(value);
          }
          try {
            JSON.parse(value);
          }
          catch(e) {
            x = false;
            y = check[1];
            z = field;
            updateError(x,y,z);
          }
        }
        if(check[0] === 'api' && value !== '') {
          try {
            var testval = {};
            if(typeof value === 'object') {
              testval = value;
            } else {
              testval = JSON.parse(value);
            }
            if(testval.sort_col === '' || testval.sort_col === undefined || testval.inspector === '' || testval.inspector === undefined || testval.basis === '' || testval.basis === undefined) {
              x = false;
              y = check[1];
              z = field;
              updateError(x,y,z);
            }
          }
          catch(e) {}
        }
        if(check[0] === 'widgets') {
          $.each(dashexpert_api.widgets.default, function(key) {
            $.each(dashexpert_api.widgets[key], function(i,val) {
              if(!val) {
                x = false;
                y = check[1];
                z = field;
                updateError(x,y,z);
              }
            });
          });
        }
      };
      //end checkValid
      var alertTarget = '#alerts';
      if(type === 'widget') {
        alertTarget = '#widget-alerts';
        $(alertTarget).empty();
        var defaultSource = $.extend(true, {}, dashexpert_api.widgets.default); 
        if(data.type === 'info' || data.type === 'html' || data.type === 'multitable' || data.options === 'simple') {
          defaultSource = $.extend(true, {}, dashexpert_api.widgets.info_default);
        }
        // REMOVE BLACKLIST
        var blist = dashexpert_api.widget_preferences[data.type].blacklist || [];
        $.each(blist, function(i) {
          delete defaultSource[blist[i]];
        });
        $.each(defaultSource, function(key,val) {
          if(val[2].errorcheck) {
            $.each(val[2].errorcheck, function(i,val) {
              checkValid(key,data[key],val);
            });
          }
        });
        if(data.type !== 'info') {
          $.each(dashexpert_api.widgets[data.type], function(key,val) {
            if(val[2].errorcheck) {
              $.each(val[2].errorcheck, function(i,val) {
                checkValid(key,data.options[key],val);
              });
            }
          });
        }
      }
      if(type === 'datasource') {
        alertTarget = '#datasource-alerts';
        $(alertTarget).empty();
        $.each(dashexpert_api.datasources.default, function(key,val) {
          if(val[2].errorcheck) {
            $.each(val[2].errorcheck, function(i,val) {
              checkValid(key,data[key],val);
            });
          }
        });
      }
      if(type === 'dashboard') {
        alertTarget = '#dashboard-alerts';
        $(alertTarget).empty();
        $.each(dashexpert_api.dashboards.default, function(key,val) {
          if(val[2].errorcheck) {
            $.each(val[2].errorcheck, function(i,val) {
              checkValid(key,data[key],val);
            });
          }
        });
      }
      if(type === 'preferences') {
        alertTarget = '#preferences-modal .modal-body';
        $.each(dashexpert_api.advanced_preferences, function(k,v) {
          $.each(v.fields, function(key,val) {
            if(val[2].errorcheck) {
              $.each(val[2].errorcheck, function(i,val) {
                checkValid(key,data[key],val);
              });
            }
          });
        });
      }
      $('[id^="save-alert"]').remove();
      if(!passed) {
        $.each(errors, function(key,val) {
          dashexpert_ui.util.createAlert(val,'danger','save-alert' + key,alertTarget,true);
        });
      }
      var msgs = {passed:passed,errors:errors};
      return msgs;
    };
    var createDashboardForm = function(vid) {
      var dashboards = amplify.store('dashboards');
      var dashboard = dashboards[vid];
      if(JSON.parse(dashexpert_api.settings.system)) {
        dashboards[vid].system = true;
      }
      if(JSON.parse(dashboards[vid].system) === true && dashexpert_api.settings.system_readonly === true) {
        dashexpert_ui.util.createAlert('System Dashboards protected.','warning','views-alert');
      } else {
        $('#save-alert').fadeOut('slow');
        var heading = 'Create Dashboard';
        if(vid && dashboard.status !== 'new') {
          dashboard.header.creator = dashboard.header.creator || dashboard.header.owner;
          dashboard.header.created = dashboard.header.created || dashboard.header.lastupdated;
          heading = 'Edit ' + dashboard.name + ' Dashboard | <strong>created by:</strong> ' + dashboard.header.creator + ' ' + new Date(dashboard.header.created).toLocaleDateString("en-US") + ' ' + new Date(dashboard.header.created).toLocaleTimeString("en-US") + ' | <strong>lastupdated by:</strong> ' + dashboard.header.owner + ' ' + new Date(dashboard.header.lastupdated).toLocaleDateString("en-US") + ' ' + new Date(dashboard.header.lastupdated).toLocaleTimeString("en-US");
        }
        var html = '<div class="panel panel-primary">\n\t<div class="panel-heading">' + heading + '</div>\n\t<div class="panel-body">\n\t<div id="dashboard-alerts"></div>\n';
        $.each(dashexpert_api.dashboards.default, function(key,val) {
          var value = clone(val[2]);
          if(vid) {
            if(dashboard[key]) {
              if(key === 'apistring') {
                value.default = JSON.stringify(dashboard[key],undefined,4);
              } else {
                value.default = dashboard[key];
              }
            }          
          }
          html += buildFormElement(key,val[0],val[1],value);
        });
        html += '</div></div>';
        // build html to screen
        $('#save-dashboard-modal .panel-body').empty();
        if(vid) {
          $('#save-dashboard-modal .panel-body').html(html);
          $('#in-id').val(vid);
          if(dashboard.publish === undefined) {
            $('#in-publish').prop('checked', dashexpert_api.dashboards.default.publish.default);
          }
          if(dashboard.system === true) {
            $('#in-publish').prop('disabled','disabled');
          }
          $('#in-display').prop('checked', dashboard.display);
        } else {
          $('#save-dashboard-modal .panel-body').html(html);
        }
        var sortOptions = function(target) {
          target = target || '#in-groups';
          var list = $(target + ' option');
          function sortTabs(a,b) {
            return ($(b).text().toLowerCase() < $(a).text().toLowerCase()) ? 1 : -1;
          }
          list.sort(sortTabs).appendTo(target);
        };
        var buildGroupSelect = function(target,groups,selected) { // select
          var options = '<option value="">Everyone</option>';
          if($.isEmptyObject(selected)) {
            options = '<option value="" selected>Everyone</option>';
          }
          $(target).empty();
          $.each(groups,function(i) {
            var id = groups[i].id.toString();
            if($.inArray(id, selected) !== -1) {
              options += '<option value="' + groups[i].id + '" selected>' + groups[i].name + '</option>';
            }
            else {
              options += '<option value="' + groups[i].id + '">' + groups[i].name + '</option>';
            }
          });
          $(target).html(options);
          sortOptions(target);
          $(target).multiSelect({ keepOrder: false, selectableHeader: 'Eligible Groups', selectionHeader: 'Selected' });
        };
        var userinfo = amplify.store('userinfo');
        var groups = userinfo.groups;
        var dash_user_group = dashboard.header.groups || [];
        if(dashboard.groups !== undefined || dashboard.groups !== "" && $.isArray(dashboard.groups)) {
          dash_user_group = dashboard.groups;
        }
        buildGroupSelect('#in-groups',groups,dash_user_group);
        $('#save-dashboard-modal-widget .panel-primary').before('<div class="text-right"><p><button class="btn btn-default" data-action="cancel-dashboard">Cancel</button> <button class="btn btn-success" data-action="create-dashboard">Save</button></p></div>');
        $('[data-action="create-dashboard"]').on('click', function(e) {
          e.preventDefault();
          var dashboards = amplify.store('dashboards');
          var p = amplify.store('preferences');
          var formvalues = {};
          $('#save-dashboard-modal-widget [id^="in-"]').each(function(){ 
            var value = $(this).val();
            if(this.type === 'checkbox') {
              value = this.checked;
            }
            formvalues[this.id.slice(3)] = value;
          });
          formvalues.system = JSON.parse(formvalues.system);
          var filesuffix,id,overwrite;
          filesuffix = new Date().getTime();
          overwrite = true;
          var addtodash = false;
          var removefromdash = false;
          if(!vid) {
            filesuffix = new Date().getTime();
            id = 'dashboard-' + filesuffix;
            vid = id;
            overwrite = false;
            addtodash = true;
          }
          if(dashboards[formvalues.id].status === 'new') { 
            overwrite = false;
          }
          if(formvalues.display === false) {
            removefromdash = true;
          }
          formvalues.grid = dashexpert_api.settings.currentgrid;
          formvalues.autoload = true; 
          if(dashboards[formvalues.id].hasOwnProperty('header')) {
            formvalues.lastsave = dashboards[formvalues.id].header.lastupdated;
            formvalues.header = dashboards[formvalues.id].header;
            formvalues.header.groups = formvalues.groups;
          } else {
            formvalues.lastsave = filesuffix;
          }
          saveDash(formvalues,vid,overwrite,function(){
            if(!overwrite) {
              p.load_dashboards.push(vid);
              amplify.store('preferences',p);
            }
            if(addtodash) {
              createGSgrid('#view-dashboard',vid);
            }
            if(removefromdash) {
              $('[aria-controls="' + formvalues.id + '"]').parent().remove();
              $('#' + formvalues.id).remove();
            }
            $('[aria-controls="' + formvalues.id + '"]').parent().data('sort',formvalues.sort_order);
            reorderTabs();
            $('[aria-controls="' + formvalues.id + '"]').html(formvalues.name);
            $('#save-dashboard-modal .panel-body').empty();
            $('#save-dashboard-modal').modal('hide');
            $('#dashboard-tabs a[href="#' + vid + '"]').tab('show');
          });
        });
        $('[data-action="cancel-dashboard"], #save-dashboard-modal .close ').on('click', function(e) {
          e.preventDefault();
          var dashes = amplify.store('dashboards');
          var dash = $('#in-id').val();
          $('#save-dashboard-modal .panel-body').empty();
          $('#save-dashboard-modal').modal('hide');
          if(dashboards[dash].status === 'new') {
            $('[aria-controls="' + dash + '"]').parent().remove();
            $('#' + dash).remove();
          }
        });
      }
    };
    var createDatasourceForm = function(vid) {
      var datasources = amplify.store('datasources');
      var datasource = datasources[vid];
      $('#save-alert').fadeOut('slow');
      var heading = 'Datasource Settings';
      if(vid) {
        heading = 'Datasource Settings';
        var widgets = amplify.store('widgets');
        var widget = createTmpWidget('table');
        widget.datasource = vid;
        widget.dcolumn = datasource.apistring.sort_col;
        widget.scolumn = datasource.apistring.sort_col;
        widget.title = datasource.title;
        widget.options = {
          sortable : true,
          showtitle: true,
          condensed: true
        };
        widgets[widget.id] = widget;
        amplify.store('widgets',widgets);
        retrieveData(widget.id,'dspreview',function(vid){
          var mapid = amplify.store('map_' + vid);
          var data = amplify.store(mapid); //get Data from encoded APIString
          dashexpert_api.fn.widgets[widget.type].create(widget,vid);
        });
      }
      var panelID = 'panel_' + new Date().getTime();
      var html = '<div class="panel panel-primary" id="' + panelID + '">\n\t<div class="panel-heading">' + heading + '</div>\n\t<div class="panel-body">\n';
      $.each(dashexpert_api.datasources.default, function(key,val) {
        var value = {};
        value = clone(val[2]);
        if(vid) {
          if(datasource[key]) {
            if(key === 'apistring') {
              value.default = JSON.stringify(datasource[key],undefined,4);
            } else {
              value.default = datasource[key];
            }
          }          
        }
        html += buildFormElement(key,val[0],val[1],value);
      });
      html += '</div></div>';
      // build html to screen
      if(vid) {
        $('#view-datasource-create').empty();
        $('#view-datasource-edit #datasource-container').html(html);
        $('#in-id').val(vid);
      } else {
        $('#view-datasource-edit').empty();
        $('#view-datasource-create #datasource-container').html(html);
      }
      $('#datasource-container textarea[id^="in-api"]').attr('rows', '8');
      $('#btn-create-datasource, #btn-save-datasource').on('click', function(e) {
        var mode = $(this).data('mode');
        e.preventDefault();
        var formvalues = {};
        $('#datasource-container #' + panelID + ' [id^="in-"]').each(function(){ 
          var value = this.value;
          if(this.type === 'checkbox') {
            value = this.checked;
          }
          formvalues[this.id.slice(3)] = value;
        });
        var filesuffix,id;
        var overwrite = true;
        if(!vid || datasource === undefined) {
          filesuffix = new Date().getTime();
          id = 'data-' + filesuffix;
          vid = id;
          overwrite = false;
        } else {
          if(datasource !== undefined) {
            formvalues.lastsave = datasource.header.lastupdated;
          }
        }
        saveDatasource(formvalues,vid,overwrite);
        var pass = errorCheck(formvalues,'datasource');
        if(mode === 'saveclose' && pass.passed) {
          setTimeout(() => { $('#btn-cancel-datasource').trigger('click'); }, 2000);
        }
      });
      $('#btn-cancel-datasource').on('click', function(e) {
        e.preventDefault();
        loadHTML('#view-datasources-browse','view-datasources-browse.html');
      });
    };
    var initAPIBuilder = function() {
      $('.form-group .help-block a').on('click', function(e) {
        e.preventDefault();
        $('#view-api-modal').modal('show');
        $('#view-api-modal #datasource-main-btns').show();
        $('#view-api-modal #datasource-apply-btns').hide();
      });
      $('#apibuilder-grab').on('click', function(e) {
        e.preventDefault();
        var oldAPIString = $('#outer-datasource-container #in-apistring').text();
        var newAPIString = $('#apibuilder').contents().find('#output_JSON').text();
        var APIObject = JSON.parse(newAPIString);
        // ADD required params
        APIObject = checkAPIObject(APIObject);
        newAPIString = JSON.stringify(APIObject,undefined,4);
        buildAPIConfirm(oldAPIString,newAPIString);
      });
      
    };
    var checkAPIObject = function(obj) { // Adds required options to APIString
      var outputAPIobj = obj;
      outputAPIobj.rating = '2';
      return outputAPIobj;
    };
    var buildAPIConfirm = function(oldAPI,newAPI) {
      $('#view-api-modal #apibuilder').hide();
      $('#view-api-modal #datasource-main-btns').hide();
      $('#view-api-modal #datasource-apply-btns').show();
      var html = '<div class="row" id="APIConfirm">';
      html += '\n\t<div class="col-md-6">Replace:<pre>' + oldAPI + '</pre></div>';
      html += '\n\t<div class="col-md-6">With:<pre>' + newAPI + '</pre></div>';
      html += '</div>';
      $(html).appendTo('#view-api-modal .modal-body');
      $('#cancelAPI').on('click', function() {
        $('#view-api-modal #apibuilder').show();
        $('#view-api-modal #datasource-main-btns').show();
        $('#view-api-modal #datasource-apply-btns').hide();
        $('#view-api-modal #APIConfirm').remove();
      });
      $('#applyAPI').on('click', function() {
        $('#view-api-modal #apibuilder').show();
        $('#view-api-modal #APIConfirm').remove();
        $('#view-api-modal #datasource-main-btns').show();
        $('#view-api-modal #datasource-apply-btns').hide();
        $('#view-api-modal').modal('hide');
        $('#outer-datasource-container #in-apistring').text(newAPI);
      });
    };
    var createTmpWidget = function(type,dtype) {
      var widgets = amplify.store('widgets');
      var widget = {};
      dtype = dtype || 'advanced';
      var defaults = $.extend(true, {}, dashexpert_api.widgets.default);
      if(type === 'multitable' || type === 'info' || dtype === 'simple') {
        defaults = dashexpert_api.widgets.info_default;
      }
      $.each(defaults, function(key,val) {
        var value = $.extend(true,{},val[2]);
        widget[key] = value.default;
      });
      $.each(dashexpert_api.widgets[type], function(key,val) {
        var value = $.extend(true,{},val[2]);
        widget.options = widget.options || {};
        widget.options[key] = value.default;
      });
      var filesuffix = new Date().getTime();
      var id = type + '-' + filesuffix + '-tmp';
      widget.id = id;
      widget.type = type;
      widgets[id] = widget;
      amplify.store('widgets',widgets,{expires: dashexpert_api.settings.datacache});
      dashexpert_api.settings.currentWidget = id;
      return widget;
    };
    var createWidgetForm = function(type,wid,callback) { // use wid for loading data
      var widgets = amplify.store('widgets');
      var widget = widgets[wid] || {};
      var dtype = 'advanced';
      var blist = dashexpert_api.widget_preferences[type].blacklist;
      if(dashexpert_api.widgets[type].options) {
        dtype = dashexpert_api.widgets[type].options[2].default;
      }
      if(wid) {
        if(widget.dcolumn) {
          widget.dcolumn = widget.dcolumn;
        }
        if(widget.options.dcolumn2) {
          widget.options.dcolumn2 = widget.options.dcolumn2;
        }
        if(widget.options.dcolumn3) {
          widget.options.dcolumn3 = widget.options.dcolumn3;
        }
        if(widget.options.h_limit) {
          widget.h_limit = widget.options.h_limit;
          widget.m_limit = widget.options.m_limit;
          widget.l_limit = widget.options.l_limit;
        }
      } else {
        widget = createTmpWidget(type,dtype);
        wid = widget.id;
        widgets[wid] = widget;
        amplify.store('widgets',widgets);
      }
      var getInspector = function(dsID) {
        var ds = amplify.store('datasources');
        ds = ds[dsID];
        var inspector = "inspector_" + ds.apistring.inspector;
        return inspector;
      };
      var createOptionGroup = function(groupname,element) { // name of group and element to move there
        if($('#group-' + groupname).length === 0) {
          var html = '<div class="panel panel-default" id="group-' + groupname + '"><div class="panel-body"></div></div>';
          $('#in-' + groupname).closest('.form-group').after(html);
          $('#in-' + groupname).addClass('optionControl');
        }
        $('#group-' + groupname + ' .panel-body').append(element);
      };
      var buildDisplayColumns = function(target,col,selected,xref) { // select
        var options = '';
        $(target).empty();
        $.each(col,function(i) {
          var name = xref[col[i]];
          if(name === undefined) {
            name = col[i];
          }
          if($.inArray(col[i],selected) !== -1) {
            options += '<option value="' + col[i] + '" selected>' + name + '</option>';
          }
          else {
            options += '<option value="' + col[i] + '">' + name + '</option>';
          }
        });
        $(target).html(options);
        //added sortable columns
        $(target).multiSelect({ selectionHeader : '<strong>Selected Columns</strong>', selectionFooter : '<a href="" id="deselect-dcol">Deselect All</a>', selectableHeader : '<strong>Available Columns</strong>', selectableFooter : '<a href="" id="select-dcol">Select All</a>' });
        if(widget.displaycols === '' || widget.displaycols === undefined) {
          $(target).multiSelect('select_all', { keepOrder: true });
        } else {
          $(target).multiSelect('refresh', { keepOrder: true });
        }
        $('#select-dcol').click(function(e) {
          e.preventDefault();
          $(target).multiSelect('select_all', { keepOrder: true });
          return false;
        });
        $('#deselect-dcol').click(function(e) {
          e.preventDefault();
          $(target).multiSelect('deselect_all', { keepOrder: true });
          return false;
        });
      };
      var buildColumnSelect = function(target,col,selected,xref) {
        var options = '';
        $(target).empty();
        if(!selected) {
          options += '<option value="">Select an Option...</option>';
        }
        $.each(col,function(i) {
          var name = xref[col[i]];
          if(name === undefined) {
            name = col[i];
          }
          if($.inArray(selected,col) === i) {
            options += '<option value="' + col[i] + '" selected>' + name + '</option>';
          } else {
            options += '<option value="' + col[i] + '">' + name + '</option>';
          }
        });
        $(target).html(options);
      };
      var getAvailableBasis = function(apistring) {
        var bl = amplify.store('fullbasisList');
        var inspector = 'inspector_' + apistring.inspector;
        bl = bl[inspector];
        var basis = apistring.basis.split(',');
        var unbasis = [];
        if(apistring.unbasis) {
          unbasis = apistring.unbasis.split(',');
        }
        $.each(unbasis, function(i){
          if(basis.includes(unbasis[i])) {
            basis.splice(basis.indexOf(unbasis[i]),1);
          }
        });
        return {
          basis: basis,
          bl: bl
        };
      };
      var buildBasisSelect = function(target,apistring,selected) {
        var b = getAvailableBasis(apistring);
        var options = '';
        $(target).empty();
        options += '<option value="">Select a Basis...</option>';
        $.each(b.bl,function(k) {
          if(b.basis.includes(k)) {
            var name = b.bl[k][Object.keys(b.bl[k])[0]];

            if(selected === k) {
              options += '<option value="' + k + '" selected>' + name + '</option>';
            } else {
              options += '<option value="' + k + '">' + name + '</option>';
            }
          }
        });
        $(target).html(options);
      };
      var getAvailableColumns = function(id,overwrite,callback) { 
        if(!id) {
          return;
        }
        overwrite = overwrite || false;
        var anc = [];
        var dataid = '';
        var datasources = amplify.store('datasources');
        var xref = amplify.store('xref');
        var ac = datasources[id].apistring.columns.split(',');
        var apistring = JSON.stringify(datasources[id].apistring); //get APIString
        if(type === 'amchart_sankey') {
          if(overwrite) {
            widget.scolumn = JSON.parse(apistring).sort_col;
          }
          buildColumnSelect('#in-scolumn',ac,widget.scolumn,xref);
          buildBasisSelect('#in-basis1',datasources[id].apistring,widget.options.basis1);
          buildBasisSelect('#in-basis2',datasources[id].apistring,widget.options.basis2);
          buildBasisSelect('#in-basis3',datasources[id].apistring,widget.options.basis3);
          buildBasisSelect('#in-basis4',datasources[id].apistring,widget.options.basis4);
        } else {
          // check if array
          if(overwrite) {
            $('#in-dcolumn').val(JSON.parse(apistring).sort_col);
            widget.dcolumn = JSON.parse(apistring).sort_col;
            widget.scolumn = JSON.parse(apistring).sort_col;
          }
          buildDisplayColumns('#in-displaycols',ac,widget.displaycols,xref);
          buildColumnSelect('#in-dcolumn',ac,widget.dcolumn,xref);
          buildColumnSelect('#in-scolumn',ac,widget.scolumn,xref);
          buildColumnSelect('#in-dcolumn2',widget.displaycols,widget.options.dcolumn2,xref);
          buildColumnSelect('#in-dcolumn3',widget.displaycols,widget.options.dcolumn3,xref);
          if(widget.options.apistring === undefined || widget.options.apistring === '') {
            $('#in-apistring').val('{\n\n\n}');
          }
          retrieveData(wid,'preview',function(vid){
            var mapid = amplify.store('map_' + vid);
            var data = amplify.store(mapid); //get Data from encoded APIString
            $.each(data.table[0], function(key) {
              if(!isNaN(data.table[0][key][0])) {
                anc.push(key);
              }
            });
            buildDisplayColumns('#in-displaycols',ac,widget.displaycols,data.xref);
            buildColumnSelect('#in-dcolumn',ac,widget.dcolumn,data.xref);
            buildColumnSelect('#in-scolumn',ac,widget.scolumn,data.xref);
            buildColumnSelect('#in-dcolumn2',widget.displaycols,widget.options.dcolumn2,xref);
            buildColumnSelect('#in-dcolumn3',widget.displaycols,widget.options.dcolumn3,xref);
            dashexpert_api.fn.widgets[widget.type].create(widget,vid);
          });
        }
        
        if(callback && typeof callback === 'function') {
          callback();
        }
      };
      $('#save-alert').fadeOut('slow');
      $('#outer-widget-container').show();
      $('#bind-widget-select').hide();
      var heading = 'Create ' + type + ' widget';
      if(wid) {
        //$('#in-id').val(wid);
        heading = 'Edit ' + type + ' widget';
      }
      var panelID = 'panel_' + new Date().getTime();
      var html = '<div class="panel panel-primary" id="' + panelID + '">\n\t<div class="panel-heading">' + heading + '</div>\n\t<div class="panel-body">\n';
      var defaults = $.extend(true, {}, dashexpert_api.widgets.default);
      if(type === 'multitable' || type === 'info' || type === 'html' || dtype === 'simple') {
        defaults = $.extend(true, {}, dashexpert_api.widgets.info_default);
      }
      // REMOVE BLACKLIST
      $.each(blist, function(i) {
        delete defaults[blist[i]];
      });
      $.each(defaults, function(key,val) {
        var value = $.extend(true,{},val[2]);
        if(wid) {
          if(widgets[wid].hasOwnProperty(key)) {
            value.default = widgets[wid][key];
            //value = {default: widgets[wid][key], hint: value.hint};
          }          
        } else {
          widget[key] = value.default;
        }
        html += buildFormElement(key,val[0],val[1],value);
      });
      html += '<div id="advanced_options">';
      $.each(dashexpert_api.widgets[type], function(key,val) {
        var value = $.extend(true,{},val[2]);
        if(wid) {
          if(widgets[wid].options.hasOwnProperty(key)) {
            value.default = widgets[wid].options[key];
            //value = {default: widgets[wid].options[key],hint: value.hint};
          }    
        } else {
          widget.options = widget.options || {};
          widget.options[key] = value.default;
        }
        html += buildFormElement(key,val[0],val[1],value);
      });
      //html += '\n<button class="btn btn-default" id="btn-cancel-widget">Cancel</button> <button class="btn btn-success" id="btn-create-widget">Save</button>';
      html += '</div></div></div>';
      // build html to screen
      var isNew = wid.match(/-tmp$/) || false;
      if(wid && !isNew) {
        $('#view-widget-edit #widget-container').html(html);
        $('#in-id').val(wid);
      } else {
        $('#in-id').val(wid);
        $('#view-widgets-create #widget-container').html(html);
      }
      //$('#' + panelID + ' textarea[id^="in-api"]').attr('rows', '8');
      $('#' + panelID + ' .colorpick1').colorpicker();
      if(type === 'multitable' || type === 'info') {
        buildTableSelect('#' + panelID + ' #in-tables');
        $('#widget_preview .panel-body').html('<h1>WIDGET PREVIEW DISABLED</h1>');
      } else {
        buildDatasourceSelect('#' + panelID + ' #in-datasource');
        $('#in-apistring').attr('rows', '8');
      }
      var editors = $('#' + panelID + ' .html-editor');
      if(editors.length) {
        var toolbarOptions = [[{ 'header': [1, 2, 3, 4, 5, 6, false] }],[{ 'font': [] }],['bold','italic','underline'],[{ 'color': [] }, { 'background': [] }], ,[{ 'align': [] }],[{ 'list': 'ordered'}, { 'list': 'bullet' }],['clean']];
        var quill = new Quill('#' + editors.prop('id'), {
          modules: {
            toolbar: toolbarOptions
          },
          theme: 'snow'
        });

        editors.children('.ql-editor').html($('[data-quill]').val());
      }
      if(wid && !isNew) {
        $('#' + panelID + ' #in-datasource option[value="' + widgets[wid].datasource + '"]').prop('selected', true);
        if(type === 'scorecard' || type === 'sparkline' || type === 'amchart_line' || type === 'amchart_bar' || type === 'barchart' || type === 'table' || type === 'datablocks' || type === 'amchart_pie' || type === 'amchart_sankey') {
          getAvailableColumns(widgets[wid].datasource,false,function(){
            $(document.body).off('change.selectds');
            $('#' + panelID + ' #in-datasource option[value="' + widgets[wid].datasource + '"]').prop('selected', true).change();
            // if(wid) {
              $(document.body).on('change.selectds','#in-datasource', function(e) {
                var widgets = amplify.store('widgets');
                var dcolumn = widgets[$('#in-id').val()].dcolumn;
                var datasources = amplify.store('datasources');
                var ds = $('#in-datasource :selected').val();
                if(dcolumn) {
                  getAvailableColumns(ds,false);
                } else {
                  getAvailableColumns(ds,true);
                }
                if(type === 'amchart_sankey') {
                  buildBasisSelect('#in-basis1',datasources[ds].apistring,widget.options.basis1);
                  buildBasisSelect('#in-basis2',datasources[ds].apistring,widget.options.basis2);
                  buildBasisSelect('#in-basis3',datasources[ds].apistring,widget.options.basis3);
                  buildBasisSelect('#in-basis4',datasources[ds].apistring,widget.options.basis4);
                }
              });
            // }
          });
          $(document.body).on('change.selectbasis','[id^="in-basis"]', function(e) {
            var b = getAvailableBasis;
          });
        }
        if(type === 'multitable') {
          $('#' + panelID + ' #in-tables').multiSelect('select',widgets[wid].options.tables, { keepOrder: true });
          $('#advanced_options').show();
        }

      } else {
        $(document.body).on('change.selectds','#in-datasource', function(e) {
          var widgets = amplify.store('widgets');
          var datasources = amplify.store('datasources');
          var dcolumn = widgets[$('#in-id').val()].dcolumn;
          var ds = $('#in-datasource :selected').val();
          if(dcolumn) {
            getAvailableColumns(ds,false);
          } else {
            getAvailableColumns(ds,true);
          }
          if(type === 'amchart_sankey') {
            buildBasisSelect('#in-basis1',datasources[ds].apistring,widget.options.basis1);
            buildBasisSelect('#in-basis2',datasources[ds].apistring,widget.options.basis2);
            buildBasisSelect('#in-basis3',datasources[ds].apistring,widget.options.basis3);
            buildBasisSelect('#in-basis4',datasources[ds].apistring,widget.options.basis4);
          }
        });
      }
      $.each($('[data-group]'), function() {
        var groupname = $(this).data('group');
        if(groupname) {
          createOptionGroup(groupname,$(this).closest('.form-group'));
        }
        if($('#in-' + groupname).is(':checked')) {
          $('#group-' + groupname).show();
        } else {
          $('#group-' + groupname).hide();
        }
      });
      $('.optionControl').on('change', function(e) {
        if(this.checked) {
          $('#group-' + $(this).prop('id').slice(3)).show();
        } else {
          $('#group-' + $(this).prop('id').slice(3)).hide();
        }
      });
      $('#in-apistring').prev().append(' <i class="fa fa-info-circle showapi"></i>');
      $(document.body).on('click', '.showapi', function(e) {
        var ds = $('#in-datasource :selected').val();
        var datasources = amplify.store('datasources');
        var apistring = JSON.stringify(datasources[ds].apistring, undefined, 4);
        $('#showapi-modal .modal-title').html(datasources[ds].title);
        $('#showapi-modal .panel-body').html('<pre class="pre-scrollable">' + apistring + '</pre>');
        $('#showapi-modal').modal('show');
      });
      $('#btn-create-widget, #btn-saveas-widget, #btn-save-widget').on('click', function(e) {
        var mode = $(this).data('mode');
        e.preventDefault();
        var formvalues = {};
        formvalues.type = type;
        formvalues.options = {};
        var target = '#' + panelID + ' [id^="in-"]';
        if(mode === 'edit') {
          target = '#view-widget-edit #' + panelID + ' [id^="in-"]';
        }
        $(target).each(function(){ 
          var value = $(this).val();
          if(this.type === 'checkbox') {
            value = this.checked;
          }
          if($(this).data('quill')) {
            value = $('#' + $(this).data('quill')).children().html().replace(/"/g, '\'');
          }
          var defaults = Object.keys(dashexpert_api.widgets.default);
          if(defaults.indexOf(this.id.slice(3)) != -1) {
            formvalues[this.id.slice(3)] = value;
          } else {
            formvalues.options[this.id.slice(3)] = value;
          }
        });
        var filesuffix,id;
        var overwrite = true;
        if(wid.match(/-tmp$/)) {
          var pass = errorCheck(formvalues,'widget');
          if(pass.passed) {
            deleteTmpWidgets();
            filesuffix = new Date().getTime();
            id = type + '-' + filesuffix;
            wid = id;
            overwrite = false;
            saveWidget(formvalues,wid,overwrite);
          }
          if(mode === 'saveclose' && pass.passed) {
            setTimeout(() => { $('#btn-cancel-widget').trigger('click'); }, 2000);
            mode = 'new';
          }
        }
        if(!wid || mode === 'saveas') {
          filesuffix = new Date().getTime();
          id = type + '-' + filesuffix;
          wid = id;
          overwrite = false;
          if(mode === 'saveas') {
            addModal('widget-saveas-modal');
            $('#widget-saveas-modal .modal-body').empty();
            $('#in-title').parent().clone().children('input').attr('id','tmp-title').parent().appendTo('#widget-saveas-modal .modal-body');
            $('#btn-create-widget').clone().attr('id','btn-saveas-modal').appendTo('#widget-saveas-modal .modal-body');
            $('#widget-saveas-modal .modal-title').html('Save As new widget');
            $('#widget-saveas-modal').modal('show');
            var title = $('#in-title').val();
            $('#tmp-title').val(title + ' (copy)');
            $('#btn-saveas-modal').on('click', function(e) {
              e.preventDefault();
              formvalues.title = $('#tmp-title').val();
              $('#in-title').val(formvalues.title);
              saveWidget(formvalues,wid,overwrite);
              $('#widget-saveas-modal').modal('hide');
            });
          }
        }
        if(mode != 'saveas' && mode != 'new' && mode != 'saveclose') {
          widget.header = widget.header || widgets[wid].header;
          formvalues.lastsave = widget.header.lastupdated;
          saveWidget(formvalues,wid,overwrite);
          //loadHTML('#view-widget-edit','view-widget-edit.html');
        }
        if(type != 'multitable') {
          widget = formvalues;
          var ds = $('#in-datasource :selected').val();
          getAvailableColumns(ds);
        } else {
          $('#widget_preview .panel-body').html('<h1>WIDGET PREVIEW DISABLED</h1>');
        }
        if(mode === 'saveclose' && pass.passed) {
          widget.header = widget.header || widgets[wid].header;
          formvalues.lastsave = widget.header.lastupdated;
          saveWidget(formvalues,wid,overwrite);
          //var pass = errorCheck(formvalues,'widget');
          //if(pass.passed) {
            setTimeout(() => { $('#btn-cancel-widget').trigger('click'); }, 2000);
          //}
          //loadHTML('#view-widgets-browse','view-widgets-browse.html');
        }
      });
      $('#btn-cancel-widget').on('click', function(e) {
        e.preventDefault();
        deleteTmpWidgets();
        loadHTML('#view-widgets-browse','view-widgets-browse.html');
      });
      if(callback && typeof callback === 'function') {
        callback();
      }
    };
    var buildDatasourceSelect = function(target) {
      var sources = amplify.store('datasources');
      var html = '';
      $.each(sources, function(key,val) {
          html += '\t<option value="' + key + '">' + val.title + '</option>';
      });
      $(target).html(html);
      $(target).html($(target + ' option').sort(function(a,b) {
        return a.text == b.text ? 0 : a.text < b.text ? -1 : 1;
      }));
      $(target).prepend('<option value="" selected="selected">Select a datasource</option>');
      $(target).prev().append(' <i class="fa fa-info-circle showapi"></i>');
      addModal('showapi-modal');
    };
    var buildTableSelect = function(target) {
      var sources = amplify.store('widgets');
      var html = '';
      $.each(sources, function(key,val) {
        if(val.type === 'table') {
          html += '\t<option value="' + key + '">' + val.title + '</option>';
        }
      });
      //html += '</select>';
      $(target).html(html);
      $(target).html($(target + ' option').sort(function(a,b) {
        return a.text == b.text ? 0 : a.text < b.text ? -1 : 1;
      }));
      $(target).multiSelect({ keepOrder: true });
    };
    var buildPreferences = function(init) {
      // initialize modal
      var initPreferences = function() {
        var p = amplify.store('preferences') || dashexpert_api.settings;
        if($.isEmptyObject(p.load_dashboards)) {
          p.load_dashboards = dashexpert_api.settings.load_dashboards;
        }
        if(p.defaultDate === '-' || p.defaultdate === undefined) {
          p.defaultdate = dashexpert_api.settings.defaultdate;
        }
        amplify.store('preferences',p);
        $.each(p, function(k,v) {
          dashexpert_api.settings[k] = p[k];
        });
        if(p.theme) {
          $.each(dashexpert_api.settings.themes, function(i) {
            $('body').removeClass(dashexpert_api.settings.themes[i]);
          });
          $('body').addClass(p.theme);
        }
      };
      if(init) { 
        initPreferences(); 
      }
      addModal('preferences-modal','body','modal-md');
      $('#preferences a').on('click', function(e) {
        e.preventDefault();
        createPreferencesForm();
        $('#preferences-modal').modal('show');
      });
      var savePreferences = function() {
        var p = amplify.store('preferences');
        var target = '#preferences-modal [id^="in-"]';
        var formvalues = p;
        $(target).each(function(){ 
          var value = $(this).val();
          if(this.type === 'checkbox') {
            value = this.checked;
          }
          var defaults = Object.keys(dashexpert_api.settings);
          if(defaults.indexOf(this.id.slice(3)) !== -1) {
            formvalues[this.id.slice(3)] = value;
            dashexpert_api.settings[this.id.slice(3)] = value;
          }
        });
        if($('#in-editmodeon').prop('checked') && dashexpert_api.admin) {
          $('[data-acl="admin"]').show();
        } else {
          $('[data-acl="admin"]').hide();
          $('[data-acl="user"]').show();
        }
        $('#autorefresh').prop('checked', formvalues.autorefresh);
        if(formvalues.refreshtime === -1) {
          formvalues.refreshtime = dashexpert_api.settings.refreshtime;
        }
        formvalues.refreshtime = parseInt(formvalues.refreshtime);
        if(formvalues.theme) {
          $.each(dashexpert_api.settings.themes, function(i) {
            $('body').removeClass(dashexpert_api.settings.themes[i]);
          });
          $('body').addClass(formvalues.theme);
        }
        var pass = errorCheck(formvalues,'preferences');
        var dashboards = amplify.store('dashboards');
        formvalues.unload_dashboards = [];
        $.each(dashboards, function(k,v) {
          if($.inArray(k,formvalues.load_dashboards) === -1) {
            formvalues.unload_dashboards.push(k);
          }
        });
        if(pass.passed) {
          amplify.store('preferences',formvalues);
          var searchFields = amplify.store('searchFields');
          buildSearchFields(searchFields[dashexpert_api.settings.currentdash], getSearchValues());
        }
        dashexpert_api.util.debugOut(formvalues);
      };
      var createPreferencesForm = function() {
        $('[id^="save-alert"]').remove();
        var html = '';
        var tabclass = 'active';
        var p = amplify.store('preferences') || dashexpert_api.settings;
        p.autorefresh = dashexpert_api.settings.autorefresh;
        $('#preferences-modal .modal-title').html('User Preferences');
        $.each(dashexpert_api.advanced_preferences, function(i) {
          if(i > 0) { 
            tabclass = '';
          } else {
            html += '<ul id="preferences-tabs" class="nav nav-tabs" role="tablist">\n';
          }
          html += '\t<li role="presentation" class="' + tabclass + '"><a href="#pref_tab_' + dashexpert_api.advanced_preferences[i].tab.toLowerCase() + '" aria-controls="pref_tab_' + dashexpert_api.advanced_preferences[i].tab.toLowerCase() + '" role="tab" data-toggle="tab">' + dashexpert_api.advanced_preferences[i].tab + '</a></li>\n';
          if(i === (dashexpert_api.advanced_preferences.length - 1)) { html += '</ul>\n'; }
        });
        tabclass = 'active';
        $.each(dashexpert_api.advanced_preferences, function(i) {
          if(i > 0) { 
            tabclass = '';
          } else {
            html += '<div class="tab-content">\n';
          }
          html += '\t<div role="tabpanel" class="tab-pane ' + tabclass + '" id="pref_tab_' + dashexpert_api.advanced_preferences[i].tab.toLowerCase() + '">\n';
          $.each(dashexpert_api.advanced_preferences[i].fields, function(key,val) {
            var value = $.extend(true,{},val[2]);
            if(key in p) {
                value.default = p[key];       
            } else {
              p[key] = value.default;
            }
            html += buildFormElement(key,val[0],val[1],value);
          });
          html += '\t</div>\n';
          if(i === (dashexpert_api.advanced_preferences.length - 1)) { html += '</div>\n'; }
        });
        $('#preferences-modal .panel-body').html(html);
        var daterange = dashexpert_api.searchbar.select_date;
        var optOpen = false;
        html = '';
        $.each(daterange, function(key,val) {
          if(val[1] === undefined) {
            if(val[0] === "") {
              html += '\t<option value="">' + val[0] + '</option>';
            } else {
              if(optOpen) {
                html += '</optgroup>';
                optOpen = false;
              }
              html += '\t<optgroup label="' + val[0] + '">';
              optOpen = true;
            }
          } else {
            html += '\t<option value="' + val[1] + '">' + val[0] + '</option>';
          }
        });
        if(optOpen) {
          html += '</optgroup>';
        }
        $('#in-defaultdate').html(html);
        $('#in-defaultdate option[value=""]').remove();
        $('#in-defaultdate option[value="' + p.defaultdate + '"]').prop('selected',true);
        if(dashexpert_api.admin) {
          $('#preferences-modal .panel-body [data-acl="admin"]').attr('data-acl','user');
        }
        $('#in-refreshtime option[value="-1"]').remove();
        $('#in-apilimit option[value="-1"]').remove();
        // EVENTS
        var target = '#preferences-modal [id^="in-"]';
        $(target).on('change', function() {
          if(this.id === 'in-defaultdate') {
            if($(this).val() === "-") {
              $('#in-defaultdate').val('Today');
            }
          }
          savePreferences();
          if(this.id === 'in-defaultdate') {
            $('#srch_date').val($(this).val());
            $('#srch_btn').trigger('click');
          }
        });
        $('#in-import_btn').on('click.import', function(e){
          e.preventDefault();
          dashexpert_api.fn.import.importFile();
        });
        $('#in-resetp_btn').on('click.reset', function(e){
          e.preventDefault();
          amplify.clearStore('preferences');
          window.location.reload();
        });
      };
    };
    // FUNCTIONS
    var searchToggle = function(mode) { // mode on|off
      var searchOff = $('#search-bar').is(':hidden');
      var activeNav = $('.nav-main .active');
      if(!searchOff || mode === 'off') {
        $('#search-toggle').removeClass('active');
        $('#search-bar').hide();
        $('#view-dashboard').attr('class', 'col-md-12');
      } else {
        activeNav.toggleClass('active');
        $('#search-toggle').addClass('active');
        $('#search-bar').show();
        $('#search-bar').addClass('col-md-2');
        $('#view-dashboard').attr('class', 'col-md-10');
      }
      var currentView = $('.nav .active a').data('view-toggle');
      if(currentView === 'view-dashboard' || currentView === undefined) {
         dashexpert_api.fn.widgets.sparkline.redrawSparksBars(); 
      }
    };
    var initUI = function() {
      $('.navbar-form button[role="logout"]').hide();
      $('.navbar-form button[role="login"]').hide();
      $('.navbar-form .form-group').hide();
      $('[data-acl="admin"]').hide();
      $('[data-acl="user"]').show();
      $('#add-dashboard').parent().hide();
      checkSession();
      dashexpert_api.init = {};
      dashexpert_api.init.dash_loaded = false;
      dashexpert_api.init.data_loaded = false;
      dashexpert_api.init.pagesLoaded = [];
      loadHTML('#view-dashboard','view-dashboard.html');
      $('#add-dashboard').parent().hide();
      $('#search-toggle').show();
      $('[id^="view-"]').attr('class', 'col-md-12');
      $('#search-bar').hide();
      buildSearchSelects();
      buildPreferences(true);
      deleteTmpWidgets();
      $('#search-toggle').on('click', function() {
        searchToggle();
      });
      $("a[data-view-toggle]").on("click", function(e){
          e.preventDefault();
          $('#search-toggle').removeClass('active');
          var currentView = $('.nav .active a').data('view-toggle');
          var newView = $(this).data('view-toggle');
          $(".nav").find(".active").removeClass("active");
          $(this).parent().addClass("active");
          searchToggle('off');
          if(newView) {
              loadHTML('#' + newView,newView + '.html');
          }
      });
      $('.navbar-form button[role="login"]').on("click", function(e){
        e.preventDefault();
        var user = $('.navbar-form input[name="username"]').val();
        var pass = $('.navbar-form input[name="password"]').val();
        dashexpert_api.util.checkLogin(user,pass);
        if(localStorage.dashSession) {
          $('.navbar-form button[role="login"]').hide();
          $('.navbar-form button[role="logout"]').show();
        }
      });
      $('.navbar-form button[role="logout"]').on('click', function(e){
        e.preventDefault();
        localStorage.removeItem('dashSession');
        $('[data-acl="admin"]').hide();
        $('p.navbar-text').hide();
        $('.navbar-form .form-group').show();
        $('.navbar-form button[role="login"]').show();
        $('.navbar-form button[role="logout"]').hide();
        dashexpert_ui.util.createAlert('You have been logged out successfully.','success','login-alert');
      });
      $('#dashboard-tabs').on('click','#add-dashboard', function(e) {
        e.preventDefault();
        createGSgrid('#view-dashboard','_new',function(vid) {
          reorderTabs();
          dashexpert_api.settings.currentdash = vid;
          createDashboardForm(vid);
          $('#save-dashboard-modal').modal('show');
        });
      });
    };
    var loadHTML = function(target,file) {
      if(file !== 'view-dashboard.html') {
        abortCurrentQue();
      }
      $('[id^="view-"]').hide();
      $('#ext-dashboard-modal-widget').show(); // fixes modal widget from disappearing
      var options = {"order" : [[0, 'asc']],"pageLength" : 100};
      if(dashexpert_api.init.pagesLoaded.indexOf(file) != -1  && !file.match(/browse.html$/) && !file.match(/edit.html$/) && !file.match(/create.html$/)) {
        $(target).show();
        $(target + '-display').show();
        initPage(file);
      } else {
        if(file === 'view-dashboard.html' || file === 'view-views-create2.html') {
          $(target + '-display').show();
        }
        //$('[id^="views-alert"]').alert('close');
        $(target).empty();
        var firstload = false;
        if(dashexpert_api.init.pagesLoaded.indexOf('view-dashboard.html') === -1) {
          firstload = true;
        }
        $(target).load('html/' + file + '?' + new Date().getTime(), function(){
          if(firstload) {
            $('#view-dashboard-display').html('<span id="loading_dashboards" class="label label-success"  style="display:block;margin-left: auto;margin-right: auto;font-size: 30px;"><i class="fa fa-spinner fa-spin"></i> <span>Preparing Dashboards...</span></span>');
          }
          $(target).show();
          switch(file) {
            case 'view-widgets-browse.html':
              getAllWidgets(function() {
                initPage(file);
              });
              return;
            case 'view-datasources-browse.html':
              getAllDatasources(function() {
                initPage(file);
              });
              return;
            case 'view-dashboards-browse.html':
              getAllDashboards(function() {
                initPage(file);
              });
              return;
            default:
              initPage(file);
              return;
          }
        });
        dashexpert_api.init.pagesLoaded.push(file);
      }
      
    };
    var checkSessionOld = function() {
      dashexpert_api.ssid = false;
      var SSID = getAPICookie('JSESSIONID');
      if(SSID) {
        dashexpert_api.ssid = SSID;
      }
      if(localStorage.dashSession) {
        dashexpert_api.admin = true;
        showAdmin();
      } else {
        $('head link[rel="stylesheet"]').last().after('<style type="text/css">[data-acl="admin"] { display: none; }</style>');
      }
    };
    var checkSession = function() {
      dashexpert_api.ssid = false;
      var SSID = getAPICookie('JSESSIONID');
      if(SSID) {
        dashexpert_api.ssid = SSID;
        dashexpert_api.auth.user(function(u) {
          dashexpert_api.util.debugOut(u);
          $.each(u.groups, function(i,v) {
            if(dashexpert_api.settings.dash_admin_group.indexOf(v.name) !== -1) {
              dashexpert_api.admin = true;
              showAdmin();
            }
          });
          if(!dashexpert_api.admin) {
            $('head link[rel="stylesheet"]').last().after('<style id="acl_style" type="text/css">[data-acl="admin"] { display: none; }</style>');
          }
        });
      }
    };
    var showAdmin = function() {
      var p = amplify.store('preferences') || { editmodeon : dashexpert_api.settings.editmodeon };
      if(dashexpert_api.admin) {
        var userinfo = amplify.store('userinfo');
        //('.navbar-form button[role="logout"]').removeClass('hidden');
        $('p.navbar-text span').text('Logged in as: ' + userinfo.name);
        $('.navbar-form button[role="logout"]').hide();
        $('.navbar-form button[role="login"]').hide();
        $('[data-acl="admin"]').removeClass('hidden');
        // $('[data-acl="admin"]').show();
        $('.navbar-form .form-group').hide();
        //$('p.navbar-text').removeClass('hidden');
        //$('p.navbar-text').show();
      }
      if(p.editmodeon && dashexpert_api.admin) {
        $('[data-acl="admin"]').show();
      } else {
        $('[data-acl="admin"]').hide();
        $('[data-acl="user"]').show();
      }
    };
    var getCurrentQue = function() {
        var q = dashexpert_api.settings.ajaxqsize;
        if(dashexpert_api.settings.currentque === undefined || dashexpert_api.settings.currentque >= q) {
            dashexpert_api.settings.currentque = 0;
            //dashexpert_api.fn.widgets.sparkline.redrawSparksBars();
        }
        dashexpert_api.settings.currentque ++;
        var qname = 'widgetdata_' + dashexpert_api.settings.currentque;
        if($.inArray(qname,dashexpert_api.settings.ajaxq) === -1) {
            dashexpert_api.settings.ajaxq.push(qname);
        }
        dashexpert_api.util.debugOut('current ajax que: ' + qname);
        return qname;
    };
    var clearCurrentQue = function() {
        $.each(dashexpert_api.settings.ajaxq, function(i,v){
            $.ajaxq.clear(v);
        });
        dashexpert_api.settings.ajaxq = [];
        $('#loadingmsg').hide();
        $('#loadingmsg').empty();
    };
    var abortCurrentQue = function() {
        $.each(dashexpert_api.settings.ajaxq, function(i,v){
            $.ajaxq.abort(v);
        });
        dashexpert_api.settings.ajaxq = [];
        $('#loadingmsg').hide();
        $('#loadingmsg').empty();
    };
    var authLevel = function(groupids) { // checks current user against groupids array
      var auth = false;
      if(groupids === null || groupids === undefined || $.isEmptyObject(groupids) || groupids.length === 0) {
        auth = true;
      } else {
        var userinfo = amplify.store('userinfo');
        $.each(groupids, function(i) {
          var groupid = groupids[i];
          $.each(userinfo.groups, function(i) {
            if(userinfo.groups[i].id == groupid || groupid === '') {
              auth = true;
            }
          });
        });
      }
      return auth;
    };
    var initApp = function(callback) {
        var sdata = {};
        dashexpert_api.auth.user(function() {
          sdata.groups = true;
          getAllDashboards(function() {
            sdata.dashboards = true;
          });
          getAllWidgets(function() {
            sdata.widgets = true;
          });
          getAllDatasources(function() {
            sdata.datasources = true;
          });
        });
        // getAllDashboards(function() {
        //   sdata.dashboards = true;
        // });
        // getAllWidgets(function() {
        //   sdata.widgets = true;
        // });
        // getAllDatasources(function() {
        //   sdata.datasources = true;
        // });
        if(dashexpert_api.settings.sessionAuthorized) {
            var getData = setInterval(function() {
                if(!dashexpert_api.settings.sessionAuthorized) {
                  clearInterval(getData);
                }
                //if(sdata.dashboards && sdata.widgets && sdata.datasources && sdata.groups && dashexpert_api.usergroups !== undefined) {
                if(sdata.dashboards && sdata.widgets && sdata.datasources) {
                  clearInterval(getData);
                  if(callback && typeof callback === 'function') {
                    callback(false);
                  }
                }
            }, 500);
            var keepAlive = setInterval(function() {
              dashexpert_ui.util.keepSessionAlive();
            }, 60000);
        }
    };
    var finalizeApp = function(callback) {
      $('#add-dashboard').parent().hide();
      $('#loading_dashboards span').html('Initializing Preferences...');
      dashexpert_api.util.debugOut('Initializing Preferences...');
      var p = amplify.store('preferences') || dashexpert_api.settings;
      $('#autorefresh').prop('checked', p.autorefresh);
      // start timer on page load if autorefresh is on
      if (dashexpert_api.settings.autorefresh) {
        autorefresh();
      }
      $('#auto-refresh-setting label span').remove();
      $('#auto-refresh-setting label').append('<span> (' + p.refreshtime/60000 + 'm)</span>');
      var dashboards = amplify.store('dashboards');
      //$('#loadingmsg').show();
      var i = 750;
      var complete = false;
      var forceload = false;
      var darray = reorderObject(dashboards);
      var darraynew = darray.slice();
      if($.isEmptyObject(p.load_dashboards) || $.isEmptyObject(dashboards)) {
        p.load_dashboards = dashexpert_api.settings.load_dashboards;
        $('#loading_dashboards').remove();
      }
      var dcount = p.load_dashboards.length;
      $.each(p.load_dashboards, function(k,v) { // check if default dashes exist
        if($.inArray(k,dashboards) === -1 || authLevel(dashboards[v].groups) === false) {
          dcount += -1;
        }
      }); 
      if(dcount < p.load_dashboards.length) {
        forceload = true;
      }
      $.each(dashboards, function(k,v) { // check for new dashboards and add to array
        if($.inArray(k,p.load_dashboards) === -1 && $.inArray(k,p.unload_dashboards) === -1) {
          p.unload_dashboards.push(k);
        }
      });
      var xref = amplify.store('xref') || dashexpert_api.xref_defaults;
      amplify.store('xref',xref);
      amplify.store('preferences',p);
      var userinfo = amplify.store('userinfo');
      $.each(darray, function(k,v) {
        var auth = authLevel(dashboards[v].groups);
        if(!dashboards[v].hasOwnProperty('display') || forceload === true) {
          dashboards[v].display = true;
        }
        if(!dashboards[v].hasOwnProperty('publish')) {
          dashboards[v].publish = true;
        }
        if(dashboards[v].publish === false && dashboards[v].header.creatorid !== userinfo.id) {
          darraynew.splice(darraynew.indexOf(v),1);
        } else {
          if(dashboards[v].display === false || auth === false || $.inArray(v,p.load_dashboards) === -1) {
            darraynew.splice(darraynew.indexOf(v),1);
          }
        }
        
      });
      if(darraynew.length === 0) {
        p.load_dashboards = p.unload_dashboards;
        p.unload_dashboards = [];
        amplify.store('preferences',p);
        darraynew = darray;
        // $.each(darray, function(k,v) {
        //   var auth = authLevel(dashboards[v].groups);
        //   if(!dashboards[v].hasOwnProperty('display') || forceload === true) {
        //     dashboards[v].display = true;
        //   }
        //   if(!dashboards[v].hasOwnProperty('publish')) {
        //     dashboards[v].publish = true;
        //   }
        //   if(dashboards[v].publish === false && dashboards[v].header.creatorid !== userinfo.id) {
        //     darraynew.splice(darraynew.indexOf(v),1);
        //   } else {
        //     if(dashboards[v].display === false || auth === false || $.inArray(v,p.load_dashboards) === -1) {
        //       darraynew.splice(darraynew.indexOf(v),1);
        //     }
        //   }
        // });
      }
      if(darraynew.length === 0) {
        dashexpert_ui.util.createAlert('No Dashboards to display.','warning','info-alert');
        //dashexpert_ui.util.createPopupAlert('No Dashboards to display. Selecting all.',{'id':'info-alert','type':'warning'});
      } else {
        $.each(darraynew, function(k,v) {
          i = i+750;
          setTimeout(function(darray,k,v) {
            createGSgrid('#view-dashboard',v,function() {
              $('#add-dashboard').parent().hide();
              $('#loading_dashboards span').html('Building ' + dashboards[v].name + ' Dashboard...');
              dashexpert_api.util.debugOut('Building ' + dashboards[v].name + ' Dashboard...');
            });
            if(darraynew.length === k+1) {
              complete = true;
              $('#add-dashboard').parent().show();
              ;(function() {
                'use strict';
                $(activate);
                function activate() {
                  $('#dashboard-tabs')
                    .scrollingTabs()
                    .on('ready.scrtabs', function() {
                      $('.tab-content').show();
                    });
                }
              }());
            }
          }.bind(this,darraynew,k,v),i);
        });
        var dashcomplete = setInterval(function() {
          if(complete) {
            reorderTabs();
            var el = document.getElementById('dashboard-tabs');
            var dashtabs = Sortable.create(el, {handle: 'a', animation: 150});
            if($('#dashboard-tabs li').length > 1) {
              $('#dashboard-tabs a:first').tab('show');
            }
            //$('#dashboard-tabs a:first').tab('show');
            var dash = $('#dashboard-tabs a:first').attr('aria-controls');
            initDashEvents();
            if(dash !== undefined) {
              dashexpert_api.settings.currentdash = dash;
              getDashboardData(dash, function(){
                var searchValues = amplify.store('searchValues');
                var searchFields = amplify.store('searchFields');
                var appliedSearch = {};
                try {
                  $.each(searchValues.search, function(k,v){
                    if(searchFields[dashexpert_api.settings.currentdash][k]) {
                      appliedSearch[k] = v;
                    }
                  });
                  if(!$.isEmptyObject(appliedSearch)) {
                    var grid = $('#' + dashexpert_api.settings.currentdash + ' .grid-stack .grid-stack-item');
                    $.each(grid, function(item) {
                      resizeWidget($(this));
                      // apply search indicator
                      var wid = $('div:first', this).data('wid');
                      if(wid.startsWith('multitable')) {
                        wid = $(this).find('select').val();
                      }
                      if(wid.startsWith('barchart-') || wid.startsWith('sparkline-') || wid.startsWith('table-') || wid.startsWith('datablocks-') || wid.startsWith('scorecard-') || wid.startsWith('amchart-')) {
                        addSearchIndicator($(this),wid,appliedSearch,searchFields[dashexpert_api.settings.currentdash]);
                      }
                    });
                  }
                }
                catch(e) {
                    
                }
              });
              var grid = $('#' + dash + ' .grid-stack .grid-stack-item');
              $.each(grid, function(item) {
                resizeWidget($(this));
              });
              dashexpert_api.fn.widgets.sparkline.redrawSparksBars();
            }
            if(callback && typeof callback === 'function') {
                callback();
            }
            clearInterval(dashcomplete);
          }
        },750);
      }
    };
    var initDashEvents = function() {
      $(document).tooltip({container: 'body', placement: 'auto', html: true, selector: '[data-toggle="tooltip"]'});
      $('#dashboard-tabs a[data-toggle="tab"]').on('shown.bs.tab', function() {
        dashexpert_api.fn.widget_libraries.disposeAllCharts();
        //abortCurrentQue();
        var id = $(this).attr('aria-controls');
        dashexpert_api.settings.currentdash = id;
        refreshDash(id);
      });
      $('#dashboard-tabs a[data-toggle="tab"]').on('hide.bs.tab', function() {
        dashexpert_api.fn.widget_libraries.disposeAllCharts(); // dispose of all amcharts before switching to new tab
      });
      $('#autorefresh').on('click.autorefresh', function(e) {
        var p = amplify.store('preferences');
        if($('#autorefresh').is(':checked')) {
          dashexpert_api.settings.autorefresh = true;
          p.autorefresh = true;
          autorefresh();
        } else {
          dashexpert_api.settings.autorefresh = false;
          p.autorefresh = false;
        }
        amplify.store('preferences', p);
      });
      $(document.body).bind().on('click', '#lastdashupdate', function(event){ 
        $('#srch_btn').trigger('click');
      });
      $('#outer-container').off('click.selectWidget').on('click.selectWidget', 'i.fa-cog', function(e) {
        e.preventDefault();
        abortCurrentQue();
        $('#select_preview .panel-body').empty();
        $('#widget_select_preview .panel-body').empty();
        dashexpert_api.settings.currentvid = $(this).data('vid');
        dashexpert_api.settings.currentwid = $('#widget_' + dashexpert_api.settings.currentvid).parent().data('wid');
        getAllWidgets(function() {
          buildWidgetDropdown();
          var widgets = amplify.store('widgets');
          var widget = widgets[dashexpert_api.settings.currentwid];
          $('#widget-selector-dropdown').val(dashexpert_api.settings.currentwid);
          if(widget !== '' && widget !== undefined) {
            if(widget.type !== 'html') {
              retrieveData(dashexpert_api.settings.currentwid,'select_preview',function(vid){
                dashexpert_api.fn.widgets[widget.type].create(widget,'select_preview');
              });
            } else {
              dashexpert_api.fn.widgets[widget.type].create(widget,'select_preview');
            }
          }
        });
      });
      $('#view-dashboard-display').off('click.info').on('click.info', '.fa-info-circle', function(e) {
        e.preventDefault();
        $('#widget-info-modal').remove();
        dashexpert_api.settings.currentvid = $(this).parent().parent().parent().parent().parent().data('vid');
        dashexpert_api.settings.currentwid = $('#widget_' + dashexpert_api.settings.currentvid).parent().data('wid');
        if(dashexpert_api.settings.currentwid && dashexpert_api.settings.currentvid) {
          if(dashexpert_api.settings.currentwid.startsWith('multitable')) {
            dashexpert_api.settings.currentwid = $('#widget_' + dashexpert_api.settings.currentvid + ' select').val();
          }
          addModal('widget-info-modal');
          var widgets = amplify.store('widgets');
          var datasources = amplify.store('datasources');
          var widget = widgets[dashexpert_api.settings.currentwid];
          var html = 'Description: ' + widget.description + '<br/>';
          html += 'Widget: <strong>' + widget.title + ' [' + dashexpert_api.settings.currentwid + ']</strong><br/>';
          html += 'Datasource: <strong>' + datasources[widget.datasource].title + ' [' + widget.datasource + ']</strong><br/>';
          var apistring = amplify.store('map_' + dashexpert_api.settings.currentvid);
          if(typeof apistring === 'object') {
            apistring = apistring[dashexpert_api.settings.currentwid];
          }
          apistring = JSON.parse(atob(apistring));
          apistring = JSON.stringify(apistring,undefined,4);
          html += 'modified apistring:<br/><pre class="pre-scrollable">' + apistring + '</pre>';
          $('#widget-info-modal .panel-body').html(html);
          $('#widget-info-modal .modal-title').html(widget.title);
          $('#widget-info-modal .panel-body').off('click.editwidget').on('click.editwidget', 'a', function(e) {
              var wid = $(this).data('wid');
              dashexpert_api.currentWidget = wid;
              $('#widget-info-modal').modal('hide');
              loadHTML('#view-widget-edit','view-widget-edit.html');
          });
        }
        else {
          dashexpert_ui.util.createAlert('No widget assigned.','warning','info-alert');
        }
      });
      $('#widget-selector-dropdown').off().on('change', function(e) {
        e.preventDefault();
        abortCurrentQue();
        dashexpert_api.settings.currentwid = $('#widget-selector-dropdown :selected').val();
        var widgets = amplify.store('widgets');
        var widget = widgets[dashexpert_api.settings.currentwid];
        if(widget.type !== 'html') {
          retrieveData(dashexpert_api.settings.currentwid,'select_preview',function(vid){
            dashexpert_api.fn.widgets[widget.type].create(widget,'select_preview');
          });
        } else {
          dashexpert_api.fn.widgets[widget.type].create(widget,'select_preview');
        }
      });
      $('#widget-select-modal').off('click.assignWidget').on('click.assignWidget', '.btn[data-function]', function(e) {
        e.preventDefault();
        abortCurrentQue();
        dashexpert_api.settings.currentwid = $('#widget-selector-dropdown :selected').val();
        assignWidget(dashexpert_api.settings.currentvid,dashexpert_api.settings.currentwid);
        var widgets = amplify.store('widgets');
        var widget = widgets[dashexpert_api.settings.currentwid];
        if(widget.type !== 'multitable' && widget.type !== 'info' && widget.type !== 'html') {
          retrieveData(dashexpert_api.settings.currentwid,dashexpert_api.settings.currentvid,function(){
              dashexpert_api.fn.widgets[widget.type].create(widget,dashexpert_api.settings.currentvid);
          });
        } else {
          dashexpert_api.fn.widgets[widget.type].create(widget,dashexpert_api.settings.currentvid);
        }
        $('#widget-select-modal').modal('hide');
      });
      $('#widget-type-select').off('click.widgetFilter').on('click.widgetFilter', 'button', function(e) {
        e.preventDefault();
        var useLegacy = dashexpert_api.settings.use_legacy_charts;
        $('#widget-type-select button').removeClass('active');
        $(this).addClass('active');
        var widgettype = $(this).data('widgettype');
        if(widgettype === 'all') {
          $('#widget-selector-dropdown option').show();
        } else {
          $.each($('#widget-selector-dropdown option'),function() {
            if($(this).data('widgettype') === widgettype) {
              $(this).show();
              if(!useLegacy && widgettype === 'sparkline') {
                $('#widget-selector-dropdown option[data-widgettype="amchart_line"]').show();
              }
              if(!useLegacy && widgettype === 'barchart') {
                $('#widget-selector-dropdown option[data-widgettype="amchart_bar"]').show();
              }
            } else {
              $(this).hide();
            }
          });
        }
      });
    };
    var autorefresh = function() {
      var autorefreshTimer = setInterval(function() {
        if(dashexpert_api.settings.autorefresh) {
          refreshDash(dashexpert_api.settings.currentdash);
          dashexpert_ui.util.keepSessionAlive();
        } else {
          clearInterval(autorefreshTimer);
        }
      }, dashexpert_api.settings.refreshtime);
    };
    var refreshDash = function(id) {
      abortCurrentQue();
      if(!dashexpert_api.settings.localcache) {
        amplify.clearStore('data');
      }
      getDashboardData(id, function(){
        var searchValues = amplify.store('searchValues');
        var searchFields = amplify.store('searchFields');
        if(!$.isEmptyObject(searchValues.search)) {
          var grid = $('#' + dashexpert_api.settings.currentdash + ' .grid-stack .grid-stack-item');
          $.each(grid, function(item) {
            resizeWidget($(this));
            // apply search indicator
            var wid = $('div:first', this).data('wid');
            if(wid.startsWith('multitable')) {
              wid = $(this).find('select').val();
            }
            if(wid.startsWith('barchart-') || wid.startsWith('sparkline-') || wid.startsWith('table-') || wid.startsWith('datablocks-') || wid.startsWith('scorecard-')) {
              addSearchIndicator($(this),wid,searchValues.search,searchFields[dashexpert_api.settings.currentdash]);
            }
          });
        }
      });
      var grid = $('#' + id + ' .grid-stack .grid-stack-item');
      $.each(grid, function(item) {
        resizeWidget($(this));
      });
      dashexpert_api.fn.widgets.sparkline.redrawSparksBars();
    };
    var removeBasisBlacklist = function(basislist) { // expects array[]
      var blacklist = dashexpert_api.settings.basis_blacklist.split(',');
      var output = [];
      $.each(basislist, function(i) {
        if($.inArray(basislist[i],blacklist) === -1) {
          output.push(basislist[i]);
        }
      });
      return output;
    };
    var addSearchBasis = function(data) { 
      if(data !== undefined) {
        var searchFields = amplify.store('searchFields') || {};
        var fullbasisList = amplify.store('fullbasisList');
        var currentdash = dashexpert_api.settings.currentdash;
        if (typeof searchFields[currentdash] == "undefined" || !(searchFields[currentdash] instanceof Object)) {
            searchFields[currentdash] = {};
        }
        var basis = data.basis.split(',');
        dashexpert_api.util.debugOut('Basis before: ' + basis);
        basis = removeBasisBlacklist(basis);
        dashexpert_api.util.debugOut('Basis after: ' + basis);
        var inspector = 'inspector_' + data.inspector;
        $.each(basis, function(i,val) {
          if(val !== 'vhost' || val !== 'vmachine') {
            if(fullbasisList[inspector]) {
              var basisObj = fullbasisList[inspector][basis[i]];
              $.each(basisObj, function(k,v) {
                var id = basis[i] + '|' + k;
                if(!searchFields[currentdash].hasOwnProperty(basis[i])) {
                  searchFields[currentdash][id] = {};
                  searchFields[currentdash][id].basis = basis[i];
                  searchFields[currentdash][id].column = k;
                  searchFields[currentdash][id].column_name = v;
                  if(dashexpert_api.settings.hide_skipcolumns === true && dashexpert_api.settings.skipcolumns.indexOf(k) != -1) {
                    searchFields[currentdash][id].display = false;
                  } else {
                    searchFields[currentdash][id].display = true;
                  }
                }
              });
            }
          }   
        });
        amplify.store('searchFields',searchFields,{expires: dashexpert_api.settings.datacache});
        buildSearchFields(searchFields[currentdash], getSearchValues());
        $('input[id^="srch_"],select[id^="srch_"]').on('change focusout', function() {
          getSearchValues();
        });
      }
    };
    var getSearchValues = function() {
      var p = amplify.store('preferences') || {};
      var searchFields = amplify.store('searchFields') || {};
      var currentValues = amplify.store('searchValues') || {};
      currentValues.search = currentValues.search || {};
      if(!dashexpert_api.init.datePrefSet) {
        dashexpert_api.init.datePrefSet = true;
        $('#srch_date').val(p.defaultdate);
      }
      if($('#autoresolution').is(':checked') && $.isEmptyObject(currentValues.search)) {
        $('#srch_resolution').val('');
        delete currentValues.resolution;
      }
      var fields = $('input[data-column]');
      var fnew = false;
      $.each(fields, function(i) {
        var column = $(this).data('column');
        var basis = $(this).data('basis');
        var value = $(this).val();
        if(value) {
          currentValues.search[basis + '|' + column] = value;
          fnew = true;
        } else {
          delete currentValues.search[basis + '|' + column];
        }
      });
      // ADD Date and Time Range
      var srch_date = $('#srch_date').val();
      var srch_start_time = $('#srch_start_time').val();
      var srch_end_time = $('#srch_end_time').val();
      var srch_limit = $('#srch_limit').val();
      if(srch_date) {
        currentValues.date = srch_date;
      } else {
        delete currentValues.date;
      }
      if(srch_start_time > 0) {
        currentValues.start_time = srch_start_time;
      } else {
        delete currentValues.start_time;
      }
      if(srch_end_time < 23) {
        currentValues.end_time = srch_end_time;
      } else {
        delete currentValues.end_time;
      }
      if(srch_limit) {
        currentValues.limit = srch_limit;
      } else {
        delete currentValues.limit;
      }
      // END Date and Time Range
      // ADD Resolution
      var srch_resolution = $('#srch_resolution').val();
      if(srch_resolution) {
        currentValues.resolution = srch_resolution;
      }
      if($('#autoresolution').is(':checked') && !$.isEmptyObject(currentValues.search) && fnew) {
        currentValues = applyAutoSearchLogic(currentValues);
      }
      amplify.store('searchValues',currentValues,{expires: dashexpert_api.settings.datacache});
      amplify.store('searchFields',searchFields,{expires: dashexpert_api.settings.datacache});
      return currentValues;
    };
    var applyAutoSearchLogic = function(currentValues) {
      if(currentValues.date) {
        var cidlevel = ['15 minutes','30 minutes','1 hours','2 hours'];
        var hourlevel = ['today','4 hours','8 hours','12 hours','24 hours','yesterday'];
        if(cidlevel.indexOf(currentValues.date) != -1) {
          currentValues.resolution = 'CID';
          $('#srch_resolution option[value="CID"]').prop('selected',true);
        } else {
          currentValues.resolution = 'day';
          $('#srch_resolution option[value="day"]').prop('selected',true);
        }
        if(hourlevel.indexOf(currentValues.date) != -1) {
          currentValues.resolution = 'Day-Hour';
          $('#srch_resolution option[value="Day-Hour"]').prop('selected',true); 
        }
      }
      if(currentValues.start_time || currentValues.end_time) {
        var start_time = currentValues.start_time || 0;
        var end_time = currentValues.end_time || 23;
        if(end_time - start_time < 4) {
          currentValues.resolution = 'CID';
          $('#srch_resolution option[value="CID"]').prop('selected',true);
        } else {
          currentValues.resolution = 'Day-Hour';
          $('#srch_resolution option[value="Day-Hour"]').prop('selected',true);
        }
      }
      return currentValues;
    };
    var buildSearchFields = function(fields,svals) { // fields[array]
        $('#search-basis').empty(); // clear search fields
        var dashboards = amplify.store('dashboards');
        var formsHTML = '';
        var skipcolumns = dashexpert_api.settings.skipcolumns.split(',');
        if(dashexpert_api.settings.hide_skipcolumns) {
          $.each(fields, function(i) {
            if($.inArray(fields[i].column, skipcolumns) !== -1) {
              delete fields[i];
            }
          });
        }
        $.each(fields, function(key,val) {
            var initval = '';
            // clear overrides
            if(key in dashexpert_api.settings.current_dashoverrides) {
              delete dashexpert_api.settings.current_dashoverrides[key];
              delete svals.search[key];
            }
            if(svals.hasOwnProperty('search') && key in svals.search) {
              initval = svals.search[key];
            }
            // look for dash overrides and add
            if(dashboards[dashexpert_api.settings.currentdash].apistring !== '') {
              var j = dashboards[dashexpert_api.settings.currentdash].apistring;
              $.each(j, function(k,v) {
                if(key.endsWith(k)) {
                  initval = v;
                  dashexpert_api.settings.current_dashoverrides[key] = initval; 
                }
              });
            }
            if(initval) {
              formsHTML += '<div class="form-group has-success" data-title="' + fields[key].column_name + '">';
            } else {
              formsHTML += '<div class="form-group" data-title="' + fields[key].column_name + '">';
            }
            formsHTML += '<label class="control-label" for="srch_text_' + fields[key].basis + ':' + fields[key].column + '" data-toggle="tooltip" title="BASIS: ' + fields[key].basis + '">' + fields[key].column_name + '</label>';
            formsHTML += '<input name="srch_text_' + fields[key].basis + ':' + fields[key].column + '" id="srch_text_' + fields[key].basis + ':' + fields[key].column + '" data-basis="' + fields[key].basis + '" data-column="' + fields[key].column + '" value="' + initval + '" class="form-control input-sm" type="text" placeholder="Enter your search text" />';
            formsHTML += '</div>';
        });
        $('#search-basis').html('');
        $(formsHTML).appendTo($('#search-basis'));
        if(dashexpert_api.settings.searchSort) {
          reorderSearch();
        }
    };
    var addAPILimit = function(apistring) {
        var newAPIObj = JSON.parse(apistring);
        var limit = parseInt(newAPIObj.limit);
        if(limit === 0 || limit > dashexpert_api.settings.apilimit) {
            newAPIObj.limit = dashexpert_api.settings.apilimit;
        }
        apistring = JSON.stringify(newAPIObj);
        return apistring;
    };
    var addSearch = function(apistring,wid) {
        var newAPIObj = JSON.parse(apistring);
        var basis = newAPIObj.basis.split(',');
        var search = amplify.store('searchValues');
        var fields = amplify.store('searchFields');
        var widgets = amplify.store('widgets');
        var currentdash = dashexpert_api.settings.currentdash;
        if(!(wid in dashexpert_api.settings.searchMatch)) {
          dashexpert_api.settings.searchMatch[wid] = {};
        }
        //remove search items from restricted widgets
        if(dashexpert_api.widget_preferences[widgets[wid].type].hasOwnProperty('restrictSearch')) {
          $.each(dashexpert_api.widget_preferences[widgets[wid].type].restrictSearch, function(i) {
            delete search[dashexpert_api.widget_preferences[widgets[wid].type].restrictSearch[i]];
          });
        }
        $.each(search, function(key,val) {
          if(key != 'search') {
            newAPIObj[key] = val;
          }
        });
        $.each(fields[currentdash], function(k,v) {
          var b = fields[currentdash][k].basis;
          var c = fields[currentdash][k].column;
          if(basis.indexOf(b) > -1 && k in search.search) {
            var val = search.search[k];
            if(dashexpert_api.settings.wildsearch) {
              val = '*' + val + '*';
            }
            newAPIObj[c] = val;
            $('[data-column="' + c + '"]').parent().addClass('has-success');
            dashexpert_api.settings.searchMatch[wid][k] = true;
          } else {
            $('[data-column="' + c + '"]').parent().removeClass('has-success');
            dashexpert_api.settings.searchMatch[wid][k] = false;
          }
        });
        if(search.resolution && search.resolution !== 'All') { //auto trending logic
          newAPIObj.sort_col = 'end_date';
          newAPIObj.sort_order = '2';
        }
        apistring = JSON.stringify(newAPIObj);
        dashexpert_api.util.debugOut('Modified apistring from search');
        dashexpert_api.util.debugOut(apistring);
        return apistring;
    };
    var addOverrides = function(src,overrides,type) { // type: json|obj
      var t = type || 'obj';
      overrides = JSON.parse(overrides);
      if(t === 'json') {
        src = JSON.parse(src);
        //overrides = JSON.parse(overrides);
      }
      var output = src;
      $.each(src, function(k,v) { // override src values from overrides
        if(overrides.hasOwnProperty(k)) {
          output[k] = overrides[k];
        }
      });
      $.each(overrides, function(k,v) { // add unique values from overrides
        if(!(output.hasOwnProperty(k))) {
          output[k] = overrides[k];
        }
      });
      if(t === 'json') { 
        dashexpert_api.util.debugOut('OVERRIDES ADDED: ' + JSON.stringify(output));
        return JSON.stringify(output);
      } else {
        dashexpert_api.util.debugOut('OVERRIDES ADDED: ' + output);
        return output;
      }
    };
    var buildAPIString = function(wid) {
        var dash = amplify.store('dashboards');
        dash = dash[dashexpert_api.settings.currentdash];
        var datasources = amplify.store('datasources');
        var widgets = amplify.store('widgets');
        var search = amplify.store('searchValues') || { search: {} };
        var ds = widgets[wid].datasource;
        if(datasources[ds].apistring && ds) {
          var apistring = datasources[ds].apistring;
          if(widgets[wid].dcolumn !== undefined) {
              apistring.sort_col = widgets[wid].dcolumn;
          }
          if(widgets[wid].scolumn !== undefined){
            apistring.sort_col = widgets[wid].scolumn;
          }
          if(widgets[wid].sort_order !== undefined){
            apistring.sort_order = widgets[wid].sort_order;
          }
          if(widgets[wid].displaycols) { // add Display Columns
            apistring.columns = widgets[wid].displaycols;
          }
          if(widgets[wid].override === undefined) {
            widgets[wid].override = true;
          }
          // FIXING SANKEY COLUMNS
          if(typeof apistring.columns === 'string' || apistring.columns instanceof String) {
            apistring.columns = apistring.columns.split(',');
          }
          // if(widgets[wid].options.limit !== undefined){ //used in sankey but any other widgets can use this
          //   apistring.limit = widgets[wid].options.limit;
          // }
          if(widgets[wid].options.apistring && widgets[wid].override) {
            apistring = addOverrides(apistring,widgets[wid].options.apistring);
            if(JSON.parse(widgets[wid].options.apistring).hasOwnProperty('unbasis')) {
              apistring.unbasis = JSON.parse(widgets[wid].options.apistring).unbasis;
            }
          }
          if(dash.apistring) { // add dash overrides
            apistring = addOverrides(apistring,JSON.stringify(dash.apistring));
            if (typeof apistring.columns === 'string' || apistring.columns instanceof String) {
              apistring.columns = apistring.columns.split(',');
            }
            $.each(apistring.columns, function(k,v) {
              if(apistring[k]) {
                search.search[k] = v;
              }
            });
          }
          addSearchBasis(apistring);
          apistring = JSON.stringify(apistring);
          // Add API Limit
          apistring = addAPILimit(apistring);
          // Add any search parameters to APIstring
          apistring = addSearch(apistring,wid);
          if(!$.isEmptyObject(search.search)) {
            //apistring = addSearch(apistring,search);
            apistring = removeUnbasis(apistring,true);
          } else {
            apistring = removeUnbasis(apistring,false);
          }
          if(widgets[wid].options.apistring && widgets[wid].override && widgets[wid].locked) {
            apistring = addOverrides(JSON.parse(apistring),widgets[wid].options.apistring);
            apistring = JSON.stringify(apistring);
            $('[data-wid="' + wid + '"] h3.panel-title i.fa-lock').remove();
            $('[data-wid="' + wid + '"] h3.panel-title').append(' <i class="fa fa-lock" title="Widget is Locked"></i>');
            dashexpert_api.util.debugOut(widgets[wid].title + ' is locked.');
          }
          dashexpert_api.util.debugOut('Final APIstring');
          dashexpert_api.util.debugOut(apistring);
          return apistring;
        } else {
          return false;
        }
    };
    var removeUnbasis = function(apistring,searchOn) { // if searchOn is true, leave basis

      // if search get search fields(basis name) and values (user entered)
      // compare search fields with unbasis list from apistring
      // if they match, leave in unbasis if doesn't match remove
      // if no search, remove all unbasis from basis
      // 
      var result = JSON.parse(apistring);
      var orig = JSON.parse(apistring);
      var unbasis = result.unbasis || '';
      unbasis = unbasis.split(',');
      var basis = result.basis.split(',');
      if(result.unbasis) {
        //remove unbasis
        $.each(unbasis, function(i) {
          basis.splice($.inArray(unbasis[i], basis),1);
        });
      }
      if(searchOn && result.unbasis) {
        unbasis = [];
        var search = amplify.store('searchValues');
        search = search.search;
        // if search get search fields(basis name) and values (user entered)
        $.each(search, function(k,v) {
          var searchbasis = k.split('|');
          // compare search fields with unbasis list from apistring
          // remove from unbasis list;
          if($.inArray(searchbasis[0],basis) === -1) {
            basis.push(searchbasis[0]);
            result.columns.push(searchbasis[1]);
            unbasis.push(searchbasis[0]);
          }
        });
        result.unbasis = unbasis.toString();
      }
      result.basis = basis.toString();
      return JSON.stringify(result);
    };
    // STATUS FUNCTIONS
    var createRemoteStatus = function() {
        var updates = ['dashboards','widgets','datasources','data'];
        var status = {};
        var data = { lastUpdate : new Date().getTime() };
        $.each(updates, function(i,val) {
            if(dashexpert_api.settings.sessionAuthorized) {
                dashexpert_api.crud.create(data,val,'status');
                status[val] = true;
            }
            else {
                status[val] = false;
            }
        });
        return status;
    };
    var updateLastChangeLocal = function(type) {
        var status = amplify.store('status') || {};
        status[type] = new Date().getTime();
        amplify.store('status',status);
    };
    var updateLastChangeRemote = function(type) {
        var data = {};
        data.lastUpdate = new Date().getTime();
        dashexpert_api.crud.update(data,type,'status');
    };
    // CRUD FUNCTIONS
    // GET ALL
    var getAllDashboards = function(callback) { 
        dashexpert_api.crud.all('dashboard', function(r) {
            if(r === false) {
              dashexpert_api.settings.sessionAuthorized = false;
            }
            amplify.store('dashboards', r);
            updateLastChangeLocal('dashboards');
            dashexpert_api.util.debugOut(r);
            if(callback && typeof callback === 'function') {
                callback();
            }
        });
    };
    var getAllWidgets = function(callback) {
        dashexpert_api.crud.all('widget', function(r) {
            if(r === false) {
              dashexpert_api.settings.sessionAuthorized = false;
            }
            amplify.store('widgets', r);
            updateLastChangeLocal('widgets');
            dashexpert_api.init.widgets_loaded = true;
            dashexpert_api.util.debugOut(r);
            if(callback && typeof callback === 'function') {
                callback();
            }
        });
    };
    var getAllDatasources = function(callback) {
        dashexpert_api.crud.all('datasource', function(r) {
            if(r === false) {
              dashexpert_api.settings.sessionAuthorized = false;
            }
            amplify.store('datasources', r);
            updateLastChangeLocal('datasources');
            dashexpert_api.init.datasources_loaded = true;
            dashexpert_api.util.debugOut(r);
            if(callback && typeof callback === 'function') {
                callback();
            }
        });
    };
    // GET ONE
    var getDash = function(name) {
        dashexpert_api.crud.read(name,'dashboard', function(r) {
            var dashes = amplify.store('dashboards');
            dashes[name] = r;
            amplify.store('dashboards',dashes);
        });
    };
    var getWidget = function(name) {
        dashexpert_api.crud.read(name,'widgets', function(r) {
            var widgets = amplify.store('widgets');
            widgets[name] = r;
            amplify.store('widgets',widgets);
        });
    };
    var getDatasource = function(name) {
        dashexpert_api.crud.read(name,'datasource', function(r) {
            var ds = amplify.store('datasources');
            ds[name] = r;
            amplify.store('datasources',ds);
        });
    };
    // DELETE
    var deleteDash = function(name) {
        dashexpert_api.crud.delete(name,'dashboard',function(e) {
          if(e) {
            $('[aria-controls="' + name + '"]').parent().remove();
            $('#' + name).remove();
          }
        });
        //updateLastChangeRemote('dashboards');
    };
    var deleteWidget = function(name) {
        dashexpert_api.crud.delete(name,'widget');
        //updateLastChangeRemote('widgets');
    };
    var deleteDatasource = function(name) {
        dashexpert_api.crud.delete(name,'datasource');
        //updateLastChangeRemote('datasources');
    };
    // SAVE
    var duplicateItem = function(obj,type,callback) {
      var newid = new Date().getTime();
      var userinfo = amplify.store('userinfo');
      obj.id = type + '-' + newid;
      if(type === 'dashboard') {
        obj.name = obj.name + ' (copy)';
      } else {
        obj.title = obj.title + ' (copy)';
      }
      if(type === 'datasource') {
        obj.id = 'data-' + newid;
      }
      obj.header.lastupdated = newid;
      obj.header.creator = userinfo.name;
      obj.header.creatorid = userinfo.id;
      obj.header.owner = userinfo.name;
      obj.header.ownerid = userinfo.id;
      obj.system = false;
      switch(type) {
        case 'dashboard':
          obj = dashexpert_api.fn.import.updateVids(obj);
          saveDash(obj,obj.id,false,function(){
            createGSgrid('#view-dashboard',obj.id);
            reorderTabs();
          });
          break;
        case 'widget':
          saveWidget(obj,obj.id,false);
          break;
        case 'datasource':
          saveDatasource(obj,obj.id,false);
          break;
      }
      dashexpert_ui.util.createAlert('Duplication complete.','success','dup-alert');
      if(callback && typeof callback === 'function') {
          callback();
      }
    };
    var saveDash = function(data,name,overwrite,callback) {
      var pass = errorCheck(data,'dashboard');
      if(pass.passed) {
        if(typeof data.apistring !== 'object' && data.apistring !== '') {
          data.apistring = JSON.parse(data.apistring);
        }
        if(data.apistring) {
          data.apistring = checkAPIObject(data.apistring);
        }
        if(overwrite) {
            data.status = 'saved';
            dashexpert_api.crud.update(data,name,'dashboard',function(success) {
              if(success) {
                dashexpert_ui.util.createAlert('Saved Successfully.','success','crud-alert');
                if(callback && typeof callback === 'function') {
                    callback();
                }
                getAllDashboards();
              }
            });
        } else {
            data.status = 'saved';
            dashexpert_api.crud.create(data,name,'dashboard',function(success) {
              if(success) {
                dashexpert_ui.util.createAlert('Saved Successfully.','success','crud-alert');
                if(callback && typeof callback === 'function') {
                    callback();
                }
                getAllDashboards();
              }
            });
        }
        // var dashes = amplify.store('dashboards');
        // dashes[name] = data;
        // amplify.store('dashboards',dashes);
        //updateLastChangeRemote('dashboards');
      }
    };
    var saveWidget = function(data,name,overwrite) {
      var pass = errorCheck(data,'widget');
      if(pass.passed) {
        if(data.apistring) {
          data.apistring = checkAPIObject(data.apistring);
        }
        if(overwrite) {
            dashexpert_api.crud.update(data,name,'widget', function(s) {
              if(s) {
                dashexpert_ui.util.createAlert('Widget updated Successfully.','success','views-alert');
              } else {
                dashexpert_ui.util.createAlert('Widget update Failed.','danger','views-alert');
              }
            });
        } else {
            dashexpert_api.crud.create(data,name,'widget', function(s) {
              if(s) {
                dashexpert_ui.util.createAlert('Widget created Successfully.','success','views-alert');
              } else {
                dashexpert_ui.util.createAlert('Widget create Failed.','danger','views-alert');
              }
            });
        }
        getAllWidgets();
      }
    };
    var saveDatasource = function(data,name,overwrite) {
      var pass = errorCheck(data,'datasource');
      if(pass.passed) {
        if(typeof data.apistring !== 'object' && data.apistring !== '') {
          data.apistring = JSON.parse(data.apistring);
        }
        data.apistring = checkAPIObject(data.apistring);

        if(overwrite) {
            dashexpert_api.crud.update(data,name,'datasource', function(s) {
              if(s) {
                dashexpert_ui.util.createAlert('Datasource updated Successfully.','success','views-alert');
              } else {
                dashexpert_ui.util.createAlert('Datasource update Failed.','danger','views-alert');
              }
            });
        } else {
            dashexpert_api.crud.create(data,name,'datasource', function(s) {
              if(s) {
                dashexpert_ui.util.createAlert('Datasource created Successfully.','success','views-alert');
              } else {
                dashexpert_ui.util.createAlert('Datasource create Failed.','danger','views-alert');
              }
            });
        }
        getAllDatasources();
      }
    };
    var legacyCheck = function(widget) {
      var newwidget = widget;
      var useLegacy = dashexpert_api.settings.use_legacy_charts;
      if(widget.type === 'barchart' && !useLegacy) {
        newwidget.type = 'amchart_bar';
      }
      if(widget.type === 'amchart_bar' && useLegacy) {
        newwidget.type = 'barchart';
        newwidget.options.type = 'line';
      }
      if(widget.type === 'sparkline' && !useLegacy) {
        newwidget.type = 'amchart_line';
      }
      if(widget.type === 'amchart_line' && useLegacy) {
        newwidget.type = 'sparkline';
        newwidget.options.type = 'line';
      }
      return newwidget;
    };
    var getDashboardData = function(dashid,callback) {
        dashexpert_api.init[dashid] = {};
        var widgets = amplify.store('widgets');
        dashexpert_api.settings.lastDashUpdate = new Date().getTime();
        $('#lastdashupdate').remove();
        var updatetxt = 'Last Updated: ' + new Date(dashexpert_api.settings.lastDashUpdate).toLocaleTimeString();
        //$('ul.nav-main').append('<li id="lastdashupdate" title=""><a href="#">' + updatetxt + '</a></li>');
        $('#auto-refresh-setting label').attr('data-toggle', 'tooltip');
        $('#auto-refresh-setting label').attr('data-original-title',updatetxt);

        var grid = $('#' + dashexpert_api.settings.currentdash + ' .grid-stack .grid-stack-item');
        
        $.each(grid, function(i) {
            var vid = $('div:first', this).data('vid');
            var wid = $('div:first', this).data('wid');
            // if(wid.startsWith('multitable')) {
            //   wid = $(this).find('select').val();
            // }
            if(wid !== '') {
                var widget = widgets[wid];
                if(widget){
                  switch(widget.type) {
                    case 'info':
                      dashexpert_api.fn.widgets[widget.type].create(widget,vid);
                      dashexpert_api.util.debugOut('create ' + wid + ' in ' + vid);
                      break;
                    case 'html':
                      dashexpert_api.fn.widgets[widget.type].create(widget,vid);
                      dashexpert_api.util.debugOut('create ' + wid + ' in ' + vid);
                      break;
                    case 'multitable':
                      dashexpert_api.init[dashid][vid] = 'complete';
                      dashexpert_api.util.debugOut(vid + ' status ' + dashexpert_api.init[dashid][vid]);
                      dashexpert_api.fn.widgets[widget.type].create(widget,vid);
                      break;
                    default:
                      $('#widget_' + vid + ' .panel-body').html('<span id="loading_' + wid + '" class="label label-success"  style="display:block;margin-left: auto;margin-right: auto;font-size: 20px;"><i class="fa fa-spinner fa-spin"></i> Loading ...</span>');
                      retrieveData(wid,vid,function(){
                        dashexpert_api.init[dashid][vid] = 'complete';
                        dashexpert_api.util.debugOut(vid + ' status ' + dashexpert_api.init[dashid][vid]);
                        widget = legacyCheck(widget);
                        dashexpert_api.fn.widgets[widget.type].create(widget,vid);
                        //dashexpert_api.fn.widgets.sparkline.redrawSparksBars();
                      });
                      break;
                  }
                }
            }
        });
        
        if(callback && typeof callback === 'function') {
          callback();
        }
    };
    var retrieveData = function(wid,vid,callback) {
      if(!wid && vid !== 'preview') {
        return;
      }
      var loaddata = true;
      var apistring;
      var datasources = amplify.store('datasources');
      var widgets = amplify.store('widgets');
      var mtwid = $('[data-vid="' + vid + '"]').data('wid');
      if(vid.toString().endsWith('preview')) {
        widgets.preview = { type: widgets[wid].type};
        mtwid = 'preview';
      }
      if(widgets[mtwid].type === 'multitable' && widgets[wid].type === 'table') {
        var nwid = $('[data-vid="' + vid + '"] select :selected').val();
        //var nwid = widgets[mtwid].options.tables[0];
        var search = amplify.store('searchValues');
        apistring = buildAPIString(nwid);
      } else {
        if(vid !== 'preview' && vid !== 'dspreview') {
          // if(widgets[mtwid].type === 'multitable') {
          //   wid = widgets[wid].options.tables[0];
          // }
          apistring = buildAPIString(wid);
        } else {
          var ds;
          if(vid === 'dspreview') {
            ds = widgets[wid].datasource;
          } else {
            ds = $('#in-datasource :selected').val();
          }
          //widgets[wid].datasource = $('#in-datasource').val() || widgets[wid].datasource;
          apistring = JSON.stringify(datasources[ds].apistring);
          if($('#in-apistring').val() && $('#in-override').is(':checked')) {
            apistring = addOverrides(JSON.parse(apistring),$('#in-apistring').val());
            apistring = JSON.stringify(apistring);
          }
          apistring = removeUnbasis(apistring,false);
        }
      }
      dashexpert_api.util.debugOut(apistring);
      var dataid = btoa(apistring);
      var exists = false;
      if(widgets[mtwid].type !== 'multitable') {
        amplify.store('map_' + vid,dataid,{expires: dashexpert_api.settings.datacache});
        exists = dataExists(vid);
      } else {
        var mdata = amplify.store('map_' + vid) || {};
        if(widgets[wid].type !== 'multitable') {
          mdata[wid] = dataid;
          //amplify.store('map_' + vid,mdata,{expires: dashexpert_api.settings.datacache});
        }
        if(widgets[mtwid].type === 'multitable' && widgets[wid].type === 'table') {
          exists = dataExists(vid,{autoload:false,wid:wid});
        } else {
          exists = dataExists(vid,{autoload:false,wid:widgets[wid].options.tables[0]});
        }
        amplify.store('map_' + vid,mdata,{expires: dashexpert_api.settings.datacache});
      }
      if(exists) {
          loaddata = false;
      }
      var apiObj = JSON.parse(apistring);
      apiObj.show_col_desc = '1';
      apistring = JSON.stringify(apiObj);
      if(dashexpert_api.ssid && !dashexpert_api.nossid) {
        apistring = 'ssid=' + dashexpert_api.ssid + '&json=' + apistring;
      }
      if(dashexpert_api.nossid) {
        apistring = 'json=' + apistring;
      }
      if(loaddata) {
          var qname = getCurrentQue();
          $.ajaxq(qname,{
              type: 'POST',
              beforeSend: function()
              {
                  $('#widget_' + vid + ' .panel-body').html('<span id="loading_' + wid + '" class="label label-success"  style="display:block;margin-left: auto;margin-right: auto;font-size: 20px;"><i class="fa fa-spinner fa-spin"></i> Loading ...</span>');
                  $('#loadingmsg').text('Loading Widget [' + widgets[wid].title + ']');
                  $('#loadingmsg').show();
              },
              success: function(data)
              {
                  $('#loadingmsg').hide();
                  $('#loadingmsg').empty();
                  $('#loading_' + wid).hide();
              },
              processData: false,
              crossDomain: true,
              cache: true,
              data: apistring,
              dataType: 'text',
              url: dashexpert_api.settings.apiurl
          }).done(function(data, textStatus, jqXHR){
              var valid = true;
              var result;
              //debugOut(data);
              //debugOut(JSON.stringify(apistring));
              try {
                  result = fixJSON(data);
                  result = JSON.parse(result);
              }
              catch(e) {
                  if(data.indexOf('Not Authorized') != -1) {
                      dashexpert_ui.util.createAlert('Not Authorized. API access not allowed from the client IP Address (' + dashexpert_api.settings.clientip + ')','danger','previewerror');
                  } else {
                      dashexpert_ui.util.createAlert('Invalid JSON Response from server','danger','previewerror');
                      valid = false;
                  }
              }
              if(result.hasOwnProperty('table') && valid) {
                  if($.isEmptyObject(result.table[0])) {
                      $('#widget_' + vid + ' .panel-body').empty();
                      dashexpert_ui.util.createAlert('No Data returned.  Try increasing your Date Range.','warning','previewerror_' + vid,'#widget_' + vid + ' .panel-body',true);
                  }
              }
              
              if(result && valid && !$.isEmptyObject(result.table[0])) {
                  if(result.columns === undefined) {
                      result.columns = apiObj.sort_col;
                  }
                  var adata = { 
                      inspector : result.inspector_id,
                      table : result.table,
                      xref : result.xref, 
                      basis : result.basis,
                      basis_columns : result.basis_columns,
                      columns : result.columns,
                      api_call_time : new Date(result.timestamp_now).getTime()
                  };
                  //var t0 = performance.now();
                  addXref(result.xref);
                  addColumnDesc(result.column_desc);
                  //var t1 = performance.now();
                  //console.log("Call to addXref took " + (t1 - t0) + " milliseconds.");
                  try {
                    amplify.store(dataid,adata,{expires: dashexpert_api.settings.datacache});
                    if(widgets[wid].type !== 'multitable' && widgets[mtwid].type !== 'multitable') {
                      amplify.store('map_' + vid,dataid,{expires: dashexpert_api.settings.datacache});
                    } else {
                      var mdata = amplify.store('map_' + vid) || {};
                      if(widgets[wid].type === 'table') {
                        mdata[wid] = dataid;
                      } else {
                        mdata[widgets[wid].options.tables[0]] = dataid;
                      }
                      amplify.store('map_' + vid,mdata,{expires: dashexpert_api.settings.datacache});
                    }
                  } catch ( error) {
                    dashexpert_api.util.debugOut(error);
                    amplify.clearStore('data');
                    try {
                      amplify.store(dataid,adata,{expires: dashexpert_api.settings.datacache});
                      if(widgets[wid].type !== 'multitable' && widgets[mtwid].type !== 'multitable') {
                        amplify.store('map_' + vid,dataid,{expires: dashexpert_api.settings.datacache});
                      } else {
                        var mdata = amplify.store('map_' + vid) || {};
                        if(widgets[wid].type === 'table') {
                          mdata[wid] = dataid;
                        } else {
                          mdata[widgets[wid].options.tables[0]] = dataid;
                        }
                        amplify.store('map_' + vid,mdata,{expires: dashexpert_api.settings.datacache});
                      }
                    } catch (e) {
                      dashexpert_api.util.debugOut(e);
                    }
                  }
                  if(callback && typeof callback === 'function') {
                      callback(vid);
                  }
              }
          }).fail(function(jqXHR,textStatus,errorThrown){
              dashexpert_api.util.debugOut(textStatus + ' | ' + errorThrown);
          }); 
      } else {
          addSearchBasis(amplify.store(dataid));
          if(callback && typeof callback === 'function') {
              callback(vid);
          }
      }
    };
    var addXref = function(xref) {
      var d = amplify.store('xref') || {};
      $.each(xref, function(key,val) {
        if(!d.hasOwnProperty(key)) {
          d[key] = val;
        }
      });
      amplify.store('xref', d);
    };
    var addColumnDesc = function(column_desc) {
      var c = amplify.store('column_desc') || {};
      $.each(column_desc, function(key,val) {
        if(!c.hasOwnProperty(key)) {
          c[key] = val;
        }
      });
      amplify.store('column_desc', c);
    };
    var dataExists = function(vid,opt) {
        var options = opt || {autoload:false};
        var data = amplify.store();
        var exists = false;
        $.each(data, function(key,val) {
          if(key === 'map_' + vid && typeof data[key] === 'object') {
            $.each(data[key], function(k,v) {
              if(options.hasOwnProperty('wid')) {
                if(k === options.wid && data[data[key][options.wid]]) {
                  exists = true;
                }
              }
            });
          } else {
            if(key === 'map_' + vid && data.hasOwnProperty(val)) {
                exists = true;
            }
          }
          if(vid.toString().endsWith('preview')) {
            exists = false;
          }
        });
        return exists;
    };
    function getBasisList(callback) {
      var loaddata = false;
      var fullbasisList = amplify.store('fullbasisList') || {};
      if($.isEmptyObject(fullbasisList)) {
        loaddata = true;
      }
      apistring = '{"api":{"command":"get_list"}}';
      if(dashexpert_api.ssid && !dashexpert_api.nossid) {
        apistring = 'ssid=' + dashexpert_api.ssid + '&json=' + apistring;
      }
      if(dashexpert_api.nossid) {
        apistring = 'json=' + apistring;
      }
      if(loaddata) {
        $.ajax({
            type: 'POST',
            beforeSend: function()
            {
                $('#loadingmsg').html('<i class="fa fa-spinner fa-spin"></i> Loading Basis ...');
                $('#loadingmsg').fadeIn();
            },
            success: function(data)
            {
                $('#loadingmsg').fadeOut();
            },
            processData: false,
            crossDomain: true,
            cache: true,
            data: apistring,
            dataType: 'text',
            url: dashexpert_api.settings.apiurl
        }).done(function(data, textStatus, jqXHR){
                var result;
                result = fixJSON(data);
                result = JSON.parse(result);
                createBasisColumns(result);
                if(callback && typeof callback === 'function') {
                    callback(status);
                }
            }).fail(function(jqXHR,textStatus,errorThrown){
                dashexpert_api.util.debugOut('getBasisList Errors',textStatus + ' | ' + errorThrown);
        });
      } 
      else {
        if(callback && typeof callback === 'function') {
            callback(status);
        }
      }
    }
    function createBasisColumns(obj) {
      var basisList = {};
      var basisNames = {};
        $.each(obj.basis_names, function(key,val) {
            basisList['inspector_' + key] = {};
            basisNames[key] = val;
        });
        $.each(obj.basis_list, function(key,value) {
            var keyArray = key.split("|");
            var inspector = keyArray[0];
            var basis = keyArray[1];
            var name = keyArray[2];
            basisList['inspector_' + inspector][basis] = value;
        });
        amplify.store('fullbasisList', basisList, {expires: dashexpert_api.settings.datacache*72});
        amplify.store('fullbasisNames', basisNames, {expires: dashexpert_api.settings.datacache*72});
        dashexpert_api.init.basisList_loaded = true;
    }
    var clearLocalData = function() {
        var data = amplify.store();
        $.each(data, function(key) {
            if(key.startsWith('map_') || key.startsWith('eyJ')) {
                amplify.store(key,{},{expires: 10});
            }
        });
    };
    var reorderObject = function(d) { 
      var objArray = [];
      $.each(d, function(k) {
        objArray.push(d[k]);
      });
      function compare(a,b) {
        const sortA = parseFloat(a.sort_order);
        const sortB = parseFloat(b.sort_order);
        let comparison = 0;
        if(sortA > sortB) {
          comparison = 1;
        } else if (sortA < sortB) {
          comparison = -1;
        }
        return comparison;
      }
      var result = [];
      var sorted =  objArray.sort(compare);
      $.each(sorted, function(i) {
        result.push(sorted[i].id);
      });
      return result;
    };
    var reorderTabs = function(target) {
      target = target || '#dashboard-tabs';
      var list = $(target + ' li');
      function sortTabs(a,b) {
        return (parseFloat($(b).data('sort'))) < parseFloat(($(a).data('sort'))) ? 1 : -1;
      }
      list.sort(sortTabs).appendTo(target);
      $('#dashboard-tabs').scrollingTabs('refresh');
    };
    var reorderSearch = function(target) {
      target = target || '#search-basis';
      var list = $(target + ' .form-group');
      function sortTabs(a,b) {
        return ($(b).data('title').toLowerCase() < $(a).data('title').toLowerCase()) ? 1 : -1;
      }
      list.sort(sortTabs).appendTo(target);
    };
    var removePermissions = function(data) {
      try {
        if(data.hasOwnProperty('groups')) {
          delete data.groups;
        }
        if(data.hasOwnProperty('owner')) {
          delete data.owner;
        }
        if(data.hasOwnProperty('header')) {
          delete data.header.owner;
          delete data.header.ownerid;
          delete data.header.groups;
        }
      } catch(err) {
        dashexpert_api.util.debugOut(err);
      }
      return data;
    };
    var exportDashboard = function (id) {
      var tstamp = new Date().getTime();
      var w = amplify.store('widgets');
      var widgets = {};
      var d = amplify.store('dashboards');
      var datasources = {};
      var ds = amplify.store('datasources');
      // widgets
      $.each(d[id].grid, function(key,val) {
        if(val.wid) {
          if(!widgets[val.wid]) {
            widgets[val.wid] = w[val.wid];
            if(val.wid.startsWith('multitable')) {
              $.each(w[val.wid].options.tables, function(i,v) {
                if(!widgets[v]) {
                  widgets[v] = w[v];
                }
              });
            }
          }
        }
      });
      // datasources
      $.each(d[id].grid, function(key,val) {
        if(val.wid) {
          if(val.wid.startsWith('multitable')) {
            $.each(w[val.wid].options.tables, function(i,v) {
                datasources[w[v].datasource] = ds[w[v].datasource];
            });
          } else {
            if(w[val.wid].datasource !== undefined) {
              datasources[w[val.wid].datasource] = ds[w[val.wid].datasource];
            }
          }
        }
      });
      var exportdata = {};
      exportdata.dashboards = {};
      exportdata.dashboards[id] = removePermissions(d[id]);
      exportdata.dashboards[id].grid = d[id].grid;
      exportdata.dashboards[id].system = JSON.parse(exportdata.dashboards[id].system);
      exportdata.widgets = widgets;
      $.each(exportdata.widgets, function(k) {
        exportdata.widgets[k] = removePermissions(exportdata.widgets[k]);
      });
      exportdata.datasources = datasources;
      $.each(exportdata.datasources, function(k) {
        exportdata.datasources[k] = removePermissions(exportdata.datasources[k]);
      });
      var generateFile = function (json) {
        var jsonFile = null;
        var data = new Blob([json], {type: 'application/json'});
        // If we are replacing a previously generated file we need to
        // manually revoke the object URL to avoid memory leaks.
        if (jsonFile !== null) {
          window.URL.revokeObjectURL(jsonFile);
        }
        jsonFile = window.URL.createObjectURL(data);
        var element = document.createElement('a');
        element.setAttribute('href', jsonFile);
        element.setAttribute('download', 'dashboard-' + tstamp + '.json');
        element.style.display = 'none';
        document.body.appendChild(element);
        element.click();
        document.body.removeChild(element);
      };
      generateFile(JSON.stringify(exportdata, undefined, 4));
    };
    var createGSgrid = function(target,dashID,callback,options) {
      // grid functions START
      this.addGrid = function() {
        $('#dashboard-tabs li:last-child').before('<li role="presentation" data-sort="' + dashboard.sort_order + '"><a href="#' + dashID + '" aria-controls="' + dashID + '" data-gridid="' + gridid + '" role="tab" data-toggle="tab">' + name + '</a></li>');
        var btns = '<div role="tabpanel" class="tab-pane" id="' + dashID + '"><div class="grid-stack" id="' + gridid + '"></div>\n<div class="grid-controls" data-acl="admin" data-gridname="' + gridid + '">\n\t';
        btns += '<a class="btn btn-default" data-function="add-widget" href="#">Add widget</a>\n\t<a class="btn btn-primary" data-function="edit-grid" href="#">Edit Dashboard</a>\n\t<a class="btn btn-success" data-function="save-grid" href="#">Save Dashboard</a>\n\t';
        btns += '<a class="btn btn-default" data-function="clear-grid" href="#">Clear Dashboard</a>\n\t<a class="btn btn-danger" data-function="delete-grid" href="#">Delete Dashboard</a>\n\t';
        btns += '<a class="btn btn-warning" data-function="export-dash" href="#">Export Dashboard</a>\n\n\t<!--<a class="btn btn-info" data-function="import-dash" href="#">Import Dashboard</a>-->\n</div></div></div>';
        $(target + ' #view-dashboard-display').append(btns);
        $('#' + dashID + ' [data-function^="export-dash"]').hide();
        //$('a[href="#' + dashID + '"]').tab('show');
      };
      this.loadGrid = function () {
          this.grid.removeAll();
          var widgets = amplify.store('widgets');
          var items = GridStackUI.Utils.sort(this.serializedData);
          _.each(items, function (node) {
            if(widgets[node.wid] === undefined) {
              node.wid = '';
            }
              //this.grid.addWidget($('<div><div class="grid-stack-item-content" data-vid="' + new Date().getTime() + '" data-wid="' + node.wid + '" /><div/>'),
              this.grid.addWidget($('<div><div class="grid-stack-item-content" data-vid="' + node.vid + '" data-wid="' + node.wid + '" /><div/>'),
                  node.x, node.y, node.width, node.height);
          }, this);
          return false;
      }.bind(this);
      this.buildDropdown = function () {
        var menuitems = '<li><div class="checkbox"><label><input type="checkbox"> Lock Widget</label></div></li>';
        menuitems += '<li><div class="checkbox"><label><input type="checkbox"> Lock Data</label></div></li>';
        var d = '<span class="dropdown"><a href="#" data-target="#" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false"><i class="fa fa-chevron-circle-down" aria-hidden="true"></i></a><ul class="dropdown-menu dropdown-menu-right">' + menuitems + '</ul></span>';
        return d;
      }.bind(this);
      this.loadWidgets = function () {
        var html,items = $('.grid-stack-item-content');
        $.each(items, function(el) {
          var vid = $(items[el]).data('vid');
          var wid = $(items[el]).data('wid');
          //var panel = '<span class="pull-right"><i class="fa fa-search" aria-hidden="true"></i> <i class="fa fa-trash" aria-hidden="true"></i> <a href="#widget-select-modal" data-toggle="modal"><i class="fa fa-cog" data-vid="' + vid + '" aria-hidden="true"></i></a> ' + buildDropdown() + '</span>';
          var panel = '<span class="pull-right" data-acl="admin"><a href=""><i class="fa fa-trash" aria-hidden="true" data-toggle="tooltip" data-placement="top" title="Delete Widget"></i></a> <a href="#widget-select-modal" data-toggle="modal"><i class="fa fa-cog" data-vid="' + vid + '" aria-hidden="true" data-toggle="tooltip" data-placement="top" title="Assign Widget"></i></a> <a href="#widget-info-modal" data-toggle="modal"><i class="fa fa-info-circle" data-wid="' + wid + '" data-apistring="" aria-hidden="true" data-toggle="tooltip" data-placement="top" title="Widget Info"></i></a></span>';
          html = '<div class="panel panel-default" id="widget_' + vid + '"><div class="panel-heading">' + panel + '<h3 class="panel-title"><span>' + vid + '</span></h3></div>';
          html += '<div class="panel-body"><i class="fa fa-long-arrow-up" aria-hidden="true"></i> click the gear icon above to assign a widget.</div></div>';
          $(items[el]).html(html);
          //$('.panel-heading [data-toggle="tooltip"]').tooltip({container: 'body', placement: 'auto'});
          resizeWidget('.grid-stack-item-content[data-vid="' + vid + '"]');
          if(wid) {
            //$(items[el]).children().children('.panel-body').empty();
            $(items[el]).children().children('.panel-body').html('<span id="loading_' + wid + '" class="label label-success"  style="display:block;margin-left: auto;margin-right: auto;font-size: 20px;"><i class="fa fa-spinner fa-spin"></i> Loading ...</span>');
            assignWidget(vid,wid);
          }
        });
        //showAdmin();
      }.bind(this);
      this.addWidget = function(id) {
        this.grid = $('#' + id).data('gridstack');
        var html,vid = new Date().getTime();
        this.grid.addWidget($('<div><div class="grid-stack-item-content" data-vid="' + vid + '" data-wid="" /><div/>'),
                  0, 0, 2, 1, true);
        var panel = '<span class="pull-right" data-acl="admin"><a href=""><i class="fa fa-trash" aria-hidden="true" data-toggle="tooltip" data-placement="top" title="Delete Widget"></i></a> <a href="#widget-select-modal" data-toggle="modal"><i class="fa fa-cog" data-vid="' + vid + '" aria-hidden="true" data-toggle="tooltip" data-placement="top" title="Assign Widget"></i></a> <a href="#widget-info-modal" data-toggle="modal"><i class="fa fa-info-circle" data-wid="" data-apistring="" aria-hidden="true" data-toggle="tooltip" data-placement="top" title="Widget Info"></i></a></span>';
        html = '<div class="panel panel-default" id="widget_' + vid + '"><div class="panel-heading">' + panel + '<h3 class="panel-title"><span>' + vid + '</span></h3></div>';
        html += '<div class="panel-body"><i class="fa fa-long-arrow-up" aria-hidden="true"></i> click the gear icon above to assign a widget.</div></div>';
        $('.grid-stack-item-content[data-vid="' + vid + '"]').html(html);
        resizeWidget('.grid-stack-item-content[data-vid="' + vid + '"]');
      }.bind(this);
      this.assignWidget = function(vid,wid) {
        var widgets = amplify.store('widgets');
        if(widgets[wid] !== undefined) {
          $('#widget_' + vid).parent().attr('data-wid', wid);
          $('#widget_' + vid).parent().data('wid', wid);
          $('#widget_' + vid + ' h3.panel-title span:first').html(widgets[wid].title);
          if(widgets[wid].type == 'info') {
            $('#widget_' + vid + ' .panel').addClass('widget-info');
            dashexpert_api.fn.widgets.info.create(widgets[wid],vid);
          } else {
            //dashexpert_api.fn.widgets.getGridstackWidgetData(vid,wid);
          }
        }
      }.bind(this);
      this.saveGrid = function (snapshot,options) {
          var tstamp = new Date().getTime();
          var snapshot = snapshot || false;
          var options = options || {name: 'Default Dashboard',description: 'This is the default dashboard',system: false,display: true,sort_order: 100,exported: tstamp,status: 'new'};
          this.serializedData = _.map($('.grid-stack > .grid-stack-item:visible'), function (el) {
              el = $(el);
              var node = el.data('_gridstack_node');
              var vid = $(el).find('.grid-stack-item-content').data('vid');
              var wid = $(el).find('.grid-stack-item-content').data('wid');
              return {
                  x: node.x,
                  y: node.y,
                  width: node.width,
                  height: node.height,
                  vid: vid,
                  wid: wid
              };
          }, this);
          this.getWidgets = function () {
            var widgets = {};
            var allwidgets = amplify.store('widgets');
            $.each(this.serializedData, function(key,val) {
              if(val.wid) {
                if(!widgets[val.wid]) {
                  widgets[val.wid] = allwidgets[val.wid];
                  if(val.wid.startsWith('multitable')) {
                    $.each(allwidgets[val.wid].options.tables, function(i,v) {
                      if(!widgets[v]) {
                        widgets[v] = allwidgets[v];
                      }
                    });
                  }
                }
                
              }
            });
            return widgets;
          }.bind(this);
          this.getDatasources = function () {
            var datasources = {};
            var alldata = amplify.store('datasources');
            var allwidgets = amplify.store('widgets');
            $.each(this.serializedData, function(key,val) {
              if(val.wid) {
                if(val.wid.startsWith('multitable')) {
                  $.each(allwidgets[val.wid].options.tables, function(i,v) {
                      datasources[allwidgets[v].datasource] = alldata[allwidgets[v].datasource];
                  });
                } else {
                  if(allwidgets[val.wid].datasource) {
                    datasources[allwidgets[val.wid].datasource] = alldata[allwidgets[val.wid].datasource];
                  }
                }
              }
            });
            return datasources;
          }.bind(this);
          var exportdata = {};
          exportdata.dashboards = {};
          if(snapshot) {
            exportdata.dashboards[options.id] = removePermissions(options);
          } else {
            exportdata.dashboards[options.id] = options;
          }
          exportdata.dashboards[options.id].grid = this.serializedData;
          var dashboards = amplify.store('dashboards');
          exportdata.dashboards[options.id].system = JSON.parse(exportdata.dashboards[options.id].system);
          dashboards[options.id] = exportdata.dashboards[options.id];
          amplify.store('dashboards', dashboards);
          exportdata.widgets = this.getWidgets();
          $.each(exportdata.widgets, function(k) {
            exportdata.widgets[k] = removePermissions(exportdata.widgets[k]);
          });
          exportdata.datasources = this.getDatasources();
          $.each(exportdata.datasources, function(k) {
            exportdata.datasources[k] = removePermissions(exportdata.datasources[k]);
          });
          dashexpert_api.settings.currentgrid = exportdata.dashboards[options.id].grid;
          $('.btn[data-function^="export-dash"]').attr('download', 'dashboard-' + tstamp + '.json');
          this.generateFile(JSON.stringify(exportdata, undefined, 4));
          return exportdata;
      }.bind(this);
      this.generateFile = function (json) {
        var jsonFile = null,
          makeTextFile = function (content) {
            var data = new Blob([content], {type: 'application/json'});
            // If we are replacing a previously generated file we need to
            // manually revoke the object URL to avoid memory leaks.
            if (jsonFile !== null) {
              window.URL.revokeObjectURL(jsonFile);
            }
            jsonFile = window.URL.createObjectURL(data);
            return jsonFile;
          };
          $('.btn[data-function^="export-dash"]').attr('href', makeTextFile(json));
          $('.btn[data-function^="export-dash"]').show();
      }.bind(this);
      this.clearGrid = function () {
          this.grid.removeAll();
          return false;
      }.bind(this);
      this.removeItem = function(el) {
          this.grid.removeWidget(el);
          return false;
      }.bind(this);
      // grid functions END
      var dashboard;
      var dashboards = amplify.store('dashboards');
      var dashnew = false;
      if(dashID === '_new') {
        dashnew = true;
        dashboard = dashexpert_api.defaultdash.newgrid;
        dashID = 'dashboard-' + new Date().getTime();
        dashboard.name = dashID;
        dashboard.id = dashID;
        dashboards[dashID] = dashboard;
        dashboard.status = 'new';
        dashboard.header = {};
        amplify.store('dashboards',dashboards);
        dashexpert_api.settings.currentdash = dashID;
      } else {
        dashboard = dashboards[dashID];
      }
      var gridid = dashID + '-grid';
      var options = options || {};
      var name = dashboard.name;
      options.cellHeight = dashexpert_api.settings.dashGridHeight;
      options.draggable = {
          handle: '.panel-heading'
      };
      this.addGrid();
      $('#' + gridid).gridstack(options);
      this.serializedData = dashboard.grid;
      this.grid = $('#' + gridid).data('gridstack');
      //$('a[href="#' + dashID + '"]').tab('show');

      this.loadGrid();
      this.loadWidgets();
      //dashexpert_api.util.debugOut('DASHID ---->' + dashID);
      // grid events START
      $('#' + dashID + ' .grid-stack').on('change', function(event, items) {
        dashexpert_api.settings.currentdash = $(this).parent().prop('id');
        var grid = $('#' + dashexpert_api.settings.currentdash + ' .grid-stack .grid-stack-item');
        $.each(grid, function(item) {
          resizeWidget($(this));
        });
        dashexpert_api.fn.widgets.sparkline.redrawSparksBars();

      });
      $('#' + dashID + ' .grid-stack-item').on('resizestop', function(event, items) {
        dashexpert_api.util.debugOut('resized grid');
        var widgets = amplify.store('widgets');
        var vid = $(this).children('.grid-stack-item-content').data('vid');
        var wid = $(this).children('.grid-stack-item-content').data('wid');
        if(wid !== '') {
          var apistring = atob(amplify.store('map_' + vid)); //get APIString
          var data = amplify.store(btoa(apistring));
          if(data !== undefined) {
            var type = widgets[wid].type;
            var widget = legacyCheck(widgets[wid]);
            dashexpert_api.fn.widgets[widget.type].create(widget,vid);
          }
        }
      });
      $('#' + dashID).on('click.dashControl', '.btn[data-function]', function(e) {
        var fn = $(this).data('function');
        dashexpert_api.util.debugOut(fn);
        var dash = $('#dashboard-tabs li.active a').attr('aria-controls');
        var grid = $('#dashboard-tabs li.active a').data('gridid');
        var dashboards = amplify.store('dashboards');
        switch(fn) {
          case 'add-widget':
            e.preventDefault();
            addWidget(gridid);
            break;
          case 'clear-grid':
            e.preventDefault();
            var r = confirm('Are you sure you want to clear this dashboard? (This will not delete the widgets)');
            if(r) {
              //clearGrid(gridid);
              $('#' + gridid).attr('style','height: 0px;').empty();
              $('#' + gridid).gridstack();
            }
            break;
          case 'edit-grid':
            e.preventDefault();
            if(JSON.parse(dashboards[dash].system) === true && dashexpert_api.settings.system_readonly === true) {
              dashexpert_ui.util.createAlert('System Dashboards protected.','warning','views-alert');
            } else {
              createDashboardForm(dash);
              if(dash) { 
                saveGrid(false,dashboards[dash]);
              }
              else { saveGrid(); }
              $('#save-dashboard-modal').modal('show');
            }
            break;
          case 'save-grid':
            e.preventDefault();
            if(JSON.parse(dashboards[dash].system) === true && dashexpert_api.settings.system_readonly === true) {
              dashexpert_ui.util.createAlert('System Dashboards protected.','warning','views-alert');
            } else {
              dashboards[dash].lastsave = dashboards[dash].header.lastupdated;
              if(dash) { 
                saveGrid(false,dashboards[dash]);
                saveDash(dashboards[dash],dashboards[dash].id,true);
              }
              else { saveGrid(); }
            }
            break;
          case 'delete-grid':
            e.preventDefault();
            if(JSON.parse(dashboards[dash].system) === true && dashexpert_api.settings.system_readonly === true) {
              dashexpert_ui.util.createAlert('System Dashboards protected.','warning','views-alert');
            } else {
              var title = dashboards[dash].name;
              var r = confirm('Are you sure you want to delete ' + title + '? (This will not delete the widgets)');
              if(r) {
                deleteDash(dash);
                $('[aria-controls="' + dash + '"]').parent().remove();
                $('#' + dash).remove();
                delete dashboards[dash];
                amplify.store('dashboards',dashboards);
              }
            }
            break;
          case 'export-dash':
            saveGrid(true,dashboards[dash]);
            break;
          case 'import-dash':
            dashexpert_api.fn.import.importFile();
            break;
          case 'export-dash-full':
            saveGrid(true);
            break;
        }
      });
      $('#' + dashID).on('click.deleteWidget', '.fa-trash', function(e) {
          e.preventDefault();
          $(this).tooltip('hide');
          var widget = $(this).closest('.grid-stack-item');
          var r = confirm('Are you sure you want to remove widget [' + widget.children('.grid-stack-item-content').data('vid') + '] ' + widget.children('.grid-stack-item-content').find('h3.panel-title span:first').text());
          if(r) {
            removeItem(widget);
          }
      });
      // grid events END
      if(callback && typeof callback === 'function') {
          callback(dashID);
      }
    };
    var resizeWidget = function(vid) {
      var wid = $(vid).find('.grid-stack-item-content').data('wid');
      var adjustment = 43; //based on 10px padding
      if(wid) {
        if(wid.startsWith('table') || wid.startsWith('multitable')) {
          adjustment = adjustment + 13;
        }
      }
      var currentHeight = $(vid).height();
      var titlebar = $(vid).find('.panel-heading').height();
      $(vid).find('.panel-body').height((currentHeight - titlebar) - adjustment);
    };
    var getMaxWidth = function(source) {
      var maxWidth = $(source).width();
      maxWidth = Math.floor((maxWidth / maxColumns) - (wmargins * 2));
      return maxWidth;
    };
    var clone = function(obj) {
      var copy;

      // Handle the 3 simple types, and null or undefined
      if (null == obj || "object" != typeof obj) return obj;

      // Handle Date
      if (obj instanceof Date) {
        copy = new Date();
        copy.setTime(obj.getTime());
        return copy;
      }

      // Handle Array
      if (obj instanceof Array) {
        copy = [];
        for (var i = 0, len = obj.length; i < len; i++) {
          copy[i] = clone(obj[i]);
        }
        return copy;
      }

      // Handle Object
      if (obj instanceof Object) {
        copy = {};
        for (var attr in obj) {
          if (obj.hasOwnProperty(attr)) copy[attr] = clone(obj[attr]);
        }
        return copy;
      }

      throw new Error("Unable to copy obj! Its type isn't supported.");
    };
    var buildWidgetDropdown = function() {
      var widgets = amplify.store('widgets');
      var target = '#widget-selector-dropdown';
      $(target).empty();
      $('#widget-select-preview .panel-body').empty();
      var lastupdated;
      $.each(widgets, function(key) {
        lastupdated = new Date(widgets[key].header.lastupdated).toLocaleDateString("en-US");
        $(target).append('<option value="' + key + '" data-widgettype="' + widgets[key].type + '">[' + dashexpert_api.widgets.xref[widgets[key].type] + '] ' + widgets[key].title + ' | last updated by: ' + widgets[key].header.owner + ' on ' + lastupdated + '</option>');
      });
      $(target).html($(target + ' option').sort(function(a,b) {
        return a.text == b.text ? 0 : a.text < b.text ? -1 : 1;
      }));
    };
    var buildWidgetSelector = function(target) {
      var widgets = amplify.store('widgets');
      var t = target || '#widget-selector-dropdown';
      $(t).html('<input id="in-widget-select-input" value="">');
      var inopts = { 
        data: [],
        fields: [
          {name: 'type',text: 'Type'},
          {name: 'text',text: 'Title'},
          {name: 'modifiedby',text: 'Modified By'},
          {name: 'lastmodified',text: 'Last Modified'},
        ],
        width: '300%',
        height: '500px',
        autoOpen: true,
        headShow: true,
        fieldText : 'title',
        fieldValue: 'value'
      };
      $.each(widgets, function(key) {
        inopts.data.push({
          value: key, 
          text: widgets[key].title, 
          type: widgets[key].type,
          modifiedby: widgets[key].header.owner,
          lastmodified: widgets[key].header.lastupdated
        });
      });
      $('#in-widget-select-input').inputpicker(inopts);
    };
    var loadWidgetModal = function() {
      $('#widget-select-container').empty();
      $('#widget-build-container').empty();
      $('#widget-datasource-container').empty();

      $('#widget-select-container').load('html/widget-select-container.html', function() {
        buildWidgetDropdown();
        //buildWidgetSelector();
        var useLegacy = dashexpert_api.settings.use_legacy_charts;

        $.each(dashexpert_api.widgets.types.sort(), function(i,v) {
          if((!useLegacy && v !== 'amchart_bar') && (!useLegacy && v !== 'amchart_line')) {
            $('#widget-type-select').append('<button type="button" class="btn btn-default" data-widgettype="' + v + '"><i class="fa ' + dashexpert_api.widget_preferences[v].iconclass + '"></i> ' + dashexpert_api.widgets.xref[v] + '</button>');
          }
          if((useLegacy && v !== 'barchart') && (useLegacy && v !== 'sparkline')) {
            $('#widget-type-select').append('<button type="button" class="btn btn-default" data-widgettype="' + v + '"><i class="fa ' + dashexpert_api.widget_preferences[v].iconclass + '"></i> ' + dashexpert_api.widgets.xref[v] + '</button>');
          }
        });
        $('#widget-type-select button[data-widgettype="all"]').addClass('active');
        $('#widget-select-container').show();
        var wid = $('#widget-selector-dropdown :selected').val();
        var vid = 'select_preview';
        $('#widget_select_preview').data('widgetid',wid);
        $('#widget-selector-dropdown').on('change', function() {
          var wid = $('#widget-selector-dropdown :selected').val();
          var vid = 'widget_select_preview';
        });
      });

      $('#widget-datasource-container').load('html/widget-datasource-container.html', function() {
        $('#widget-datasource-container').hide();
      });
    };
    var addModal = function(id,target,size) {
      $(id).remove();
      var target = target || 'body';
      var size = size || 'modal-lg';
      var html = '<div id="' + id + '" class="modal fade">\n\t<div class="modal-dialog ' + size + '">\n\t\t<div class="modal-content">\n\t\t\t<div class="modal-header">';
      html += '\n<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>\n<h4 class="modal-title"></h4>';
      html += '\n</div>\n<div class="modal-body">\n<div id="' + id + '-widget" class="panel panel-default widget-table">\n<div class="panel-body">';
      html += '\n</div>\n</div>\n</div>\n</div><!-- /.modal-content -->\n</div><!-- /.modal-dialog -->\n</div><!-- /.modal -->';
      $(target).append(html);
      //$(id).modal();
    };
    var addSearchIndicator = function(el,wid,svalues,sfields) {
      var searchMatch = dashexpert_api.settings.searchMatch[wid];
      var match = 0;
      var miss = 0;
      var all = 0;
      var label = 'danger';
      var title = 'No search terms submitted.';
      var matches = [];
      var missed = [];
      var appliedSearch = {};
      $.each(svalues, function(k,v){
        if(sfields[k]) {
          appliedSearch[k] = v;
        }
      });
      $.each(appliedSearch, function(k,v) {
        if(sfields[k]) {
          all++;
        }
        if(searchMatch[k] && sfields[k] !== undefined) {
          match++;
          matches.push(sfields[k].column_name + ': ' + appliedSearch[k]);
        } else {
          miss++;
          missed.push(sfields[k].column_name + ': ' + appliedSearch[k]);
        }
      });
      if(match === all) {
        label = 'success';
        title = 'Applied ' + match + ' of ' + all + ' searches:';
        $.each(matches, function(i) {
          title += '<br/>' + matches[i];
        });
      }
      if(match < all && match > 0) {
        label = 'warning';
        title = 'Applied ' + match + ' of ' + all + ' searches:';
        $.each(matches, function(i) {
          title += '<br/>' + matches[i];
        });
        title += '\n';
      }
      if(match < all || match === 0) {
        title = 'N/A ' + miss + ' of ' + all + ' searches:';
        $.each(missed, function(i) {
          title += '<br/>' + missed[i];
        });
      }
      var html = ' <span class="label label-' + label + '" data-toggle="tooltip" data-placement="bottom" data-html="true" title="' + title + '"><i class="fa fa-search"></i></span>';
      $('h3.panel-title span.label', el).remove();
      if(all > 0) {
        $('h3.panel-title', el).append(html);
      }
    };
    var buildSearchSelects = function() {
      var html = '';
      var daterange = dashexpert_api.searchbar.select_date;
      var resolution = dashexpert_api.searchbar.select_resolution;
      var time = dashexpert_api.searchbar.select_time;
      var endtime = dashexpert_api.searchbar.select_end_time;
      var limit = dashexpert_api.searchbar.select_limit;
      var optOpen = false;
      $.each(daterange, function(key,val) {
        if(val[1] === undefined) {
          if(val[0] === "") {
            html += '\t<option value="">' + val[0] + '</option>';
          } else {
            if(optOpen) {
              html += '</optgroup>';
              optOpen = false;
            }
            html += '\t<optgroup label="' + val[0] + '">';
            optOpen = true;
          }
        } else {
          html += '\t<option value="' + val[1] + '">' + val[0] + '</option>';
        }
      });
      if(optOpen) {
        html += '</optgroup>';
      }
      $('#srch_date').html(html);
      html = '';
      $.each(resolution, function(key,val) {
        if(val[1] !== undefined) {
          html += '\t<option value="' + val[1] + '">' + val[0] + '</option>';
        } else {
          html += '\t<option value="">' + val[0] + '</option>';
        }
      });
      $('#srch_resolution').html(html);
      html = '';
      $.each(time, function(key,val) {
        if(val[1] !== undefined) {
          html += '\t<option value="' + val[1] + '">' + val[0] + '</option>';
        } else {
          html += '\t<option value="">' + val[0] + '</option>';
        }
      });
      $('#srch_start_time').html(html);
      html = '';
      $.each(endtime, function(key,val) {
        if(val[1] !== undefined) {
          html += '\t<option value="' + val[1] + '">' + val[0] + '</option>';
        } else {
          html += '\t<option value="">' + val[0] + '</option>';
        }
      });
      $('#srch_end_time').html(html);
      $('#srch_start_time option[value="0"]').prop('selected',true);
      $('#srch_end_time option[value="23"]').prop('selected',true);
      html = '\t<option value=""></option>';
      $.each(limit, function(key,val) {
        if(val[1] !== undefined) {
          html += '\t<option value="' + val[1] + '">' + val[0] + '</option>';
        } else {
          html += '\t<option value="">' + val[0] + '</option>';
        }
      });
      $('#srch_limit').html(html);
      $('#srch_limit option[value=""]').prop('selected',true);
      $(document.body).bind().on('click', '#srch_btn, #srch_btn_top', function() {
        //clearCurrentQue();
        dashexpert_api.fn.widget_libraries.disposeAllCharts();
        getSearchValues();
        abortCurrentQue();
        dashexpert_ui.util.keepSessionAlive();
        $('.grid-stack .panel-title span.label').remove();
        amplify.clearStore('data');
        var searchValues = amplify.store('searchValues');
        var searchFields = amplify.store('searchFields');
        var appliedSearch = {};
        $.each(searchValues.search, function(k,v){
          if(searchFields[dashexpert_api.settings.currentdash][k]) {
            appliedSearch[k] = v;
          }
        });
        buildSearchFields(searchFields[dashexpert_api.settings.currentdash], getSearchValues());
        getDashboardData(dashexpert_api.settings.currentdash, function() {
          if(!$.isEmptyObject(appliedSearch)) {
            var grid = $('#' + dashexpert_api.settings.currentdash + ' .grid-stack .grid-stack-item');
            $.each(grid, function(item) {
              resizeWidget($(this));
              // apply search indicator
              var wid = $('div:first', this).data('wid');
              if(wid.startsWith('multitable')) {
                wid = $(this).find('select').val();
              }
              if(wid.startsWith('barchart-') || wid.startsWith('sparkline-') || wid.startsWith('table-') || wid.startsWith('datablocks-') || wid.startsWith('scorecard-' || wid.startsWith('amchart_'))) {
                addSearchIndicator($(this),wid,appliedSearch,searchFields[dashexpert_api.settings.currentdash]);
              }
            });
            dashexpert_api.fn.widgets.sparkline.redrawSparksBars();
          }
        });
      });
      $(document.body).bind().on('change', '#search-basis input', function() {
        if($(this).val()) {
          $(this).parent().addClass('has-success');
        } else {
          $(this).parent().removeClass('has-success');
        }
      });
      $(document).keydown(function(event){ 
        var keyCode = (event.keyCode ? event.keyCode : event.which);   
        if (keyCode == 13 && $('#search-bar').is(':visible')) {
          $('.grid-stack .panel-title span.label').remove();
          $('#srch_btn').trigger('click');
        }
      });
      $(document.body).on('click', '#srch_clear, #srch_clear_top', function() {
        dashexpert_api.fn.widget_libraries.disposeAllCharts();
        resetSearch();
      });
      var resetSearch = function() {
        $('#srch_date option:first').prop('selected',true);
        $('#srch_start_time option[value="0"]').prop('selected',true);
        $('#srch_end_time option[value="23"]').prop('selected',true);
        $('#srch_resolution option:first').prop('selected',true);
        $('#srch_limit option[value=""]').prop('selected',true);
        amplify.store('searchValues','');
        $('#search-basis input').val('');
        $('.grid-stack .panel-title span.label').remove();
        $('#srch_btn').trigger('click');
      };
    };
    var buildDashboardTable = function() {
      var html = '';
      var d = amplify.store('dashboards');
      var p = amplify.store('preferences');
      var disabled = '';
      $.each(d, function(key) {
        var checked = '';
        if(p.load_dashboards.includes(key)) {
          var checked = 'checked="checked"';
        }
        if(!d[key].hasOwnProperty('description')) {
          d[key].description = "";
        }
        if(!d[key].header.hasOwnProperty('owner')) {
          d[key].header.owner = "";
        }
        if(d[key].header.owner === 'dbieneman' || d[key].system === true) { // temporary fix to remove name
          d[key].header.owner = 'Liquidware';
        }
        if(d[key].system === true && dashexpert_api.settings.system_readonly === true) {
          disabled = ' disabled';
        } else { disabled = ''; }
        var date = new Date(d[key].header.lastupdated).toLocaleDateString("en-US");
        var time = new Date(d[key].header.lastupdated).toLocaleTimeString("en-US");
        html += '<tr data-wid="' + key + '">\n';
        if(dashexpert_api.admin === true) {
          html += '\t<td class="text-left" style="width:25%;"><a href="" data-action="edit">' + d[key].name + '</a></td>\n';
        } else {
          html += '\t<td class="text-left" style="width:25%;">' + d[key].name + '</td>\n';
        }
        html += '\t<td class="text-left" style="width:25%;"><span class="truncate-toggle truncate">' + d[key].description + '</span></td>\n';
        html += '\t<td class="text-left" style="width:15%;">' + d[key].header.owner + '</td>\n';
        html += '\t<td class="text-left" style="width:20%;" data-sort="' + d[key].header.lastupdated + '">' + date + ' ' + time + '</td>\n';
        html += '\t<td class="text-left" style="width:5%;" data-sort="' + p.load_dashboards.includes(key) + '"><input type="checkbox" value="' + key + '" data-dname="' + d[key].name + '" ' + checked + '></td>\n';
        if(dashexpert_api.admin === true) {
          html += '\t<td style="width:10%;"><button class="btn btn-primary btn-xs" data-action="edit"'+ disabled + '>Edit</button> <button class="btn btn-success btn-xs" data-action="duplicate">Duplicate</button> <button class="btn btn-danger btn-xs" data-action="delete"'+ disabled + '>Delete</button> <button class="btn btn-warning btn-xs" data-action="export"><i class="fa fa-download" title="Export"></i></button></td>';
        } else {
          html += '\t<td style="width:10%;">&nbsp;</td>';
        }
        html += '</tr>\n';
      });
      $('#t-browse-dashboards tbody').empty();
      $('#t-browse-dashboards tbody').html(html);
      if(!dashexpert_api.admin) {
        $('.btn-import').hide();
      } else {
        $('.btn-import').show();
      }
      var options = {"order" : dashexpert_api.settings.datatables.vbrowse.order,"pageLength" : dashexpert_api.settings.datatables.vbrowse.pageLength, "search" : { "search" : dashexpert_api.settings.datatables.vbrowse.search}, "displayStart" : dashexpert_api.settings.datatables.vbrowse.displayStart,"columnDefs" : [{ "orderable" : false, "targets": 5}]};
      if(dashexpert_api.settings.datatables.vbrowse.lengthMenu === undefined) {
        options.lengthMenu = [[100, -1],[100, 'All']];
      } else {
        options.lengthMenu = dashexpert_api.settings.datatables.vbrowse.lengthMenu;
      }
      if(options.pageLength < 100) {
        if(options.pageLength !== -1) {
          options.pageLength = 100;
        }
      }
      var vdtable = $('#t-browse-dashboards').DataTable(options);
      vdtable.on('search.dt', function() {
        dashexpert_api.settings.datatables.vbrowse.search = vdtable.search();
      });
      vdtable.on('length.dt', function(e, settings, len) {
        dashexpert_api.settings.datatables.vbrowse.pageLength = len;
      });
      vdtable.on('page.dt', function() {
        var info = vdtable.page.info();
        dashexpert_api.settings.datatables.vbrowse.displayStart = info.page * dashexpert_api.settings.datatables.vbrowse.pageLength;
      });
      vdtable.on('order.dt', function() {
        var order = vdtable.order();
        dashexpert_api.settings.datatables.vbrowse.order = order;
      });
      $('.btn-import').on('click.import', function(e){
        e.preventDefault();
        dashexpert_api.fn.import.importFile();
      });
      var t = $('#t-browse-dashboards input[type="checkbox"]');
      $(t).on('change', function(e) {
        dashexpert_api.fn.widget_libraries.disposeAllCharts();
        var dash = $(this).val();
        var name = $(this).data('dname');
        var p = amplify.store('preferences');
        var dashboards = amplify.store('dashboards');

        if($(this).is(':checked')) {
          $(this).parent().attr('data-sort', 'true');
          $(this).parent().data('sort', 'true');
          if($.inArray(dash,p.load_dashboards) === -1) {
            p.load_dashboards.push(dash);
          }
          p.unload_dashboards = [];
          $.each(dashboards, function(k,v) {
            if($.inArray(k,p.load_dashboards) === -1) {
              p.unload_dashboards.push(k);
            }
          });
          amplify.store('preferences',p);
          //p.unload_dashboards.splice($.inArray(dash, p.unload_dashboards),1);
          debugOut('loaded dashes: ' + p.load_dashboards);
          debugOut('unloaded dashes: ' + p.unload_dashboards);
          createGSgrid('#view-dashboard',dash,function() {
            dashexpert_api.util.debugOut('Building ' + name + ' Dashboard...');
            reorderTabs();
            if(p.editmodeon === false) {
              $('#' + dash + ' .grid-controls').hide();
            }
          });
          $('#dashboard-tabs a[data-toggle="tab"]').on('shown.bs.tab', function() {
            dashexpert_api.fn.widget_libraries.disposeAllCharts();
            //abortCurrentQue();
            var id = $(this).attr('aria-controls');
            dashexpert_api.settings.currentdash = id;
            refreshDash(id);
          });
          $('#dashboard-tabs a[data-toggle="tab"]').on('hide.bs.tab', function() {
            dashexpert_api.fn.widget_libraries.disposeAllCharts(); // dispose of all amcharts before switching to new tab
          });
        } else {
          $(this).parent().attr('data-sort', 'false');
          $(this).parent().data('sort', 'false');
          p.load_dashboards.splice(p.load_dashboards.indexOf(dash),1);

          if($('#dashboard-tabs li').length > 2) {
            $('[aria-controls="' + dash + '"]').last().parent().remove();
            $('#' + dash).last().remove();
            amplify.store('preferences',p);
          } else {
            alert('You must keep at least one dashboard displayed');
            $(this).prop('checked',true);
          }
        }
      });
    };
    var buildWidgetTable = function() {
      var html = '';
      var d = amplify.store('widgets');
      var disabled = '';
      $.each(d, function(key) {
        if(key != 'widget-preview') {
          var icon = dashexpert_api.widget_preferences[d[key].type].iconclass;
          if(!d[key].hasOwnProperty('description')) {
            d[key].description = "";
          }
          if(!d[key].hasOwnProperty('group')) {
            d[key].group = "";
          }
          if(!d[key].header.hasOwnProperty('owner')) {
            d[key].header.owner = "";
          }
          if(d[key].header.owner === 'dbieneman' || d[key].system === true) { // temporary fix to remove name
            d[key].header.owner = 'Liquidware';
          }
          if(d[key].system === true && dashexpert_api.settings.system_readonly === true) {
            disabled = ' disabled';
          } else { disabled = ''; }
          var date = new Date(d[key].header.lastupdated).toLocaleDateString("en-US");
          var time = new Date(d[key].header.lastupdated).toLocaleTimeString("en-US");
          html += '<tr data-wid="' + key + '">\n';
          html += '\t<td class="text-left" style="width:20%;"><a href="" data-action="edit">' + d[key].title + '</a></td>\n';
          html += '\t<td class="text-left" style="width:20%;"><span class="truncate-toggle truncate">' + d[key].description + '</span></td>\n';
          html += '\t<td class="text-left" style="width:10%;"><i class="fa ' + icon + '"></i> ' + dashexpert_api.widgets.xref[d[key].type] + '</td>\n';
          html += '\t<td class="text-left" style="width:10%;"><span class="truncate-toggle truncate">' + d[key].group + '</span></td>\n';
          html += '\t<td class="text-left" style="width:10%;">' + d[key].header.owner + '</td>\n';
          html += '\t<td class="text-left" style="width:15%;" data-sort="' + d[key].header.lastupdated + '">' + date + ' ' + time + '</td>\n';
          html += '\t<td style="width:15%;"><button class="btn btn-primary btn-xs" data-action="edit"' + disabled + '>Edit</button> <button class="btn btn-success btn-xs" data-action="duplicate">Duplicate</button> <button class="btn btn-danger btn-xs" data-action="delete"' + disabled + '>Delete</button></td>';
          html += '</tr>\n';
        }
      });
      $('#t-browse-widgets tbody').empty();
      $('#t-browse-widgets tbody').html(html);
      var options = {"order" : dashexpert_api.settings.datatables.wbrowse.order,"pageLength" : dashexpert_api.settings.datatables.wbrowse.pageLength, "search" : { "search" : dashexpert_api.settings.datatables.wbrowse.search}, "displayStart" : dashexpert_api.settings.datatables.wbrowse.displayStart,"columnDefs" : [{ "orderable" : false, "targets": 6}]};
      var wdtable = $('#t-browse-widgets').DataTable(options);
      wdtable.on('search.dt', function() {
        dashexpert_api.settings.datatables.wbrowse.search = wdtable.search();
      });
      wdtable.on('length.dt', function(e, settings, len) {
        dashexpert_api.settings.datatables.wbrowse.pageLength = len;
      });
      wdtable.on('page.dt', function() {
        var info = wdtable.page.info();
        dashexpert_api.settings.datatables.wbrowse.displayStart = info.page * dashexpert_api.settings.datatables.wbrowse.pageLength;
      });
      wdtable.on('order.dt', function() {
        var order = wdtable.order();
        dashexpert_api.settings.datatables.wbrowse.order = order;
      });
    };
    var buildDatasourcesTable = function() {
      var html = '';
      var basis = '';
      var d = amplify.store('datasources');
      var disabled = '';
      $.each(d, function(key) {
        if(!d[key].hasOwnProperty('description')) {
          d[key].description = "";
        }
        if(d[key].apistring.hasOwnProperty('basis')) {
          basis = d[key].apistring.basis;
        } else {
          basis = '';
        }
        if(!d[key].hasOwnProperty('group')) {
          d[key].group = "";
        }
        if(!d[key].header.hasOwnProperty('owner')) {
          d[key].header.owner = "";
        }
        if(d[key].header.owner === 'dbieneman' || d[key].system === true) { // temporary fix to remove name
          d[key].header.owner = 'Liquidware';
        }
        if(d[key].system === true && dashexpert_api.settings.system_readonly === true) {
          disabled = ' disabled';
        } else { disabled = ''; }
        var date = new Date(d[key].header.lastupdated).toLocaleDateString("en-US");
        var time = new Date(d[key].header.lastupdated).toLocaleTimeString("en-US");
        html += '<tr data-sid="' + key + '">\n';
        html += '\t<td class="text-left" style="width:20%;"><a href="" data-action="edit">' + d[key].title + '</a></td>\n';
        html += '\t<td class="text-center" style="width:10%;">' + d[key].apistring.inspector + '</td>\n';
        html += '\t<td class="text-left" style="width:20%;"><span class="truncate-toggle truncate" style="max-width: 400px;">' + basis + '</span></td>\n';
        html += '\t<td class="text-left" style="width:10%;"><span class="truncate-toggle truncate">' + d[key].group + '</span></td>\n';
        html += '\t<td class="text-left" style="width:10%;">' + d[key].header.owner + '</td>\n';
          html += '\t<td class="text-left" style="width:15%;" data-sort="' + d[key].header.lastupdated + '">' + date + ' ' + time + '</td>\n';
        html += '\t<td style="width:15%;"><button class="btn btn-primary btn-xs" data-action="edit"' + disabled + '>Edit</button> <button class="btn btn-success btn-xs" data-action="duplicate">Duplicate</button> <button class="btn btn-danger btn-xs" data-action="delete"' + disabled + '>Delete</button></td>';
        html += '</tr>\n';
      });
      $('#t-browse-datasources tbody').empty();
      $('#t-browse-datasources tbody').html(html);
      var options = {"order" : dashexpert_api.settings.datatables.dbrowse.order,"pageLength" : dashexpert_api.settings.datatables.dbrowse.pageLength, "search" : { "search" : dashexpert_api.settings.datatables.dbrowse.search}, "displayStart" : dashexpert_api.settings.datatables.dbrowse.displayStart,"columnDefs" : [{ "orderable" : false, "targets": 6}]};
      var ddtable = $('#t-browse-datasources').DataTable(options);
      ddtable.on('search.dt', function() {
        dashexpert_api.settings.datatables.dbrowse.search = ddtable.search();
      });
      ddtable.on('length.dt', function(e, settings, len) {
        dashexpert_api.settings.datatables.dbrowse.pageLength = len;
      });
      ddtable.on('page.dt', function() {
        var info = ddtable.page.info();
        dashexpert_api.settings.datatables.dbrowse.displayStart = info.page * dashexpert_api.settings.datatables.dbrowse.pageLength;
      });
      ddtable.on('order.dt', function() {
        var order = ddtable.order();
        dashexpert_api.settings.datatables.dbrowse.order = order;
      });
    };
    // Page specific Initializations
    var initPage = function(page) {
      if(page != 'view-dashboard.html') {
        //abortCurrentQue();
        $('#dashboard-tabs').hide();
        $('.scrtabs-tab-container').hide();
        $('#search-toggle').hide();
      } else {
        $('#dashboard-tabs').show();
        //$('#dashboard-tabs').scrollingTabs('refresh');
        $('.scrtabs-tab-container').show();
        $('#search-toggle').show();
      }
      if(page === 'view-dashboard.html') {
        if($('#dashboard-tabs li').length > 1) {
          $('#dashboard-tabs a:first').tab('show');
        }
        $('#dashboard-tabs').scrollingTabs('refresh');
        if(!dashexpert_api.init.dash_loaded) {
          loadWidgetModal();
          addModal('ext-dashboard-modal');
          addModal('save-dashboard-modal');
          dashexpert_api.init.dash_loaded = true;
        }
      }
      if(page === 'view-widgets-create.html') {
        $('#view-widgets-edit').empty();
        $('#ui-widget-buttons').hide();
        $('#outer-widget-container').hide();
        // $.each(dashexpert_api.widgets.types, function(i,val) {
        //   var name = val.charAt(0).toUpperCase() + val.substr(1);
        //   $('#in-widget-select').append('<option value="' + val + '">' + name + '</option>');
        // });
        $.each(dashexpert_api.widgets.xref, function(key,val) {
          debugOut(val);
          if(dashexpert_api.settings.use_legacy_charts) {
            if(key !== 'amchart_line' && key !== 'amchart_bar') {
              $('#in-widget-select').append('<option value="' + key + '">' + val + '</option>');
            }
          }
          if(!dashexpert_api.settings.use_legacy_charts) {
            if(key !== 'sparkline' && key !== 'barchart') {
              $('#in-widget-select').append('<option value="' + key + '">' + val + '</option>');
            }
          }
        });
        $('#in-widget-select-btn').on('click', function(e) {
          e.preventDefault();
          var widgettype = $('#in-widget-select').val();
          createWidgetForm(widgettype);
          $('#ui-widget-buttons').show();
        });
      }
      if(page === 'view-dashboards-browse.html') {
        buildDashboardTable();
        $('#t-browse-dashboards').on('click', '[data-action="edit"]', function(e) {
          e.preventDefault();
          var dashboards = amplify.store('dashboards');
          var wid = $(this).parent().parent().data('wid');
          dashboards[wid].system = dashboards[wid].system || JSON.parse(dashexpert_api.settings.system);
          if(JSON.parse(dashboards[wid].system) === true && dashexpert_api.settings.system_readonly === true) {
            dashexpert_ui.util.createAlert('System Dashboards protected.','warning','views-alert');
          } else {
            createDashboardForm(wid);
            dashexpert_api.settings.currentdash = wid;
            dashexpert_api.settings.currentgrid = dashboards[wid].grid;
            $('#save-dashboard-modal').modal('show');
          }
        });
        $('#t-browse-dashboards').on('click', '[data-action="duplicate"]', function(e) {
          e.preventDefault();
          var dashboards = amplify.store('dashboards');
          var wid = $(this).parent().parent().data('wid');
          duplicateItem(dashboards[wid],'dashboard',function(){
            dashexpert_api.fn.dashboards.getAllDashboards(function() {
              dashexpert_api.init.pagesLoaded.splice($.inArray('view-dashboards-browse.html',dashexpert_api.init.pagesLoaded),1);
              loadHTML('#view-dashboards-browse','view-dashboards-browse.html');
            });
          });
        });
        $('#t-browse-dashboards').on('click', 'button[data-action="delete"]', function(e) {
          e.preventDefault();
          if(!$(this).hasClass('btn-default')) {
            var wid = $(this).parent().parent().data('wid');
            var d = amplify.store('dashboards');
            d[wid].system = d[wid].system || JSON.parse(dashexpert_api.settings.system);
            if(JSON.parse(d[wid].system) === true && dashexpert_api.settings.system_readonly === true) {
              dashexpert_ui.util.createAlert('System Dashboards protected.','warning','views-alert');
            } else {
              var r = confirm('Are you sure you want to delete "' + d[wid].name + '"?');
              if(r === true) {
                dashexpert_api.util.debugOut('dashboard deleted.');
                dashexpert_api.fn.dashboards.deleteDash(wid);
                $('[aria-controls="' + wid + '"]').parent().remove();
                $('#' + wid).remove();
                dashexpert_ui.util.createAlert('Dashboard Deleted Successfully.','success','views-alert');
                dashexpert_api.fn.dashboards.getAllDashboards(function() {
                  dashexpert_api.init.pagesLoaded.splice($.inArray('view-dashboards-browse.html',dashexpert_api.init.pagesLoaded),1);
                  loadHTML('#view-dashboards-browse','view-dashboards-browse.html');
                });
              } else {
                dashexpert_api.util.debugOut('aborted delete.');
              }
            }
          }
        });
        $('#t-browse-dashboards').on('click', 'button[data-action="export"]', function(e) {
          e.preventDefault();
          var wid = $(this).parent().parent().data('wid');
          exportDashboard(wid);
        }); 
      }
      if(page === 'view-widgets-browse.html') {
        buildWidgetTable();
        $('#t-browse-widgets').on('click', '[data-action="edit"]', function(e) {
          e.preventDefault();
          var widgets = amplify.store('widgets');
          var wid = $(this).parent().parent().data('wid');
          widgets[wid].system = widgets[wid].system || JSON.parse(dashexpert_api.settings.system);
          if(JSON.parse(widgets[wid].system) === true && dashexpert_api.settings.system_readonly === true) {
            dashexpert_ui.util.createAlert('System Widgets protected.','warning','views-alert');
          } else {
            dashexpert_api.currentWidget = wid;
            loadHTML('#view-widget-edit','view-widget-edit.html');
          }
        });
        $('#t-browse-widgets').on('click', '[data-action="duplicate"]', function(e) {
          e.preventDefault();
          var widgets = amplify.store('widgets');
          var wid = $(this).parent().parent().data('wid');
          duplicateItem(widgets[wid],'widget',function(){
            dashexpert_api.fn.widgets.getAllWidgets(function() {
              dashexpert_api.init.pagesLoaded.splice($.inArray('view-widgets-browse.html',dashexpert_api.init.pagesLoaded),1);
              loadHTML('#view-widgets-browse','view-widgets-browse.html');
            });
          });
        });
        $('#t-browse-widgets').on('click', 'button[data-action="delete"]', function(e) {
          e.preventDefault();
          var wid = $(this).parent().parent().data('wid');
          var d = amplify.store('widgets');
          d[wid].system = d[wid].system || JSON.parse(dashexpert_api.settings.system);
          if(JSON.parse(d[wid].system) === true && dashexpert_api.settings.system_readonly === true) {
            dashexpert_ui.util.createAlert('System Widgets protected.','warning','views-alert');
          } else {
            var r = confirm('Are you sure you want to delete "' + d[wid].title + '"?');
            if(r === true) {
              dashexpert_api.util.debugOut('widget deleted.');
              dashexpert_api.fn.widgets.deleteWidget(wid);
              dashexpert_ui.util.createAlert('Widget Deleted Successfully.','success','views-alert');
              dashexpert_api.fn.widgets.getAllWidgets(function() {
                dashexpert_api.init.pagesLoaded.splice($.inArray('view-widgets-browse.html',dashexpert_api.init.pagesLoaded),1);
                loadHTML('#view-widgets-browse','view-widgets-browse.html');
              });
            } else {
              dashexpert_api.util.debugOut('aborted delete.');
            }
          }
        }); 
      }
      if(page === 'view-datasources-browse.html') {
        buildDatasourcesTable();
        $('#t-browse-datasources').on('click', '.truncate-toggle', function(e) {
          $(this).toggleClass('truncate');
        });
        $('#t-browse-datasources').on('click', '[data-action="edit"]', function(e) {
          e.preventDefault();
          var ds = amplify.store('datasources');
          var sid = $(this).parent().parent().data('sid');
          ds[sid].system = ds[sid].system || JSON.parse(dashexpert_api.settings.system);
          if(JSON.parse(ds[sid].system) === true && dashexpert_api.settings.system_readonly === true) {
            dashexpert_ui.util.createAlert('System Datasource protected.','warning','views-alert');
          } else {
            dashexpert_api.currentDatasource = sid;
            loadHTML('#view-datasource-edit','view-datasource-edit.html');
          }
        });
        $('#t-browse-datasources').on('click', '[data-action="duplicate"]', function(e) {
          e.preventDefault();
          var ds = amplify.store('datasources');
          var sid = $(this).parent().parent().data('sid');
          duplicateItem(ds[sid],'datasource',function(){
            dashexpert_api.fn.datasources.getAllDatasources(function() {
              dashexpert_api.init.pagesLoaded.splice($.inArray('view-datasources-browse.html',dashexpert_api.init.pagesLoaded),1);
              loadHTML('#view-datasources-browse','view-datasources-browse.html');
            });
          });
        });
        $('#t-browse-datasources').on('click', 'button[data-action="delete"]', function(e) {
          e.preventDefault();
          var sid = $(this).parent().parent().data('sid');
          var d = amplify.store('datasources');
          d[sid].system = d[sid].system || JSON.parse(dashexpert_api.settings.system);
          if(JSON.parse(d[sid].system) === true && dashexpert_api.settings.system_readonly === true) {
            dashexpert_ui.util.createAlert('System Datasource protected.','warning','views-alert');
          } else {
            var r = confirm('Are you sure you want to delete "' + d[sid].title + '"?');
            if(r === true) {
              dashexpert_api.util.debugOut('datasource deleted.');
              dashexpert_api.fn.datasources.deleteDatasource(sid);
              dashexpert_ui.util.createAlert('Datasource Deleted Successfully.','success','views-alert');
              dashexpert_api.fn.datasources.getAllDatasources(function() {
                dashexpert_api.init.pagesLoaded.splice($.inArray('view-datasources-browse.html',dashexpert_api.init.pagesLoaded),1);
                loadHTML('#view-datasources-browse','view-datasources-browse.html');
              });
            } else {
              dashexpert_api.util.debugOut('aborted delete.');
            }
          }
        });
      }
      if(page === 'view-datasource-create.html') {
        dashexpert_api.currentDatasource = '';
        createDatasourceForm();
        //initAPIBuilder();
      }
      if(page === 'view-widget-edit.html') {
        $('#view-widgets-create').empty();
        var widgets = amplify.store('widgets');
        var wid = dashexpert_api.currentWidget;
        var widgettype = widgets[wid].type;
        createWidgetForm(widgettype,wid);
      }
      if(page === 'view-datasource-edit.html') {
        var vid = dashexpert_api.currentDatasource;
        createDatasourceForm(vid);
        initAPIBuilder();
      }
      $(".btn[data-view-toggle]").on("click", function(e){
        e.preventDefault();
        abortCurrentQue();
        var currentView = $('.nav .active a').data('view-toggle');
        var newView = $(this).data('view-toggle');
        $(".nav").find(".active").removeClass("active");
        $(this).parent().addClass("active");
        if(newView) {
          loadHTML('#' + newView,newView + '.html');
        }
      });
    };

// EXPOSE PUBLIC FUNCTIONS
    dashexpert_ui.util = {
      debugOut : debugOut,
      createAlert : createAlertLegacy,
      createPopupAlert : createAlertNew,
      createRemoteStatus : createRemoteStatus,
      checkSession : checkSession,
      checkLogin : checkLogin,
      toggleLogin : toggleLogin,
      addModal : addModal,
      keepSessionAlive : keepSessionAlive,
      buildWidgetSelector : buildWidgetSelector
    };
    dashexpert_api.fn.retrieveData = retrieveData;
    dashexpert_api.fn.clearLocalData = clearLocalData;
    dashexpert_api.fn.dataExists = dataExists;
    dashexpert_api.util = {
        debugOut : debugOut,
        checkLogin : checkLogin,
        fixJSON : fixJSON,
        getCurrentQue : getCurrentQue,
        clearCurrentQue : clearCurrentQue,
        abortCurrentQue : abortCurrentQue
    };
    dashexpert_api.fn.dashboards = {
        getAllDashboards : getAllDashboards,
        getDash : getDash,
        saveDash : saveDash,
        deleteDash : deleteDash,
        refreshDash : refreshDash,
        exportDash : exportDashboard
    };
    dashexpert_api.fn.datasources = {
        getAllDatasources : getAllDatasources,
        getDatasource : getDatasource,
        saveDatasource : saveDatasource,
        deleteDatasource : deleteDatasource
    };
    dashexpert_api.fn.widgets = {
        getAllWidgets : getAllWidgets,
        getWidget : getWidget,
        saveWidget : saveWidget,
        deleteWidget : deleteWidget
    };
// END Library code
}));