// IIFE
var dashexpert_api = dashexpert_api || {};
var dashexpert_ui = dashexpert_ui || {};
(function(library) {
  // global jQuery object is passed as a parameter
  library(window.jQuery, window, document);

  }(function($, window, document) { 
  	$(function() {
    // START Document Ready

	// END Document Ready
    });
	// Private Functions
	// HEX ENCODING FUNCTIONS
	var d2h = function(d) {
	    return d.toString(16);
	};
	var h2d = function(h) {
	    return parseInt(h, 16);
	};
	var stringToHex = function(tmp) {
	    var str = '',
	        i = 0,
	        tmp_len = tmp.length,
	        c;
	 
	    for (; i < tmp_len; i += 1) {
	        c = tmp.charCodeAt(i);
	        str += d2h(c);
	    }
	    return str;
	};
	var hexToString = function(tmp) {
	    var arr = tmp.match(/.{2}/g),
	        str = '',
	        i = 0,
	        arr_len = arr.length,
	        c;
	 
	    for (; i < arr_len; i += 1) {
	        c = String.fromCharCode( h2d( arr[i] ) );
	        str += c;
	    }
	 
	    return str;
	};
	var stringToBase64 = function(str) {
		str = window.btoa(encodeURIComponent(str));
		return str;
	};
	var Base64toString = function(str) {
		str = decodeURIComponent(window.atob(str));
		return str;
	};
	// Utilities
	var encodeJSON = function(json,encoding) { // encoding: 0 = hex, 1 = base64
		var e = encoding || 0;
		json = addHeaderInfo(json);
		var str = JSON.stringify(json);
		switch(e) {
			case 0: 
				str = stringToHex(str);
				return str;
			case 1:
				str = stringToBase64(str);
				return str;
		}
	};
	var decodeJSON = function(str,encoding) {
		var e = encoding || 0;
		var json;
		switch(e) {
			case 0: 
				json = hexToString(str);
				json = JSON.parse(json);
				return json;
			case 1:
				json = Base64toString(str);
				json = JSON.parse(json);
				return json;
		}
	};
	var legacyDecodeCheck = function(str) {
		var en = 1;
		if(str.startsWith('7b')) {
			en = 0;
		}
		return en;
	};
	function parseJwt(token) {
        var base64Url = token.split('.')[1];
        var base64 = base64Url.replace('-', '+').replace('_', '/');
        return JSON.parse(window.atob(base64));
    }
	var getCookie = function(cname) {
	    var name = cname + "=";
	    var ca = document.cookie.split(';');
	    for(var i=0; i<ca.length; i++) {
	        var c = ca[i];
	        while (c.charAt(0)==' ') c = c.substring(1);
	        if (c.indexOf(name) === 0) return c.substring(name.length,c.length);
	    }
	    return "";
	};
	const getCookieES6 = function(cname) {
	    const cookie = document.cookie.split(';');
			const cookieObj = {};
			cookie.forEach((str) => {
				let pair = str.split('=');
				cookieObj[pair[0].trim()] = pair[1];
			});
			return cookieObj[cname] || '';
	};
	var addHeaderInfo = function(json) {
		var header = json.header || {};
		json.header = header;
		var userinfo = amplify.store('userinfo');
		header.creator = header.creator || userinfo.name;
		header.creatorid = header.creatorid || userinfo.id;
		header.lastupdated = new Date().getTime();
		header.created = header.created || header.lastupdated;
		header.owner = userinfo.name;
		header.ownerid = userinfo.id;
		if(json.header.groups === undefined || json.header.groups[0] === '') {
			var groups = [];
			$.each(userinfo.groups, function(i){
				groups.push(userinfo.groups[i].id.toString());
			});
			header.groups = groups;
		} else {
			header.groups = json.header.groups;
		}
		json.header = header;
		return json;
	};
	var checkPermission = function(item) {
		var info = amplify.store('userinfo');
		var groups = [];
		$.each(info.groups, function(i) {
			groups.push(info.groups[i].id.toString());
		});
		var pass = true;
		var con = true;
		if(groups.length > 0) {
			pass = false;
			$.each(item.header.groups, function(i) {
				if(groups.includes(item.header.groups[i].toString())) {
					pass = true;
				}
			});
		} else {
			pass = true;
		}
		if(item.publish === false) {
			if(item.header.creatorid === info.id || item.header.ownerid === info.id) {
				con = false;
			} else {
				pass = false;
				con = false;
			}
		}
		return pass;
	};
	var updateLegacyGroupID = function(item) {
		var ritem = item;
		var groups = [];
		var dash_user ={};
		var dash_admin = {};
		var AllGroups = dashexpert_api.usergroups;
		if(dashexpert_api.usergroups === undefined) {
			getUserGroups(function() {
				AllGroups = dashexpert_api.usergroups;
				//console.log(AllGroups);
				$.each(AllGroups, function(i) {
					if($.inArray(AllGroups[i].name, dashexpert_api.settings.dash_admin_group) != -1) {
						dash_admin[AllGroups[i].name] = AllGroups[i].id;
					}
					if($.inArray(AllGroups[i].name, dashexpert_api.settings.dash_user_group) != -1) {
						dash_user[AllGroups[i].name] = AllGroups[i].id;
					}
				});
				$.each(item.header.groups, function(i) {
					if(item.header.groups[i] === '3') {
						groups.push(dash_user.dash_user.toString());
					}
					if(item.header.groups[i] === '4') {
						groups.push(dash_admin.dash_admin.toString());
					}
				});
				ritem.header.groups = groups;
				return ritem;
			});
		} else {
			$.each(AllGroups, function(i) {
				if($.inArray(AllGroups[i].name, dashexpert_api.settings.dash_admin_group) != -1) {
					dash_admin[AllGroups[i].name] = AllGroups[i].id;
				}
				if($.inArray(AllGroups[i].name, dashexpert_api.settings.dash_user_group) != -1) {
					dash_user[AllGroups[i].name] = AllGroups[i].id;
				}
			});
			$.each(item.header.groups, function(i) {
				if(item.header.groups[i] === '3') {
					groups.push(dash_user.dash_user.toString());
				}
				if(item.header.groups[i] === '4') {
					groups.push(dash_admin.dash_admin.toString());
				}
			});
			ritem.header.groups = groups;
			return ritem;
		}
	};
	var getAllConfigs = function(type,callback,params) { //params optional to limit by groupIds or userId
		var lwlApiToken = getCookie('lwlApiToken');
		var urlparams = "";
		if(params !== null && typeof params === 'object') {
			if(params.groupIds) {
				urlparams = '&groupIds=' + params.groupIds;
			}
			if(params.ownerId) {
				urlparams = '&ownerId=' + params.ownerId;
			}
		}
		var qname = dashexpert_api.util.getCurrentQue();
		$.ajaxq(qname,{
	        beforeSend: function() {
	            $('#loadingmsg').text('loading ' + type + 's...');
	            $('#loadingmsg').show();
	        },
	        success: function()
	        { 
	        },
	        cache: false,
	        processData: false,
	        method: 'GET',
	        headers: {'lwlApiToken': lwlApiToken},
	        url: '/api/v1/dashboard?type=' + type + urlparams
	    }).done(function(data, textStatus, jqXHR){
	    		$('#loadingmsg').hide();
	    		var rdata = {};
	    		if(data.length > 0) {
		    		$.each(data, function(key) {
		    			var encoding = legacyDecodeCheck(data[key].description);
		    			var decoded = decodeJSON(data[key].description,encoding);
		    			var name = data[key].name;
	        		rdata[name] = decoded;
	        		if(data[key].system) {
	        			rdata[name].publish = true;		
	        		}
	        		
	        		if(type === 'dashboard') {
	        			var groupIds = data[key].groupIds;
	        			if(rdata[name].groups !== undefined) {
	        				if(rdata[name].groups.length === 1 && rdata[name].groups[0] === '') {
	        					rdata[name].groups = rdata[name].header.groups;
	        				}
	        				if(rdata[name].groups.length > 0) {
	        					rdata[name].header.groups = rdata[name].groups;
	        				}
	        			}
	        			if(groupIds !== null) {
        					rdata[name].header.groups = groupIds;
        				}
	        			var pass = checkPermission(rdata[name]);
	        			if(!pass) {
	        				delete rdata[name];
	        			}
		        		if(!data[key].system) {
		        			if(!pass) {
		        				delete rdata[name];
		        			}
		        		}
	        		}
	        	});
	    		} else {
	    			dashexpert_ui.util.createAlert('No ' + type + 's found.','warning',type + 's-alert');
	    		}
	    		if(callback && typeof callback === 'function') {
	    			callback(rdata);
	    		}
	    		return rdata;
	        }).fail(function(jqXHR,textStatus,errorThrown){
	        	$('#loadingmsg').hide();
	            dashexpert_api.util.debugOut(textStatus + ' | ' + errorThrown);
	            //dashexpert_ui.util.createAlert('Not Authorized.  Please login to <a href="/">Stratusphere</a>.','warning','api-alert','#alerts',true);
	            if(callback && typeof callback === 'function') {
	    			callback(false);
	    		}
	    });
	};
	var readConfig = function(name,type,callback) {
	    var lwlApiToken = getCookie('lwlApiToken');
		var qname = dashexpert_api.util.getCurrentQue();
		$.ajaxq(qname,{
	        beforeSend: function() {
	            $('#loadingmsg').text('loading view...');
	            $('#loadingmsg').show();
	        },
	        cache: false,
	        method: 'GET',
	        headers: {'lwlApiToken': lwlApiToken},
	        data: ({
	        	type: type,
	        	name: name
	        }),
	        url: '/api/v1/dashboard',
	        success: function(data){
	        	dashexpert_api.util.debugOut(data);
	        	var encoding = legacyDecodeCheck(data[0].description);
	        	var decoded = decodeJSON(data[0].description,encoding);
	        	decoded.system = data.system;
	        	$('#loadingmsg').hide();
	        	if(callback && typeof callback === 'function') {
	    			callback(decoded);
	    		}
	    		return decoded;
	        },
	        error: function(xhr,text,error) {
	        	$('#loadingmsg').hide();
	        	dashexpert_api.util.debugOut(text + ' | ' + error);
	        	if(callback && typeof callback === 'function') {
	    			callback(false);
	    		}
	        }
	    });
	};
	var createConfig = function(json,name,type,callback) {
	    var lwlApiToken = getCookie('lwlApiToken');
	    var encoded = encodeJSON(json,1);
		var qname = dashexpert_api.util.getCurrentQue();
		$.ajaxq(qname,{
	        beforeSend: function() {
	            $('#loadingmsg').text('Saving ' + type + '...');
	            $('#loadingmsg').show();
	        },
	        cache: false,
	        method: 'POST',
	        processData: false,
	        contentType: 'application/json',
	        headers: {'lwlApiToken': lwlApiToken},
	        data: JSON.stringify({
	        	type: type,
	        	name: name,
	        	description: encoded,
	        	system: json.system
	        }),
	        url: '/api/v1/dashboard',
	        success: function(data){
	        	dashexpert_api.util.debugOut(data);
	        	$('#loadingmsg').hide();
	        	if(callback && typeof callback === 'function') {
	    			callback(true);
	    		}
	        },
	        error: function(xhr,text,error) {
	        	$('#loadingmsg').hide();
	        	dashexpert_api.util.debugOut(text + ' | ' + error);
	        	if(callback && typeof callback === 'function') {
	    			callback(false);
	    		}
	        }
	    });
	};
	var beforeUpdate = function(json,name,type,callback) {
		if(type === 'datasource' || type === 'widget' || type === 'dashboard') {
			var lastupdated = json.lastsave;
			var userinfo = amplify.store('userinfo');
			readConfig(name,type,function(decoded) {
				if( decoded.header.lastupdated <= lastupdated || decoded.header.ownerid === userinfo.ownerid || dashexpert_api.settings.ignore_lastupdate === true) {
					updateConfig(json,name,type,callback);
				} else {
					var r = confirm(type + ' has been updated by another user since you started updating.  Are you sure you want to overwite their changes?');
					if(r === true) {
						updateConfig(json,name,type,callback);
					} else {
						dashexpert_ui.util.createAlert('Save Cancelled.','warning','crud-alert');
					}
				}
			});
		} else {
			updateConfig(json,name,type,callback);
		}
		
	};
	var updateConfig = function(json,name,type,callback) {
	    var lwlApiToken = getCookie('lwlApiToken');
	    var encoded = encodeJSON(json,1);
		var qname = dashexpert_api.util.getCurrentQue();
		$.ajaxq(qname,{
	        beforeSend: function() {
	            $('#loadingmsg').text('Updating ' + type + '...');
	            $('#loadingmsg').show();
	        },
	        method: 'PUT',
	        processData: false,
	        contentType: 'application/json',
	        headers: {'lwlApiToken': lwlApiToken},
	        data: JSON.stringify({
	        	type: type,
	        	name: name,
	        	description: encoded,
	        	system: json.system
	        }),
	        url: '/api/v1/dashboard',
	        success: function(data){
	        	dashexpert_api.util.debugOut(data);
	        	$('#loadingmsg').hide();
	        	if(callback && typeof callback === 'function') {
	    			callback(true);
	    		}
	        },
	        error: function(xhr,text,error) {
	        	$('#loadingmsg').hide();
	        	dashexpert_api.util.debugOut(text + ' | ' + error);
	        	if(callback && typeof callback === 'function') {
	    			callback(false);
	    		}
	        }
	    });
	};
	var deleteConfig = function(name,type,callback) {
	    var lwlApiToken = getCookie('lwlApiToken');
		var qname = dashexpert_api.util.getCurrentQue();
		$.ajaxq(qname,{
	        type: 'POST',
	        beforeSend: function() {
	            $('#loadingmsg').text('Deleting view...');
	            $('#loadingmsg').show();
	        },
	        method: 'DELETE',
	        processData: false,
	        contentType: 'application/json',
	        headers: {'lwlApiToken': lwlApiToken},
	        data: JSON.stringify({
	        	name: name,
	        	type: type
	        }),
	        url: '/api/v1/dashboard',
	        success: function(data){
	        	dashexpert_api.util.debugOut(data);
	        	$('#loadingmsg').hide();
	        	if(callback && typeof callback === 'function') {
	    			callback(true);
	    		}
	        },
	        error: function(xhr,text,error) {
	        	$('#loadingmsg').hide();
	        	dashexpert_api.util.debugOut(text + ' | ' + error);
	        	if(callback && typeof callback === 'function') {
	    			callback(false);
	    		}
	        }
	    });
	};
	var getUserGroups = function(callback) {
		var lwlApiToken = getCookie('lwlApiToken');
		//var qname = dashexpert_api.util.getCurrentQue();
		$.ajax({
	        type: 'POST',
	        beforeSend: function() {
	        	dashexpert_api.util.debugOut('getting user/groups');
	        },
	        cache: true,
	        method: 'GET',
	        headers: {'lwlApiToken': lwlApiToken},
	        data: ({
	        }),
	        url: '/api/v1/inventory/user/group',
	        success: function(data){
	        	dashexpert_api.usergroups = {};
	        	dashexpert_api.util.debugOut(data);
	        	if(data.length > 0) {
		    		$.each(data, function(key) {
		        		dashexpert_api.usergroups[data[key].id] = data[key];
		        	});
		    		} else {
		    			dashexpert_ui.util.createAlert('No groups found.','warning','usergroups-alert');
		    		}
		    		if(callback) {
		    			callback(data);
		    		}
	        },
	        error: function(xhr,text,error) {
	        	dashexpert_api.util.debugOut(text + ' | ' + error);
	        	if(callback && typeof callback === 'function') {
	    			callback(false);
	    		}
	        }
	    });
	};
	var getUserInfo = function(callback) {
		getUserName(function(data) {
			if(data.id) {
				dashexpert_api.util.debugOut(data);
				getUserGroupInfo(data.id,function(result) {
					data.groups = result;
					dashexpert_api.util.debugOut(data);
					amplify.store('userinfo', data);
					if(callback) {
						callback(data);
					}
				});
			}
		});
	};
	var getUserName = function(callback) {
		var lwlApiToken = getCookie('lwlApiToken');
		var lwlUserInfo = parseJwt(getCookie('lwlUserInfo'));
		var qname = dashexpert_api.util.getCurrentQue();
		$.ajaxq(qname,{
	        type: 'POST',
	        beforeSend: function() {
	        	dashexpert_api.util.debugOut('getting user/groups');
	        },
	        cache: true,
	        method: 'GET',
	        headers: {'lwlApiToken': lwlApiToken},
	        data: ({
	        }),
	        url: '/api/v1/inventory/user/' + lwlUserInfo.userId,
	        success: function(data){
	        	var result;
	        	if(data.name && data.id) {
		    		result = { name: data.name, id: data.id };
	    		} else {
	    			result = { error: 'No groups found.' };
	    		}
	    		if(callback) {
	    			callback(result);
	    		}
	        },
	        error: function(xhr,text,error) {
	        	dashexpert_api.util.debugOut(text + ' | ' + error);
	        	if(callback && typeof callback === 'function') {
	    			callback(false);
	    		}
	        }
	    });
	};
	var getUserGroupInfo = function(id,callback) {
		var lwlApiToken = getCookie('lwlApiToken');
		var qname = dashexpert_api.util.getCurrentQue();
		$.ajaxq(qname,{
	        type: 'POST',
	        beforeSend: function() {
	        	dashexpert_api.util.debugOut('getting user/groups');
	        },
	        cache: true,
	        method: 'GET',
	        headers: {'lwlApiToken': lwlApiToken},
	        data: ({
	        }),
	        url: '/api/v1/inventory/user/' + id + '/groups',
	        success: function(data){
	        	var result = [];
	        	if(data.length > 0) {
		    		$.each(data, function(key) {
		    			result.push({id: data[key].id, name: data[key].name});
		        	});
	    		} else {
	    			result = { error: 'No groups found.' };
	    		}
	    		//console.log(result);
	    		if(callback) {
	    			callback(result);
	    		}
	        },
	        error: function(xhr,text,error) {
	        	//console.log(text + ' | ' + error);
	        	dashexpert_api.util.debugOut(text + ' | ' + error);
	        	if(callback && typeof callback === 'function') {
	    			callback(false);
	    		}
	        }
	    });
	};
	// END CODE
	// EXPOSE PUBLIC FUNCTIONS
	dashexpert_api.crud = {};
	dashexpert_api.crud.legacyDecodeCheck = legacyDecodeCheck;
	dashexpert_api.crud.encodeJSON = encodeJSON;
	dashexpert_api.crud.decodeJSON = decodeJSON;
	dashexpert_api.crud.delete = deleteConfig;
	dashexpert_api.crud.create = createConfig;
	dashexpert_api.crud.read = readConfig;
	dashexpert_api.crud.all = getAllConfigs;
	dashexpert_api.crud.update = beforeUpdate;
	dashexpert_api.auth = {};
	dashexpert_api.auth.groups = getUserGroups;
	dashexpert_api.auth.user = getUserInfo;
  } // END IIFE
));